/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import io.sarl.lang.core.Address;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import java.util.Collection;
import org.eclipse.xtext.xbase.lib.Functions;

public interface InternalEventBusCapacity
extends Capacity {
    public OwnerState getOwnerState();

    @Deprecated
    public void registerEventListener(Object var1);

    public void registerEventListener(Object var1, boolean var2, Functions.Function1<? super Event, ? extends Boolean> var3, Object ... var4);

    @Deprecated
    public void unregisterEventListener(Object var1);

    public void unregisterEventListener(Object var1, boolean var2);

    public boolean hasRegisteredEventListener(Class<?> var1);

    public <T> int getRegisteredEventListeners(Class<T> var1, Collection<? super T> var2);

    public void selfEvent(Event var1);

    public EventListener asEventListener();

    public Address getInnerDefaultSpaceAddress();

    public static class ContextAwareCapacityWrapper<C extends InternalEventBusCapacity>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements InternalEventBusCapacity {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        @Override
        public OwnerState getOwnerState() {
            try {
                this.ensureCallerInLocalThread();
                OwnerState ownerState = ((InternalEventBusCapacity)this.capacity).getOwnerState();
                return ownerState;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        @Deprecated
        public void registerEventListener(Object listener) {
            try {
                this.ensureCallerInLocalThread();
                ((InternalEventBusCapacity)this.capacity).registerEventListener(listener);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void registerEventListener(Object listener, boolean fireInitializeEvent, Functions.Function1<? super Event, ? extends Boolean> filter, Object ... initializationParameters) {
            try {
                this.ensureCallerInLocalThread();
                ((InternalEventBusCapacity)this.capacity).registerEventListener(listener, fireInitializeEvent, filter, initializationParameters);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        @Deprecated
        public void unregisterEventListener(Object listener) {
            try {
                this.ensureCallerInLocalThread();
                ((InternalEventBusCapacity)this.capacity).unregisterEventListener(listener);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void unregisterEventListener(Object listener, boolean fireDestroyEvent) {
            try {
                this.ensureCallerInLocalThread();
                ((InternalEventBusCapacity)this.capacity).unregisterEventListener(listener, fireDestroyEvent);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean hasRegisteredEventListener(Class<?> type) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((InternalEventBusCapacity)this.capacity).hasRegisteredEventListener(type);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public <T> int getRegisteredEventListeners(Class<T> type, Collection<? super T> collection) {
            try {
                this.ensureCallerInLocalThread();
                int n = ((InternalEventBusCapacity)this.capacity).getRegisteredEventListeners(type, collection);
                return n;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void selfEvent(Event event) {
            try {
                this.ensureCallerInLocalThread();
                ((InternalEventBusCapacity)this.capacity).selfEvent(event);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public EventListener asEventListener() {
            try {
                this.ensureCallerInLocalThread();
                EventListener eventListener = ((InternalEventBusCapacity)this.capacity).asEventListener();
                return eventListener;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Address getInnerDefaultSpaceAddress() {
            try {
                this.ensureCallerInLocalThread();
                Address address = ((InternalEventBusCapacity)this.capacity).getInnerDefaultSpaceAddress();
                return address;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }

    public static enum OwnerState {
        UNSTARTED{

            @Override
            public boolean isEventHandling() {
                return true;
            }
        }
        ,
        INITIALIZING{

            @Override
            public boolean isEventHandling() {
                return true;
            }
        }
        ,
        ALIVE{

            @Override
            public boolean isEventHandling() {
                return true;
            }
        }
        ,
        DYING{

            @Override
            public boolean isEventHandling() {
                return false;
            }
        }
        ,
        DEAD{

            @Override
            public boolean isEventHandling() {
                return false;
            }
        };


        public abstract boolean isEventHandling();
    }
}

