/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.sarl.core.InnerContextAccess;
import io.sarl.core.OpenEventSpace;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.ClearableReference;
import io.sarl.lang.util.SynchronizedIterable;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.concurrent.Collections3;
import io.sarl.util.concurrent.NoReadWriteLock;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class InnerContextSkill
extends BuiltinSkill
implements InnerContextAccess {
    private static int installationOrder = -1;
    private final Address agentAddressInInnerDefaultSpace;
    private ClearableReference<Skill> skillBufferInternalEventBusCapacity;
    private AgentContext innerContext;
    private ReadWriteLock innerContextLock;
    private ContextSpaceService contextService;

    InnerContextSkill(Agent agent, Address agentAddressInInnerDefaultSpace) {
        super(agent);
        this.agentAddressInInnerDefaultSpace = agentAddressInInnerDefaultSpace;
    }

    @Inject
    public final void setContextSpaceService(ContextSpaceService contextService) {
        this.contextService = contextService;
    }

    @Inject
    public final void setLockProvider(Provider<ReadWriteLock> provider) {
        this.innerContextLock = provider.get();
    }

    public final ReadWriteLock getLock() {
        return this.innerContextLock;
    }

    protected final InternalEventBusCapacity getInternalEventBusCapacitySkill() {
        if (this.skillBufferInternalEventBusCapacity == null || this.skillBufferInternalEventBusCapacity.get() == null) {
            this.skillBufferInternalEventBusCapacity = this.$getSkill(InternalEventBusCapacity.class);
        }
        return this.$castSkill(InternalEventBusCapacity.class, this.skillBufferInternalEventBusCapacity);
    }

    @Override
    @Deprecated
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = InnerContextSkill.installationOrder(this);
        }
        return installationOrder;
    }

    public boolean hasInnerContext() {
        return this.getInnerContextWithoutAutomaticCreation() != null;
    }

    void resetInnerContext() {
        ReadWriteLock lock = this.getLock();
        lock.writeLock().lock();
        try {
            this.innerContext = null;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    @Pure
    public void toString(ToStringBuilder builder) {
        super.toString(builder);
        builder.add("addressInDefaultspace", this.agentAddressInInnerDefaultSpace);
    }

    @Override
    protected void uninstall(Skill.UninstallationStage stage) {
        if (stage == Skill.UninstallationStage.POST_DESTROY_EVENT) {
            AgentContext context;
            ReadWriteLock lock = this.getLock();
            lock.writeLock().lock();
            try {
                context = this.innerContext;
                this.innerContext = null;
            }
            finally {
                lock.writeLock().unlock();
            }
            if (context != null) {
                EventListener listener = this.getInternalEventBusCapacitySkill().asEventListener();
                ((OpenEventSpace)context.getDefaultSpace()).unregister(listener);
                this.contextService.removeContext(context);
            }
        }
    }

    protected final AgentContext getInnerContextWithoutAutomaticCreation() {
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            AgentContext agentContext = this.innerContext;
            return agentContext;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public AgentContext getInnerContext() {
        AgentContext ictx;
        ReadWriteLock lock = this.getLock();
        lock.readLock().lock();
        try {
            ictx = this.innerContext;
        }
        finally {
            lock.readLock().unlock();
        }
        if (ictx == null) {
            lock.writeLock().lock();
            try {
                ictx = this.innerContext = this.contextService.createContext(this.agentAddressInInnerDefaultSpace.getSpaceID().getContextID(), this.agentAddressInInnerDefaultSpace.getSpaceID().getID());
                EventListener listener = this.getInternalEventBusCapacitySkill().asEventListener();
                OpenEventSpace defSpace = (OpenEventSpace)ictx.getDefaultSpace();
                defSpace.register(listener);
            }
            finally {
                lock.writeLock().unlock();
            }
        }
        return ictx;
    }

    @Override
    public boolean hasMemberAgent() {
        AgentContext ictx = this.getInnerContextWithoutAutomaticCreation();
        if (ictx != null) {
            SynchronizedSet<UUID> participants = ictx.getDefaultSpace().getParticipants();
            assert (participants != null);
            ReadWriteLock lock = participants.getLock();
            lock.readLock().lock();
            try {
                boolean bl = participants.size() > 1 || participants.size() == 1 && !participants.contains(this.getOwner().getID());
                return bl;
            }
            finally {
                lock.readLock().unlock();
            }
        }
        return false;
    }

    @Override
    public int getMemberAgentCount() {
        AgentContext ictx = this.getInnerContextWithoutAutomaticCreation();
        if (ictx != null) {
            SynchronizedSet<UUID> participants = ictx.getDefaultSpace().getParticipants();
            assert (participants != null);
            ReadWriteLock lock = participants.getLock();
            lock.readLock().lock();
            try {
                int count = participants.size();
                if (participants.contains(this.getOwner().getID())) {
                    --count;
                }
                int n = count;
                return n;
            }
            finally {
                lock.readLock().unlock();
            }
        }
        return 0;
    }

    @Override
    public SynchronizedIterable<UUID> getMemberAgents() {
        SynchronizedSet<UUID> participants = null;
        AgentContext ictx = this.getInnerContextWithoutAutomaticCreation();
        if (ictx != null) {
            participants = ictx.getDefaultSpace().getParticipants();
            assert (participants != null);
        }
        HashSet<UUID> members = null;
        if (participants != null) {
            members = new HashSet<UUID>();
            UUID myId = this.getOwner().getID();
            ReadWriteLock plock = participants.getLock();
            plock.readLock().lock();
            try {
                for (UUID id : participants) {
                    if (id.equals(myId)) continue;
                    members.add(id);
                }
            }
            finally {
                plock.readLock().unlock();
            }
        }
        if (members != null) {
            return Collections3.unmodifiableSynchronizedSet(members, NoReadWriteLock.SINGLETON);
        }
        return Collections3.emptySynchronizedSet();
    }

    @Override
    public boolean isInnerDefaultSpace(Space space) {
        return this.isInnerDefaultSpace(space.getSpaceID());
    }

    @Override
    public boolean isInnerDefaultSpace(SpaceID spaceID) {
        AgentContext context = this.getInnerContextWithoutAutomaticCreation();
        return context != null && spaceID.equals(context.getDefaultSpace().getSpaceID());
    }

    @Override
    public boolean isInnerDefaultSpace(UUID spaceID) {
        AgentContext context = this.getInnerContextWithoutAutomaticCreation();
        return context != null && spaceID.equals(context.getDefaultSpace().getSpaceID().getID());
    }

    @Override
    public boolean isInInnerDefaultSpace(Event event) {
        Address adr;
        if (event != null && (adr = event.getSource()) != null) {
            return this.isInnerDefaultSpace(adr.getSpaceID());
        }
        return false;
    }
}

