/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.kernel.bic.Messages;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.sarl.core.Behaviors;
import io.sarl.core.ContextJoined;
import io.sarl.core.ContextLeft;
import io.sarl.core.ExternalContextAccess;
import io.sarl.core.MemberJoined;
import io.sarl.core.MemberLeft;
import io.sarl.core.OpenEventSpace;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.ClearableReference;
import io.sarl.lang.util.SynchronizedCollection;
import java.text.MessageFormat;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class ExternalContextAccessSkill
extends BuiltinSkill
implements ExternalContextAccess {
    private static int installationOrder = -1;
    private final Set<UUID> contexts = Sets.newConcurrentHashSet();
    @Inject
    private ContextSpaceService contextRepository;
    private ClearableReference<Skill> skillBufferInternalEventBusCapacity;
    private ClearableReference<Skill> skillBufferBehaviors;

    ExternalContextAccessSkill(Agent agent) {
        super(agent);
    }

    protected final InternalEventBusCapacity getInternalEventBusCapacitySkill() {
        if (this.skillBufferInternalEventBusCapacity == null || this.skillBufferInternalEventBusCapacity.get() == null) {
            this.skillBufferInternalEventBusCapacity = this.$getSkill(InternalEventBusCapacity.class);
        }
        return this.$castSkill(InternalEventBusCapacity.class, this.skillBufferInternalEventBusCapacity);
    }

    protected final Behaviors getBehaviorsSkill() {
        if (this.skillBufferBehaviors == null || this.skillBufferBehaviors.get() == null) {
            this.skillBufferBehaviors = this.$getSkill(Behaviors.class);
        }
        return this.$castSkill(Behaviors.class, this.skillBufferBehaviors);
    }

    @Override
    @Deprecated
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = ExternalContextAccessSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    @Pure
    public void toString(ToStringBuilder builder) {
        super.toString(builder);
        builder.add("contexts", this.contextRepository.toString());
    }

    @Override
    protected void install() {
        AgentContext ac = this.contextRepository.getContext(this.getOwner().getParentID());
        this.join(ac.getID(), ac.getDefaultSpace().getSpaceID().getID());
    }

    @Override
    protected void uninstall(Skill.UninstallationStage stage) {
        if (stage == Skill.UninstallationStage.POST_DESTROY_EVENT) {
            for (UUID contextID : this.contexts) {
                this.leave(contextID);
            }
        }
    }

    public SynchronizedCollection<AgentContext> getAllContexts() {
        ReadWriteLock lock = this.contextRepository.getLock();
        lock.readLock().lock();
        try {
            SynchronizedCollection<AgentContext> synchronizedCollection = this.contextRepository.getContexts(this.contexts);
            return synchronizedCollection;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public AgentContext getContext(UUID contextID) {
        assert (contextID != null);
        if (!this.contexts.contains(contextID)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.ExternalContextAccessSkill_0, contextID));
        }
        return this.contextRepository.getContext(contextID);
    }

    @Override
    public AgentContext getUniverseContext() {
        return this.contextRepository.getUniverseContext();
    }

    @Override
    public boolean join(UUID futureContext, UUID futureContextDefaultSpaceID) {
        assert (futureContext != null);
        assert (futureContextDefaultSpaceID != null);
        if (this.contexts.contains(futureContext)) {
            return false;
        }
        AgentContext ac = this.contextRepository.getContext(futureContext);
        assert (ac != null) : "Unknown Context";
        EventSpace defaultSpace = ac.getDefaultSpace();
        assert (defaultSpace != null) : "Unknown default space ";
        if (!futureContextDefaultSpaceID.equals(defaultSpace.getSpaceID().getID())) {
            return false;
        }
        this.contexts.add(futureContext);
        this.fireContextJoined(futureContext, futureContextDefaultSpaceID);
        this.fireMemberJoined(ac);
        ((OpenEventSpace)defaultSpace).register(this.getInternalEventBusCapacitySkill().asEventListener());
        return true;
    }

    protected final void fireContextJoined(UUID futureContext, UUID futureContextDefaultSpaceID) {
        this.getBehaviorsSkill().wake(new ContextJoined(futureContext, futureContextDefaultSpaceID), it -> !it.getUUID().equals(this.getOwner().getID()));
    }

    protected final void fireMemberJoined(AgentContext newJoinedContext) {
        EventSpace defSpace = newJoinedContext.getDefaultSpace();
        UUID ownerId = this.getOwner().getID();
        defSpace.emit(null, new MemberJoined(new Address(defSpace.getSpaceID(), ownerId), newJoinedContext.getID(), ownerId, this.getOwner().getClass().getName()), (Address it) -> !it.getUUID().equals(ownerId));
    }

    @Override
    public boolean leave(UUID contextID) {
        assert (contextID != null);
        AgentContext ac = this.contextRepository.getContext(contextID);
        assert (ac != null) : "Unknown Context";
        if (!this.contexts.contains(contextID)) {
            return false;
        }
        ((OpenEventSpace)ac.getDefaultSpace()).unregister(this.getInternalEventBusCapacitySkill().asEventListener());
        boolean b = this.contexts.remove(contextID);
        this.fireMemberLeft(ac);
        this.fireContextLeft(contextID);
        return b;
    }

    protected final void fireContextLeft(UUID contextID) {
        this.getBehaviorsSkill().wake(new ContextLeft(contextID), it -> it.getUUID() != this.getOwner().getID());
    }

    protected final void fireMemberLeft(AgentContext leftContext) {
        EventSpace defSpace = leftContext.getDefaultSpace();
        defSpace.emit(null, new MemberLeft(new Address(defSpace.getSpaceID(), this.getOwner().getID()), this.getOwner().getID(), this.getOwner().getClass().getName()), (Address it) -> it.getUUID() != this.getOwner().getID());
    }

    @Override
    public boolean isInSpace(Event event, Space space) {
        return this.isInSpace(event, space.getSpaceID());
    }

    @Override
    public boolean isInSpace(Event event, SpaceID spaceID) {
        return spaceID.equals(event.getSource().getSpaceID());
    }

    @Override
    public boolean isInSpace(Event event, UUID spaceID) {
        return spaceID.equals(event.getSource().getSpaceID().getID());
    }

    @Override
    public void emit(EventSpace space, Event event, Scope<Address> scope) {
        if (space != null) {
            space.emit(this.getOwner().getID(), event, scope);
        }
    }
}

