/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import io.janusproject.kernel.bic.BuiltinSkill;
import io.sarl.core.DefaultContextInteractions;
import io.sarl.core.Lifecycle;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.ClearableReference;
import io.sarl.util.Scopes;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class DefaultContextInteractionsSkill
extends BuiltinSkill
implements DefaultContextInteractions {
    private static int installationOrder = -1;
    private AgentContext parentContext;
    private EventSpace defaultSpace;
    private Address addressInParentDefaultSpace;
    private ClearableReference<Skill> skillBufferLifecycle;

    DefaultContextInteractionsSkill(Agent agent, AgentContext parentContext) {
        super(agent);
        this.parentContext = parentContext;
    }

    protected final Lifecycle getLifecycleSkill() {
        if (this.skillBufferLifecycle == null || this.skillBufferLifecycle.get() == null) {
            this.skillBufferLifecycle = this.$getSkill(Lifecycle.class);
        }
        return this.$castSkill(Lifecycle.class, this.skillBufferLifecycle);
    }

    @Override
    @Deprecated
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = DefaultContextInteractionsSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    @Pure
    public void toString(ToStringBuilder builder) {
        super.toString(builder);
        builder.add("parentContext", this.parentContext);
        builder.add("defaultSpace", this.defaultSpace);
        builder.add("addressInDefaultspace", this.addressInParentDefaultSpace);
    }

    @Override
    protected void install() {
        this.defaultSpace = this.parentContext.getDefaultSpace();
    }

    @Override
    public void emit(Event event) {
        this.defaultSpace.emit(this.getOwner().getID(), event, null);
    }

    @Override
    public void emit(Event event, Scope<Address> scope) {
        this.defaultSpace.emit(this.getOwner().getID(), event, scope);
    }

    @Override
    public Address getDefaultAddress() {
        Address adr = this.addressInParentDefaultSpace;
        if (adr == null) {
            adr = this.defaultSpace.getAddress(this.getOwner().getID());
            assert (adr != null) : "The agent has no address in the default space";
            this.addressInParentDefaultSpace = adr;
        }
        return adr;
    }

    @Override
    public AgentContext getDefaultContext() {
        return this.parentContext;
    }

    @Override
    public EventSpace getDefaultSpace() {
        return this.defaultSpace;
    }

    @Override
    @Deprecated
    public void receive(UUID receiverID, Event event) {
        this.willReceive(receiverID, event);
    }

    @Override
    public void willReceive(UUID receiverID, Event event) {
        Address recAddr = this.defaultSpace.getAddress(receiverID);
        this.emit(event, Scopes.addresses(recAddr));
    }

    @Override
    @Deprecated
    public UUID spawn(Class<? extends Agent> agentType, Object ... params) {
        return this.getLifecycleSkill().spawnInContext(agentType, this.parentContext, params);
    }

    @Override
    public boolean isDefaultSpace(Space space) {
        return this.isDefaultSpace(space.getSpaceID());
    }

    @Override
    public boolean isDefaultSpace(SpaceID space) {
        return this.isDefaultSpace(space.getID());
    }

    @Override
    public boolean isDefaultSpace(UUID space) {
        return space.equals(this.defaultSpace.getSpaceID().getID());
    }

    @Override
    public boolean isInDefaultSpace(Event event) {
        Address adr;
        if (event != null && (adr = event.getSource()) != null) {
            return this.isDefaultSpace(adr.getSpaceID());
        }
        return false;
    }

    @Override
    public boolean isDefaultContext(AgentContext context) {
        return this.isDefaultContext(context.getID());
    }

    @Override
    public boolean isDefaultContext(UUID contextID) {
        return contextID.equals(this.defaultSpace.getSpaceID().getContextID());
    }
}

