/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.collect.Iterables;
import io.sarl.core.AgentTask;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class AgentTraitData {
    private List<WeakReference<AgentTask>> tasks = new ArrayList<WeakReference<AgentTask>>();

    AgentTraitData() {
    }

    public void addTask(AgentTask task) {
        this.tasks.add(new WeakReference<AgentTask>(task));
    }

    public String toString() {
        return Iterables.toString(AgentTraitData.getTaskList(this.tasks));
    }

    public void removeTask(AgentTask task) {
        Iterator<WeakReference<AgentTask>> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            WeakReference<AgentTask> reference = iterator.next();
            AgentTask knownTask = (AgentTask)reference.get();
            if (knownTask == null) {
                iterator.remove();
                continue;
            }
            if (!Objects.equals(knownTask.getName(), task.getName())) continue;
            iterator.remove();
            return;
        }
    }

    public Iterable<AgentTask> resetTaskList() {
        List<WeakReference<AgentTask>> old = this.tasks;
        this.tasks = new ArrayList<WeakReference<AgentTask>>();
        return AgentTraitData.getTaskList(old);
    }

    protected static Iterable<AgentTask> getTaskList(List<WeakReference<AgentTask>> tasks) {
        Iterable col = Iterables.transform(tasks, it -> it != null ? (AgentTask)it.get() : null);
        return Iterables.filter(col, it -> it != null);
    }
}

