/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel;

import com.google.common.util.concurrent.Service;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import io.janusproject.kernel.Messages;
import io.janusproject.kernel.services.jdk.spawn.CannotSpawnException;
import io.janusproject.services.IServiceManager;
import io.janusproject.services.Services;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.spawn.KernelAgentSpawnListener;
import io.janusproject.services.spawn.SpawnService;
import io.janusproject.util.TwoStepConstruction;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.util.SynchronizedSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@Singleton
@TwoStepConstruction(names={"setJanusContext"})
public class Kernel {
    private AgentContext janusContext;
    private final IServiceManager serviceManager;
    private final SpawnService spawnService;
    private final LogService loggingService;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);

    @Inject
    Kernel(IServiceManager serviceManager, SpawnService spawnService, LogService loggingService, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.serviceManager = serviceManager;
        this.spawnService = spawnService;
        this.loggingService = loggingService;
        Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
        this.spawnService.addKernelAgentSpawnListener(new KernelStoppingListener());
        Services.startServices(this.serviceManager);
    }

    public static final Kernel create(Module ... modules) {
        Injector injector = Guice.createInjector(modules);
        Kernel k = injector.getInstance(Kernel.class);
        return k;
    }

    public Runnable getStopBehavior() {
        return () -> {
            SpawnService service = this.getService(SpawnService.class);
            if (service != null) {
                ArrayList<UUID> agentIds;
                SynchronizedSet<UUID> agents = service.getAgents();
                ReadWriteLock lock = agents.getLock();
                lock.readLock().lock();
                try {
                    agentIds = new ArrayList<UUID>(agents);
                }
                finally {
                    lock.readLock().unlock();
                }
                boolean killed = false;
                for (UUID agentId : agentIds) {
                    if (!service.killAgent(agentId, true)) continue;
                    killed = true;
                }
                if (!killed) {
                    new StopTheKernel().startAsync();
                }
            }
        };
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public int getAgentCount() {
        SpawnService service = this.getService(SpawnService.class);
        if (service != null) {
            SynchronizedSet<UUID> agents = service.getAgents();
            ReadWriteLock lock = agents.getLock();
            lock.readLock().lock();
            try {
                int n = agents.size();
                return n;
            }
            finally {
                lock.readLock().unlock();
            }
        }
        return 0;
    }

    public UUID spawn(Class<? extends Agent> agent, Object ... params) {
        List<UUID> ids = this.spawnService.spawn(1, null, this.janusContext, null, agent, params);
        if (ids.isEmpty()) {
            throw new CannotSpawnException(agent, null);
        }
        return ids.get(0);
    }

    public List<UUID> spawn(int nbAgents, Class<? extends Agent> agent, Object ... params) {
        return this.spawnService.spawn(nbAgents, null, this.janusContext, null, agent, params);
    }

    public UUID spawn(UUID agentID, Class<? extends Agent> agent, Object ... params) {
        List<UUID> ids = this.spawnService.spawn(1, null, this.janusContext, agentID, agent, params);
        if (ids.isEmpty()) {
            return null;
        }
        return ids.get(0);
    }

    public <S extends Service> S getService(Class<S> type) {
        for (Service serv : this.serviceManager.servicesByState().values()) {
            if (!serv.isRunning() || !type.isInstance(serv)) continue;
            return (S)((Service)type.cast(serv));
        }
        return null;
    }

    public Logger getLogger() {
        return this.loggingService.getKernelLogger();
    }

    @Inject
    void setJanusContext(@io.janusproject.kernel.annotations.Kernel AgentContext janusContext) {
        assert (janusContext != null);
        this.janusContext = janusContext;
    }

    public AgentContext getJanusContext() {
        assert (this.janusContext != null);
        return this.janusContext;
    }

    private class KernelStoppingListener
    implements KernelAgentSpawnListener {
        KernelStoppingListener() {
        }

        @Override
        public void kernelAgentSpawn() {
        }

        @Override
        public void kernelAgentDestroy() {
            StopTheKernel t = new StopTheKernel();
            t.startAsync();
        }
    }

    private class StopTheKernel
    implements ThreadFactory,
    Runnable,
    Thread.UncaughtExceptionHandler {
        StopTheKernel() {
        }

        public Thread startAsync() {
            Thread t = this.newThread(this);
            t.start();
            return t;
        }

        @Override
        public void run() {
            Logger logger = Kernel.this.getLogger();
            logger.info(Messages.Kernel_0);
            Services.stopServices(Kernel.this.serviceManager);
            logger.info(Messages.Kernel_1);
            Kernel.this.isRunning.set(false);
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = Executors.defaultThreadFactory().newThread(runnable);
            t.setName("Janus kernel shutdown");
            t.setDaemon(false);
            t.setUncaughtExceptionHandler(this);
            return t;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable exception) {
            assert (thread != null);
            assert (exception != null);
            LogRecord record = new LogRecord(Level.SEVERE, exception.getLocalizedMessage());
            record.setThrown(exception);
            StackTraceElement elt = exception.getStackTrace()[0];
            assert (elt != null);
            record.setSourceClassName(elt.getClassName());
            record.setSourceMethodName(elt.getMethodName());
            Logger logger = Kernel.this.getLogger();
            logger.log(record);
        }
    }
}

