/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject;

import com.google.common.util.concurrent.Service;
import io.janusproject.Boot;
import io.janusproject.kernel.Kernel;
import io.sarl.bootstrap.SREBootstrap;
import io.sarl.lang.annotation.PrivateAPI;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Logger;

public final class Bootstrap
implements SREBootstrap {
    private volatile Kernel kernel;

    public Bootstrap() {
        this.setOffline(true);
    }

    @PrivateAPI
    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public boolean isRunning() {
        return this.kernel != null && this.kernel.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean blocking) throws InterruptedException {
        Kernel kern;
        Bootstrap bootstrap = this;
        synchronized (bootstrap) {
            kern = this.kernel;
            this.kernel = null;
        }
        if (kern != null) {
            Runnable stop = kern.getStopBehavior();
            stop.run();
            if (blocking) {
                while (kern.isRunning()) {
                    Thread.yield();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID startAgent(Class<? extends Agent> agentCls, Object ... params) throws Exception {
        Kernel kern = this.kernel;
        if (kern == null) {
            Bootstrap bootstrap = this;
            synchronized (bootstrap) {
                this.kernel = Boot.startJanus(agentCls, params);
            }
            return Boot.getBootAgentIdentifier();
        }
        return kern.spawn(agentCls, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<UUID> startAgent(int nbAgents, Class<? extends Agent> agentCls, Object ... params) throws Exception {
        Kernel kern = this.kernel;
        if (kern == null) {
            ArrayList<UUID> spawned = new ArrayList<UUID>();
            Bootstrap bootstrap = this;
            synchronized (bootstrap) {
                kern = this.kernel = Boot.startJanus(agentCls, params);
            }
            spawned.add(Boot.getBootAgentIdentifier());
            if (nbAgents > 1) {
                spawned.addAll(kern.spawn(nbAgents - 1, agentCls, params));
            }
            return spawned;
        }
        return kern.spawn(nbAgents, agentCls, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAgentWithID(Class<? extends Agent> agentCls, UUID agentId, Object ... params) throws Exception {
        Kernel kern = this.kernel;
        if (kern == null) {
            Bootstrap bootstrap = this;
            synchronized (bootstrap) {
                this.kernel = Boot.startJanus(agentCls, params);
                return;
            }
        }
        kern.spawn(agentId, agentCls, params);
    }

    @Override
    public UUID getBootAgentIdentifier() {
        return Boot.getBootAgentIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentContext startWithoutAgent() {
        Kernel kern = this.kernel;
        if (kern == null) {
            Bootstrap bootstrap = this;
            synchronized (bootstrap) {
                kern = this.kernel = Boot.startWithoutAgent();
            }
        }
        return kern.getJanusContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Logger getKernelLogger() {
        Kernel kern;
        Bootstrap bootstrap = this;
        synchronized (bootstrap) {
            kern = this.kernel;
        }
        if (kern != null) {
            return kern.getLogger();
        }
        return null;
    }

    @Override
    public void setOffline(boolean isOffline) {
        Boot.setOffline(isOffline);
    }

    @Override
    public void setRandomContextUUID() {
        Boot.setRandomContextUUID();
    }

    @Override
    public void setBootAgentTypeContextUUID() {
        Boot.setBootAgentTypeContextUUID();
    }

    @Override
    public void setSpecificContextUUID() {
        Boot.setDefaultContextUUID();
    }

    @Override
    public void setVerboseLevel(int level) {
        Boot.setVerboseLevel(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getService(Class<T> serviceType) {
        if (Service.class.isAssignableFrom(serviceType)) {
            Kernel kern;
            Bootstrap bootstrap = this;
            synchronized (bootstrap) {
                kern = this.kernel;
            }
            if (kern != null) {
                return (T)kern.getService(serviceType.asSubclass(Service.class));
            }
        }
        return null;
    }
}

