/*
 * Decompiled with CFR 0.152.
 */
package io.iteratee.testing.files;

import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.kernel.Eq;
import cats.kernel.Order;
import io.iteratee.Enumerator;
import io.iteratee.files.modules.FileModule;
import io.iteratee.modules.EnumeratorModule;
import io.iteratee.modules.IterateeModule;
import io.iteratee.modules.Module;
import io.iteratee.testing.ModuleSuite;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalacheck.Shrink$;
import org.scalacheck.util.Buildable$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import org.scalatest.flatspec.AnyFlatSpecLike;
import org.scalatest.prop.Configuration;
import org.scalatestplus.scalacheck.CheckerAsserting$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Factory$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.collection.immutable.Vector;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class FileModuleSuite<F>
extends ModuleSuite<F> {
    private final Monad<F> evidence$1;

    public <F> FileModuleSuite(Monad<F> evidence$1) {
        this.evidence$1 = evidence$1;
        AnyFlatSpecLike.InAndIgnoreMethods InAndIgnoreMethods_this = this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("readLines", Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 15)).should("enumerate text lines from a file", this.shorthandTestRegistrationFunction()));
        FileModuleSuite AnyFlatSpecLike_this = (FileModuleSuite)InAndIgnoreMethods_this.org$scalatest$flatspec$AnyFlatSpecLike$InAndIgnoreMethods$$$outer();
        Position pos$proxy3 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 15);
        AnyFlatSpecLike_this.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(InAndIgnoreMethods_this.inline$resultOfStringPassedToVerb().verb().trim() + " " + InAndIgnoreMethods_this.inline$resultOfStringPassedToVerb().rest().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy1$1(evidence$1), pos$proxy3);
        AnyFlatSpecLike.ItVerbString ItVerbString_this = this.it().should("work with an iteratee that stops early");
        FileModuleSuite AnyFlatSpecLike_this2 = (FileModuleSuite)ItVerbString_this.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position pos$proxy6 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 22);
        AnyFlatSpecLike_this2.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this.inline$verb().trim() + " " + ItVerbString_this.inline$name().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy2$1(evidence$1), pos$proxy6);
        AnyFlatSpecLike.InAndIgnoreMethods InAndIgnoreMethods_this2 = this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("readLinesFromStream", Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30)).should("enumerate text lines from a stream", this.shorthandTestRegistrationFunction()));
        FileModuleSuite AnyFlatSpecLike_this3 = (FileModuleSuite)InAndIgnoreMethods_this2.org$scalatest$flatspec$AnyFlatSpecLike$InAndIgnoreMethods$$$outer();
        Position pos$proxy9 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30);
        AnyFlatSpecLike_this3.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(InAndIgnoreMethods_this2.inline$resultOfStringPassedToVerb().verb().trim() + " " + InAndIgnoreMethods_this2.inline$resultOfStringPassedToVerb().rest().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy3$1(evidence$1), pos$proxy9);
        AnyFlatSpecLike.InAndIgnoreMethods InAndIgnoreMethods_this3 = this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("readBytes", Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38)).should("enumerate bytes from a file", this.shorthandTestRegistrationFunction()));
        FileModuleSuite AnyFlatSpecLike_this4 = (FileModuleSuite)InAndIgnoreMethods_this3.org$scalatest$flatspec$AnyFlatSpecLike$InAndIgnoreMethods$$$outer();
        Position pos$proxy12 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38);
        AnyFlatSpecLike_this4.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(InAndIgnoreMethods_this3.inline$resultOfStringPassedToVerb().verb().trim() + " " + InAndIgnoreMethods_this3.inline$resultOfStringPassedToVerb().rest().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy4$1(evidence$1), pos$proxy12);
        AnyFlatSpecLike.InAndIgnoreMethods InAndIgnoreMethods_this4 = this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("readBytesFromStream", Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45)).should("enumerate bytes from a stream", this.shorthandTestRegistrationFunction()));
        FileModuleSuite AnyFlatSpecLike_this5 = (FileModuleSuite)InAndIgnoreMethods_this4.org$scalatest$flatspec$AnyFlatSpecLike$InAndIgnoreMethods$$$outer();
        Position pos$proxy15 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45);
        AnyFlatSpecLike_this5.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(InAndIgnoreMethods_this4.inline$resultOfStringPassedToVerb().verb().trim() + " " + InAndIgnoreMethods_this4.inline$resultOfStringPassedToVerb().rest().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy5$1(evidence$1), pos$proxy15);
        AnyFlatSpecLike.InAndIgnoreMethods InAndIgnoreMethods_this5 = this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("readZipStreams", Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54)).should("enumerate files in a zip archive", this.shorthandTestRegistrationFunction()));
        FileModuleSuite AnyFlatSpecLike_this6 = (FileModuleSuite)InAndIgnoreMethods_this5.org$scalatest$flatspec$AnyFlatSpecLike$InAndIgnoreMethods$$$outer();
        Position pos$proxy18 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54);
        AnyFlatSpecLike_this6.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(InAndIgnoreMethods_this5.inline$resultOfStringPassedToVerb().verb().trim() + " " + InAndIgnoreMethods_this5.inline$resultOfStringPassedToVerb().rest().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy6$1(evidence$1), pos$proxy18);
        AnyFlatSpecLike.ItVerbString ItVerbString_this2 = this.it().should("work with an iteratee that stops early");
        FileModuleSuite AnyFlatSpecLike_this7 = (FileModuleSuite)ItVerbString_this2.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position pos$proxy21 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64);
        AnyFlatSpecLike_this7.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this2.inline$verb().trim() + " " + ItVerbString_this2.inline$name().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy7$1(evidence$1), pos$proxy21);
        AnyFlatSpecLike.InAndIgnoreMethods InAndIgnoreMethods_this6 = this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("listFiles", Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71)).should("enumerate files in a directory", this.shorthandTestRegistrationFunction()));
        FileModuleSuite AnyFlatSpecLike_this8 = (FileModuleSuite)InAndIgnoreMethods_this6.org$scalatest$flatspec$AnyFlatSpecLike$InAndIgnoreMethods$$$outer();
        Position pos$proxy24 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71);
        AnyFlatSpecLike_this8.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(InAndIgnoreMethods_this6.inline$resultOfStringPassedToVerb().verb().trim() + " " + InAndIgnoreMethods_this6.inline$resultOfStringPassedToVerb().rest().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy8$1(evidence$1), pos$proxy24);
        AnyFlatSpecLike.ItVerbString ItVerbString_this3 = this.it().should("fail properly on a file");
        FileModuleSuite AnyFlatSpecLike_this9 = (FileModuleSuite)ItVerbString_this3.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position pos$proxy27 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79);
        AnyFlatSpecLike_this9.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this3.inline$verb().trim() + " " + ItVerbString_this3.inline$name().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy9$1(evidence$1), pos$proxy27);
        AnyFlatSpecLike.InAndIgnoreMethods InAndIgnoreMethods_this7 = this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("listFilesRec", Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86)).should("enumerate files in a directory recursively", this.shorthandTestRegistrationFunction()));
        FileModuleSuite AnyFlatSpecLike_this10 = (FileModuleSuite)InAndIgnoreMethods_this7.org$scalatest$flatspec$AnyFlatSpecLike$InAndIgnoreMethods$$$outer();
        Position pos$proxy30 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86);
        AnyFlatSpecLike_this10.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(InAndIgnoreMethods_this7.inline$resultOfStringPassedToVerb().verb().trim() + " " + InAndIgnoreMethods_this7.inline$resultOfStringPassedToVerb().rest().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy10$1(evidence$1), pos$proxy30);
        AnyFlatSpecLike.InAndIgnoreMethods InAndIgnoreMethods_this8 = this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("writeLines", Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94)).should("write arbitrary lines to a temporary file", this.shorthandTestRegistrationFunction()));
        FileModuleSuite AnyFlatSpecLike_this11 = (FileModuleSuite)InAndIgnoreMethods_this8.org$scalatest$flatspec$AnyFlatSpecLike$InAndIgnoreMethods$$$outer();
        Position pos$proxy35 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94);
        AnyFlatSpecLike_this11.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(InAndIgnoreMethods_this8.inline$resultOfStringPassedToVerb().verb().trim() + " " + InAndIgnoreMethods_this8.inline$resultOfStringPassedToVerb().rest().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy11$3(evidence$1), pos$proxy35);
        AnyFlatSpecLike.InAndIgnoreMethods InAndIgnoreMethods_this9 = this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("writeLinesToStream", Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102)).should("write arbitrary lines to a temporary file", this.shorthandTestRegistrationFunction()));
        FileModuleSuite AnyFlatSpecLike_this12 = (FileModuleSuite)InAndIgnoreMethods_this9.org$scalatest$flatspec$AnyFlatSpecLike$InAndIgnoreMethods$$$outer();
        Position pos$proxy40 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102);
        AnyFlatSpecLike_this12.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(InAndIgnoreMethods_this9.inline$resultOfStringPassedToVerb().verb().trim() + " " + InAndIgnoreMethods_this9.inline$resultOfStringPassedToVerb().rest().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy12$3(evidence$1), pos$proxy40);
        AnyFlatSpecLike.InAndIgnoreMethods InAndIgnoreMethods_this10 = this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("writeBytes", Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111)).should("write arbitrary bytes to a temporary file", this.shorthandTestRegistrationFunction()));
        FileModuleSuite AnyFlatSpecLike_this13 = (FileModuleSuite)InAndIgnoreMethods_this10.org$scalatest$flatspec$AnyFlatSpecLike$InAndIgnoreMethods$$$outer();
        Position pos$proxy45 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111);
        AnyFlatSpecLike_this13.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(InAndIgnoreMethods_this10.inline$resultOfStringPassedToVerb().verb().trim() + " " + InAndIgnoreMethods_this10.inline$resultOfStringPassedToVerb().rest().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy13$4(evidence$1), pos$proxy45);
        AnyFlatSpecLike.InAndIgnoreMethods InAndIgnoreMethods_this11 = this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("writeBytesToStream", Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119)).should("write arbitrary bytes to a temporary file", this.shorthandTestRegistrationFunction()));
        FileModuleSuite AnyFlatSpecLike_this14 = (FileModuleSuite)InAndIgnoreMethods_this11.org$scalatest$flatspec$AnyFlatSpecLike$InAndIgnoreMethods$$$outer();
        Position pos$proxy50 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119);
        AnyFlatSpecLike_this14.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(InAndIgnoreMethods_this11.inline$resultOfStringPassedToVerb().verb().trim() + " " + InAndIgnoreMethods_this11.inline$resultOfStringPassedToVerb().rest().trim(), "in", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Function0 & Serializable)() -> this.testFun$proxy14$4(evidence$1), pos$proxy50);
    }

    private final Assertion testFun$proxy1$1(Monad evidence$1$1) {
        File txt = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.txt").toURI());
        Enumerator enumerator = ((FileModule)this).readLines(txt).flatMap((Function1 & Serializable)line -> ((EnumeratorModule)this).enumVector(Predef$.MODULE$.wrapRefArray((Object[])line.trim().split("\\s+")).toVector()), evidence$1$1);
        Eq eq2 = this.eqF((Eq)this.catsKernelStdOrderForLong());
        Object object = ((Module)this).F().pure((Object)BoxesRunTime.boxToLong((long)17973L));
        boolean bl = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).length(), (FlatMap)evidence$1$1), eq2).$eq$eq$eq(object);
        Bool bool$proxy1 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
        String clue$proxy1 = "";
        Position pos$proxy2 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 19);
        return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy1, (Object)clue$proxy1, pos$proxy2);
    }

    private final Assertion testFun$proxy2$1(Monad evidence$1$2) {
        File txt = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.txt").toURI());
        String result = "The Project Gutenberg EBook of Bartleby, The Scrivener, by Herman Melville";
        Enumerator enumerator = ((FileModule)this).readLines(txt);
        Eq eq2 = this.eqF(this.catsKernelStdOrderForOption((Order)this.catsKernelStdOrderForString()));
        Object object = ((Module)this).F().pure((Object)Some$.MODULE$.apply((Object)result));
        boolean bl = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).head(), (FlatMap)evidence$1$2), eq2).$eq$eq$eq(object);
        Bool bool$proxy2 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
        String clue$proxy2 = "";
        Position pos$proxy5 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27);
        return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy2, (Object)clue$proxy2, pos$proxy5);
    }

    private final Assertion testFun$proxy3$1(Monad evidence$1$3) {
        File txt = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.txt").toURI());
        FileInputStream stream = new FileInputStream(txt);
        Enumerator enumerator = ((FileModule)this).readLinesFromStream((InputStream)stream).flatMap((Function1 & Serializable)line -> ((EnumeratorModule)this).enumVector(Predef$.MODULE$.wrapRefArray((Object[])line.trim().split("\\s+")).toVector()), evidence$1$3);
        Eq eq2 = this.eqF((Eq)this.catsKernelStdOrderForLong());
        Object object = ((Module)this).F().pure((Object)BoxesRunTime.boxToLong((long)17973L));
        boolean bl = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).length(), (FlatMap)evidence$1$3), eq2).$eq$eq$eq(object);
        Bool bool$proxy3 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
        String clue$proxy3 = "";
        Position pos$proxy8 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35);
        return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy3, (Object)clue$proxy3, pos$proxy8);
    }

    private final Assertion testFun$proxy4$1(Monad evidence$1$4) {
        File txt = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.txt").toURI());
        Enumerator enumerator = ((FileModule)this).readBytes(txt).flatMap((Function1 & Serializable)bytes -> ((EnumeratorModule)this).enumVector(Predef$.MODULE$.wrapByteArray(bytes).toVector()), evidence$1$4);
        Eq eq2 = this.eqF((Eq)this.catsKernelStdOrderForLong());
        Object object = ((Module)this).F().pure((Object)BoxesRunTime.boxToLong((long)105397L));
        boolean bl = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).length(), (FlatMap)evidence$1$4), eq2).$eq$eq$eq(object);
        Bool bool$proxy4 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
        String clue$proxy4 = "";
        Position pos$proxy11 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42);
        return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy4, (Object)clue$proxy4, pos$proxy11);
    }

    private final Assertion testFun$proxy5$1(Monad evidence$1$5) {
        File zip = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.zip").toURI());
        Enumerator enumerator = ((FileModule)this).readZipStreams(zip).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputStream stream = (InputStream)tuple2._2();
            return ((FileModule)this).readBytesFromStream(stream);
        }, evidence$1$5).flatMap((Function1 & Serializable)bytes -> ((EnumeratorModule)this).enumVector(Predef$.MODULE$.wrapByteArray(bytes).toVector()), evidence$1$5);
        Eq eq2 = this.eqF((Eq)this.catsKernelStdOrderForLong());
        Object object = ((Module)this).F().pure((Object)BoxesRunTime.boxToLong((long)105397L));
        boolean bl = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).length(), (FlatMap)evidence$1$5), eq2).$eq$eq$eq(object);
        Bool bool$proxy5 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
        String clue$proxy5 = "";
        Position pos$proxy14 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51);
        return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy5, (Object)clue$proxy5, pos$proxy14);
    }

    private final Assertion testFun$proxy6$1(Monad evidence$1$6) {
        File zip = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.zip").toURI());
        Enumerator enumerator = ((FileModule)this).readZipStreams(zip).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputStream stream = (InputStream)tuple2._2();
            return ((FileModule)this).readLinesFromStream(stream);
        }, evidence$1$6);
        Eq eq2 = this.eqF((Eq)this.catsKernelStdOrderForLong());
        Object object = ((Module)this).F().pure((Object)BoxesRunTime.boxToLong((long)1981L));
        boolean bl = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).length(), (FlatMap)evidence$1$6), eq2).$eq$eq$eq(object);
        Bool bool$proxy6 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
        String clue$proxy6 = "";
        Position pos$proxy17 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61);
        return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy6, (Object)clue$proxy6, pos$proxy17);
    }

    private final Assertion testFun$proxy7$1(Monad evidence$1$7) {
        File zip = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.zip").toURI());
        Enumerator enumerator = ((FileModule)this).readZipStreams(zip).map((Function1 & Serializable)_$3 -> ((ZipEntry)_$3._1()).getName(), evidence$1$7);
        Eq eq2 = this.eqF(this.catsKernelStdOrderForOption((Order)this.catsKernelStdOrderForString()));
        Object object = ((Module)this).F().pure((Object)Some$.MODULE$.apply((Object)"11231.txt"));
        boolean bl = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).head(), (FlatMap)evidence$1$7), eq2).$eq$eq$eq(object);
        Bool bool$proxy7 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
        String clue$proxy7 = "";
        Position pos$proxy20 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68);
        return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy7, (Object)clue$proxy7, pos$proxy20);
    }

    private final Assertion testFun$proxy8$1(Monad evidence$1$8) {
        File dir = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231").toURI());
        Vector result = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"11231.txt", "11231.zip"}));
        Enumerator enumerator = ((FileModule)this).listFiles(dir);
        Eq eq2 = this.eqF(this.catsKernelStdOrderForVector((Order)this.catsKernelStdOrderForString()));
        Object object = ((Module)this).F().pure((Object)result);
        boolean bl = this.catsSyntaxEq(((Module)this).F().map(enumerator.toVector(evidence$1$8), (Function1 & Serializable)_$4 -> (Vector)((StrictOptimizedSeqOps)_$4.map((Function1 & Serializable)_$5 -> _$5.getName())).sorted(this.catsKernelOrderingForOrder((Order)this.catsKernelStdOrderForString()))), eq2).$eq$eq$eq(object);
        Bool bool$proxy8 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
        String clue$proxy8 = "";
        Position pos$proxy23 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76);
        return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy8, (Object)clue$proxy8, pos$proxy23);
    }

    private final Assertion testFun$proxy9$1(Monad evidence$1$9) {
        File notDir = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.txt").toURI());
        Enumerator enumerator = ((FileModule)this).listFiles(notDir);
        Eq eq2 = this.eqF((Eq)this.catsKernelStdOrderForBoolean());
        Object object = ((Module)this).F().pure((Object)BoxesRunTime.boxToBoolean((boolean)true));
        boolean bl = this.catsSyntaxEq(((Module)this).F().map(enumerator.toVector(evidence$1$9), (Function1 & Serializable)_$6 -> _$6.isEmpty()), eq2).$eq$eq$eq(object);
        Bool bool$proxy9 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
        String clue$proxy9 = "";
        Position pos$proxy26 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83);
        return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy9, (Object)clue$proxy9, pos$proxy26);
    }

    private final Assertion testFun$proxy10$1(Monad evidence$1$10) {
        File dir = new File(this.getClass().getResource("/io/iteratee/examples/pg").toURI());
        Vector result = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"11231.txt", "11231.zip"}));
        Enumerator enumerator = ((FileModule)this).listFilesRec(dir);
        Eq eq2 = this.eqF(this.catsKernelStdOrderForVector((Order)this.catsKernelStdOrderForString()));
        Object object = ((Module)this).F().pure((Object)result);
        boolean bl = this.catsSyntaxEq(((Module)this).F().map(enumerator.toVector(evidence$1$10), (Function1 & Serializable)_$7 -> (Vector)((StrictOptimizedSeqOps)_$7.map((Function1 & Serializable)_$8 -> _$8.getName())).sorted(this.catsKernelOrderingForOrder((Order)this.catsKernelStdOrderForString()))), eq2).$eq$eq$eq(object);
        Bool bool$proxy10 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
        String clue$proxy10 = "";
        Position pos$proxy29 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91);
        return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy10, (Object)clue$proxy10, pos$proxy29);
    }

    private static final Gen testFun$proxy11$1$$anonfun$1() {
        return Gen$.MODULE$.alphaStr();
    }

    private final Assertion testFun$proxy11$3(Monad evidence$1$11) {
        return (Assertion)this.forAll(Gen$.MODULE$.listOf(FileModuleSuite::testFun$proxy11$1$$anonfun$1), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Configuration.PropertyCheckConfigParam[0]), (Function1 & Serializable)lines -> {
            File tmp = File.createTempFile("it-writeLines", ".txt");
            tmp.deleteOnExit();
            Eq eq2 = this.eqF((Eq)this.catsKernelStdOrderForUnit());
            Object object = ((Module)this).F().pure((Object)BoxedUnit.UNIT);
            boolean bl = this.catsSyntaxEq(((EnumeratorModule)this).enumList(lines).into(((FileModule)this).writeLines(tmp), (FlatMap)evidence$1$11), eq2).$eq$eq$eq(object);
            Bool bool$proxy11 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
            String clue$proxy11 = "";
            Position pos$proxy32 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98);
            Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy11, (Object)clue$proxy11, pos$proxy32);
            Eq eq3 = this.eqF(this.catsKernelStdOrderForVector((Order)this.catsKernelStdOrderForString()));
            Object object2 = ((Module)this).F().pure((Object)lines.toVector());
            boolean bl2 = this.catsSyntaxEq(((FileModule)this).readLines(tmp).toVector(evidence$1$11), eq3).$eq$eq$eq(object2);
            Bool bool$proxy12 = Bool$.MODULE$.binaryMacroBool(eq3, "===", object2, bl2, Prettifier$.MODULE$.default());
            String clue$proxy12 = "";
            Position pos$proxy34 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99);
            return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy12, (Object)clue$proxy12, pos$proxy34);
        }, this.generatorDrivenConfig(), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkString(), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory())), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
    }

    private static final Gen testFun$proxy12$1$$anonfun$1() {
        return Gen$.MODULE$.alphaStr();
    }

    private final Assertion testFun$proxy12$3(Monad evidence$1$13) {
        return (Assertion)this.forAll(Gen$.MODULE$.listOf(FileModuleSuite::testFun$proxy12$1$$anonfun$1), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Configuration.PropertyCheckConfigParam[0]), (Function1 & Serializable)lines -> {
            File tmp = File.createTempFile("it-writeLinesToStream", ".txt");
            tmp.deleteOnExit();
            FileOutputStream stream = new FileOutputStream(tmp);
            Eq eq2 = this.eqF((Eq)this.catsKernelStdOrderForUnit());
            Object object = ((Module)this).F().pure((Object)BoxedUnit.UNIT);
            boolean bl = this.catsSyntaxEq(((EnumeratorModule)this).enumList(lines).into(((FileModule)this).writeLinesToStream((OutputStream)stream), (FlatMap)evidence$1$13), eq2).$eq$eq$eq(object);
            Bool bool$proxy13 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
            String clue$proxy13 = "";
            Position pos$proxy37 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107);
            Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy13, (Object)clue$proxy13, pos$proxy37);
            Eq eq3 = this.eqF(this.catsKernelStdOrderForVector((Order)this.catsKernelStdOrderForString()));
            Object object2 = ((Module)this).F().pure((Object)lines.toVector());
            boolean bl2 = this.catsSyntaxEq(((FileModule)this).readLines(tmp).toVector(evidence$1$13), eq3).$eq$eq$eq(object2);
            Bool bool$proxy14 = Bool$.MODULE$.binaryMacroBool(eq3, "===", object2, bl2, Prettifier$.MODULE$.default());
            String clue$proxy14 = "";
            Position pos$proxy39 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108);
            return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy14, (Object)clue$proxy14, pos$proxy39);
        }, this.generatorDrivenConfig(), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkString(), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory())), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }

    private final Assertion testFun$proxy13$4(Monad evidence$1$15) {
        return (Assertion)this.forAll((Function1 & Serializable)bytes -> {
            File tmp = File.createTempFile("it-writeBytes", ".txt");
            tmp.deleteOnExit();
            Eq eq2 = this.eqF((Eq)this.catsKernelStdOrderForUnit());
            Object object = ((Module)this).F().pure((Object)BoxedUnit.UNIT);
            boolean bl = this.catsSyntaxEq(((EnumeratorModule)this).enumList(bytes).into(((FileModule)this).writeBytes(tmp), (FlatMap)evidence$1$15), eq2).$eq$eq$eq(object);
            Bool bool$proxy15 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
            String clue$proxy15 = "";
            Position pos$proxy42 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115);
            Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy15, (Object)clue$proxy15, pos$proxy42);
            Eq eq3 = this.eqF(this.catsKernelStdOrderForVector((Order)this.catsKernelStdOrderForByte()));
            Object object2 = ((Module)this).F().pure(bytes.toVector().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs)));
            boolean bl2 = this.catsSyntaxEq(this.toFunctorOps(((FileModule)this).readBytes(tmp).toVector(evidence$1$15), (Functor)evidence$1$15).map((Function1 & Serializable)_$9 -> (Vector)_$9.flatMap((Function1 & Serializable)_$10 -> Predef$.MODULE$.wrapByteArray(_$10).toVector())), eq3).$eq$eq$eq(object2);
            Bool bool$proxy16 = Bool$.MODULE$.binaryMacroBool(eq3, "===", object2, bl2, Prettifier$.MODULE$.default());
            String clue$proxy16 = "";
            Position pos$proxy44 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116);
            return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy16, (Object)clue$proxy16, pos$proxy44);
        }, this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbContainer(Arbitrary$.MODULE$.arbContainer(Arbitrary$.MODULE$.arbByte(), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory(ClassTag$.MODULE$.apply(Byte.TYPE))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs)), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory()), Predef$.MODULE$.$conforms()), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkContainer((Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.ByteIsIntegral$.MODULE$), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory(ClassTag$.MODULE$.apply(Byte.TYPE)))), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory())), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
    }

    private final Assertion testFun$proxy14$4(Monad evidence$1$17) {
        return (Assertion)this.forAll((Function1 & Serializable)bytes -> {
            File tmp = File.createTempFile("it-writeBytesToStream", ".txt");
            tmp.deleteOnExit();
            Eq eq2 = this.eqF((Eq)this.catsKernelStdOrderForUnit());
            Object object = ((Module)this).F().pure((Object)BoxedUnit.UNIT);
            boolean bl = this.catsSyntaxEq(((EnumeratorModule)this).enumList(bytes).into(((FileModule)this).writeBytes(tmp), (FlatMap)evidence$1$17), eq2).$eq$eq$eq(object);
            Bool bool$proxy17 = Bool$.MODULE$.binaryMacroBool(eq2, "===", object, bl, Prettifier$.MODULE$.default());
            String clue$proxy17 = "";
            Position pos$proxy47 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123);
            Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy17, (Object)clue$proxy17, pos$proxy47);
            Eq eq3 = this.eqF(this.catsKernelStdOrderForVector((Order)this.catsKernelStdOrderForByte()));
            Object object2 = ((Module)this).F().pure(bytes.toVector().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs)));
            boolean bl2 = this.catsSyntaxEq(this.toFunctorOps(((FileModule)this).readBytes(tmp).toVector(evidence$1$17), (Functor)evidence$1$17).map((Function1 & Serializable)_$11 -> (Vector)_$11.flatMap((Function1 & Serializable)_$12 -> Predef$.MODULE$.wrapByteArray(_$12).toVector())), eq3).$eq$eq$eq(object2);
            Bool bool$proxy18 = Bool$.MODULE$.binaryMacroBool(eq3, "===", object2, bl2, Prettifier$.MODULE$.default());
            String clue$proxy18 = "";
            Position pos$proxy49 = Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124);
            return Assertions$.MODULE$.assertionsHelper().macroAssert(bool$proxy18, (Object)clue$proxy18, pos$proxy49);
        }, this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbContainer(Arbitrary$.MODULE$.arbContainer(Arbitrary$.MODULE$.arbByte(), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory(ClassTag$.MODULE$.apply(Byte.TYPE))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs)), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory()), Predef$.MODULE$.$conforms()), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkContainer((Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.ByteIsIntegral$.MODULE$), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory(ClassTag$.MODULE$.apply(Byte.TYPE)))), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory())), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), Position$.MODULE$.apply("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
    }
}

