/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.spring.main;

import io.inversion.Api;
import io.inversion.Engine;
import io.inversion.spring.config.EnableInversion;
import io.inversion.spring.config.InversionRegistrar;
import io.inversion.utils.Utils;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.ApplicationContext;

@SpringBootApplication(exclude={DataSourceAutoConfiguration.class})
@EnableInversion
public class InversionMain {
    protected static Class primarySource = InversionMain.class;
    protected static ApplicationContext context = null;
    protected static Engine engine = null;

    public static void main(String[] args) {
        InversionMain.run(args, null);
    }

    public static void run(Class<?> primarySource, String ... args) {
        InversionMain.primarySource = primarySource;
        InversionMain.run(args, null);
    }

    public static ApplicationContext run(Api ... apis) {
        return InversionMain.run(new String[0], apis);
    }

    public static ApplicationContext run(String[] args, Api[] apis) {
        try {
            if (context != null) {
                InversionMain.exit();
            }
            InversionRegistrar.apis = apis;
            context = SpringApplication.run((Class)primarySource, (String[])args);
            engine = (Engine)context.getBean("engine");
        }
        catch (Throwable e) {
            e = Utils.getCause((Throwable)e);
            if (Utils.getStackTraceString((Throwable)e).contains("A child container failed during start")) {
                Object msg = " README FOR HELP!!!!!!!";
                msg = (String)msg + "\n";
                msg = (String)msg + "\n It looks like you are getting a frustrating Tomcat startup error.";
                msg = (String)msg + "\n";
                msg = (String)msg + "\n This error may be casused if URL.setURLStreamHandlerFactory()";
                msg = (String)msg + "\n is somehow called before Spring Boot starts Tomcat. ";
                msg = (String)msg + "\n";
                msg = (String)msg + "\n This seems to be a frustrating undocumented \"no no\" of Tomcat with ";
                msg = (String)msg + "\n Spring Boot. Using H2 db before Spring Boot starts Tomcat seems to ";
                msg = (String)msg + "\n be one known cause of this error.";
                msg = (String)msg + "\n";
                msg = (String)msg + "\n SOLUTION: Override Engine.startup0() and place all of your Api wiring";
                msg = (String)msg + "\n and other setup code there.  That way Tomcat will load before ";
                msg = (String)msg + "\n the part of your code that is causing this unintended side effect.";
                msg = (String)msg + "\n\n\n";
                System.err.println((String)msg);
                throw new RuntimeException((String)msg, e);
            }
            e.printStackTrace();
            Utils.rethrow((Throwable)e);
        }
        return context;
    }

    public static void exit() {
        if (context != null) {
            SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        }
        context = null;
    }

    public ApplicationContext getContext() {
        return context;
    }

    public static Engine getEngine() {
        return engine;
    }
}

