/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.spring.config;

import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class InversionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
BeanFactoryAware {
    static final Logger log = LoggerFactory.getLogger(InversionRegistrar.class);
    static Environment environment = null;
    static BeanFactory beanFactory = null;
    public static Api[] apis = null;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        InversionRegistrar.beanFactory = beanFactory;
        if (apis != null && apis.length > 0) {
            ConfigurableBeanFactory config = (ConfigurableBeanFactory)beanFactory;
            for (Api api : apis) {
                String name = api.getName();
                if (name == null) {
                    throw new ApiException("Your Api must have a non null 'name' property configured when running your APIs with SpringBoot.", new Object[0]);
                }
                config.registerSingleton(name, (Object)api);
            }
        }
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        GenericBeanDefinition bean = new GenericBeanDefinition();
        bean.setBeanClass(Engine.class);
        bean.setAutowireMode(0);
        bean.setDestroyMethodName("shutdown");
        registry.registerBeanDefinition("engine", (BeanDefinition)bean);
    }

    public void setEnvironment(Environment environment) {
        InversionRegistrar.environment = environment;
        this.setEnvironmentDefaults(environment);
    }

    protected void setEnvironmentDefaults(Environment env) {
        log.info("Setting SpringBoot Defaults:");
        this.setEnvironmentDefault(env, "server.compression.enabled", "true");
        this.setEnvironmentDefault(env, "server.compression.mime-types", "text/html,text/xml,text/plain,text/css,text/javascript,application/javascript,application/json");
        this.setEnvironmentDefault(env, "server.compression.min-response-size", "2048");
        this.setEnvironmentDefault(env, "server.port", "8080");
        this.setEnvironmentDefault(env, "spring.servlet.multipart.enabled", "true");
        this.setEnvironmentDefault(env, "spring.servlet.multipart.max-file-size", "100MB");
        this.setEnvironmentDefault(env, "spring.servlet.multipart.max-request-size", "100MB");
    }

    protected void setEnvironmentDefault(Environment env, String prop, String value) {
        String found = env.getProperty(prop);
        if (found == null) {
            System.setProperty(prop, value);
            log.info("  - [SETTING]  " + prop + " = " + value);
        } else {
            log.info("  - [SKIPPING] " + prop + " = " + found);
        }
    }
}

