/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.security;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Filter;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.action.security.AclRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AclFilter
extends Filter<AclFilter> {
    protected final List<AclRule> aclRules = new ArrayList<AclRule>();

    public AclFilter orRequireAllPerms(String permissions, String ... includedOn) {
        this.withAclRules(AclRule.requireAllPerms(permissions, includedOn));
        return this;
    }

    public AclFilter orRequireOnePerm(String permissions, String ... includedOn) {
        this.withAclRules(AclRule.requireOnePerm(permissions, includedOn));
        return this;
    }

    public AclFilter orRequireAllRoles(String roles, String ... includedOn) {
        this.withAclRules(AclRule.requireAllRoles(roles, includedOn));
        return this;
    }

    public AclFilter orRequireOneRole(String roles, String ... includedOn) {
        this.withAclRules(AclRule.requireOneRole(roles, includedOn));
        return this;
    }

    public AclFilter orRequireAllScopes(String scopes, String ... includedOn) {
        this.withAclRules(AclRule.requireAllRoles(scopes, includedOn));
        return this;
    }

    public AclFilter orRequireOneScope(String scopes, String ... includedOn) {
        this.withAclRules(AclRule.requireOneRole(scopes, includedOn));
        return this;
    }

    public AclFilter withAclRules(AclRule ... acls) {
        for (AclRule acl : acls) {
            if (this.aclRules.contains(acl)) continue;
            this.aclRules.add(acl);
        }
        Collections.sort(this.aclRules);
        return this;
    }

    public List<AclRule> getAclRules() {
        return new ArrayList<AclRule>(this.aclRules);
    }

    @Override
    public void run(Request req, Response resp) throws ApiException {
        this.log.debug("Request Path: " + req.getUrl().getPath());
        boolean allowed = false;
        for (AclRule aclRule : this.aclRules) {
            if (!aclRule.ruleMatches(req)) continue;
            if (!aclRule.isAllow()) {
                Chain.debug("AclAction: MATCH_DENY" + aclRule, new Object[0]);
                allowed = false;
                break;
            }
            if (!aclRule.isInfo() && aclRule.isAllow()) {
                Chain.debug("AclAction: MATCH_ALLOW " + aclRule, new Object[0]);
                allowed = true;
                break;
            }
            Chain.debug("AclAction: MATCH_INFO " + aclRule, new Object[0]);
        }
        if (!allowed) {
            Chain.debug("AclAction: NO_MATCH_DENY", new Object[0]);
            throw ApiException.new403Forbidden();
        }
    }
}

