/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Index;
import io.inversion.Property;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Relationship
implements Serializable {
    public static final String REL_ONE_TO_ONE_PARENT = "ONE_TO_ONE_PARENT";
    public static final String REL_ONE_TO_ONE_CHILD = "ONE_TO_ONE_CHILD";
    public static final String REL_MANY_TO_ONE = "MANY_TO_ONE";
    public static final String REL_ONE_TO_MANY = "ONE_TO_MANY";
    public static final String REL_MANY_TO_MANY = "MANY_TO_MANY";
    protected String name = null;
    protected String type = null;
    protected Index fkIndex1 = null;
    protected Index fkIndex2 = null;
    protected Collection collection = null;
    protected Collection related = null;
    protected boolean exclude = false;

    public Relationship() {
    }

    public Relationship(String name, String type, Collection collection, Collection related, Index fkIndex1, Index fkIndex2) {
        this.withName(name);
        this.withType(type);
        this.withCollection(collection);
        this.withRelated(related);
        this.withFkIndex1(fkIndex1);
        this.withFkIndex2(fkIndex2);
    }

    public boolean isExclude() {
        return this.exclude || this.fkIndex1 != null && this.fkIndex1.isExclude() || this.fkIndex2 != null && this.fkIndex2.isExclude();
    }

    public Relationship withExclude(boolean exclude) {
        this.exclude = exclude;
        return this;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Relationship withCollection(Collection collection) {
        if (this.collection != collection) {
            this.collection = collection;
            if (collection != null) {
                collection.withRelationship(this);
            }
        }
        return this;
    }

    public Collection getRelated() {
        return this.related;
    }

    public Relationship getInverse() {
        if (this.isManyToMany()) {
            for (Relationship other : this.related.getRelationships()) {
                if (other == this || !other.isManyToMany() || !this.getFkIndex1().equals(other.getFkIndex2())) continue;
                return other;
            }
        } else {
            for (Relationship other : this.related.getRelationships()) {
                if (other == this || this.isManyToOne() && !other.isOneToMany() || this.isManyToMany() && !other.isManyToOne() || this.isOneToOneParent() && !other.isOneToOneChild() || this.isOneToOneChild() && !other.isOneToOneParent() || !this.getFkIndex1().equals(other.getFkIndex1()) || !this.getPrimaryKeyTable1().getResourceIndex().equals(other.getPrimaryKeyTable1().getResourceIndex())) continue;
                return other;
            }
        }
        return null;
    }

    public Relationship withRelated(Collection related) {
        this.related = related;
        return this;
    }

    public boolean isManyToMany() {
        return REL_MANY_TO_MANY.equalsIgnoreCase(this.type);
    }

    public boolean isOneToMany() {
        return REL_ONE_TO_MANY.equalsIgnoreCase(this.type);
    }

    public boolean isManyToOne() {
        return REL_MANY_TO_ONE.equalsIgnoreCase(this.type);
    }

    public boolean isOneToOneParent() {
        return REL_ONE_TO_ONE_PARENT.equalsIgnoreCase(this.type);
    }

    public boolean isOneToOneChild() {
        return REL_ONE_TO_ONE_CHILD.equalsIgnoreCase(this.type);
    }

    public String getName() {
        return this.name;
    }

    public Relationship withName(String name) {
        this.name = name;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Relationship)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        try {
            String str = this.collection.getName() + "." + this.getName() + " : " + this.getType() + " ";
            str = this.isManyToOne() ? str + this.getFkIndex1() + " -> " + this.getRelated().getResourceIndex() : (this.isOneToMany() ? str + this.collection.getResourceIndex() + " <- " + this.getFkIndex1() : str + this.getFkIndex1() + " <--> " + this.getFkIndex2());
            return str;
        }
        catch (NullPointerException ex) {
            return "Relationship: " + this.name + "-" + this.type + "-" + this.fkIndex1 + "-" + this.fkIndex2;
        }
    }

    public String getType() {
        return this.type;
    }

    public Relationship withType(String type) {
        this.type = type;
        return this;
    }

    public Index getFkIndex1() {
        return this.fkIndex1;
    }

    public Relationship withFkIndex1(Index fkIndex1) {
        this.fkIndex1 = fkIndex1;
        return this;
    }

    public Index getFkIndex2() {
        return this.fkIndex2;
    }

    public Relationship withFkIndex2(Index fkIndex2) {
        this.fkIndex2 = fkIndex2;
        return this;
    }

    public Collection getPrimaryKeyTable1() {
        return this.fkIndex1.getProperty(0).getCollection();
    }

    public Property getFk1Col1() {
        return this.fkIndex1.getProperty(0);
    }

    public Property getFk2Col1() {
        return this.fkIndex2.getProperty(0);
    }

    public Map<String, Object> buildPrimaryKeyFromForeignKey(Map<String, Object> foreignKey) {
        if (!this.isManyToOne()) {
            throw new ApiException("unsupported", new Object[0]);
        }
        LinkedHashMap<String, Object> primaryKey = new LinkedHashMap<String, Object>();
        Index fkIdx = this.getFkIndex1();
        Index pkIdx = this.getRelated().getResourceIndex();
        if (fkIdx.size() == 1 && pkIdx.size() > 1) {
            Object compressedFk = foreignKey.get(fkIdx.getProperty(0));
            if (!(compressedFk instanceof String)) {
                return null;
            }
            Map<String, Object> decoded = this.getRelated().decodeKeyToJsonNames((String)compressedFk);
            if (decoded == null) {
                return null;
            }
            primaryKey.putAll(decoded);
        } else if (fkIdx.size() > 1 && pkIdx.size() > 0) {
            String compressedPk = Collection.encodeKey(foreignKey, this.getFkIndex1(), true);
            if (compressedPk == null) {
                return null;
            }
            primaryKey.put(fkIdx.getJsonName(0), compressedPk);
        } else if (fkIdx.size() == pkIdx.size()) {
            for (int i = 0; i < fkIdx.size(); ++i) {
                Property prop = fkIdx.getProperty(i);
                String pkProp = prop.getPk().getJsonName();
                Object value = foreignKey.get(prop.getJsonName());
                if (value == null) {
                    return null;
                }
                primaryKey.put(pkProp, value);
            }
        } else {
            throw new ApiException("Unable to map between indexes.", new Object[0]);
        }
        return primaryKey;
    }

    public Map<String, Object> buildForeignKeyFromPrimaryKey(Map<String, Object> primaryKey) {
        if (!this.isManyToOne()) {
            throw new ApiException("unsupported", new Object[0]);
        }
        LinkedHashMap<String, Object> foreignKey = new LinkedHashMap<String, Object>();
        Index fkIdx = this.getFkIndex1();
        Index pkIdx = this.getRelated().getResourceIndex();
        if (fkIdx.size() == 1 && pkIdx.size() > 1) {
            this.getRelated();
            String compressedFk = Collection.encodeKey(primaryKey, this.getRelated().getResourceIndex(), true);
            if (compressedFk == null) {
                return null;
            }
            foreignKey.put(fkIdx.getJsonName(0), compressedFk);
        } else if (fkIdx.size() <= 1 || pkIdx.size() != 0) {
            if (fkIdx.size() == pkIdx.size()) {
                for (int i = 0; i < fkIdx.size(); ++i) {
                    Object value;
                    Property prop = fkIdx.getProperty(i);
                    if (prop == null || prop.getPk() == null) {
                        System.out.println("what?");
                    }
                    if ((value = primaryKey.get(prop.getPk().getJsonName())) == null) {
                        return null;
                    }
                    foreignKey.put(prop.getJsonName(), value);
                }
            } else {
                throw new ApiException("Unable to map between indexes.", new Object[0]);
            }
        }
        return foreignKey;
    }
}

