/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.azure.functions;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpMethod;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatus;
import com.microsoft.azure.functions.annotation.AuthorizationLevel;
import com.microsoft.azure.functions.annotation.FunctionName;
import com.microsoft.azure.functions.annotation.HttpTrigger;
import io.inversion.Api;
import io.inversion.Engine;
import io.inversion.Request;
import io.inversion.Response;
import java.util.List;
import java.util.Optional;

public class AzureFunctionHttpTriggerHandler {
    protected Engine engine = null;
    protected Api api = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FunctionName(value="HttpTrigger-Java")
    public HttpResponseMessage run(@HttpTrigger(name="req", methods={HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.OPTIONS, HttpMethod.DELETE}, authLevel=AuthorizationLevel.ANONYMOUS) HttpRequestMessage<Optional<String>> request, ExecutionContext context) {
        try {
            if (this.engine == null) {
                AzureFunctionHttpTriggerHandler azureFunctionHttpTriggerHandler = this;
                synchronized (azureFunctionHttpTriggerHandler) {
                    if (this.engine == null) {
                        this.engine = this.buildEngine(request, context);
                    }
                }
            }
            Request req = this.buildRequest(request);
            Response res = this.engine.service(req, new Response()).getResponse();
            return this.buildHttpResponseMessage(request, req, res);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return request.createResponseBuilder(HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ex.getMessage()).build();
        }
    }

    protected Request buildRequest(HttpRequestMessage<Optional<String>> request) {
        String method = request.getHttpMethod().toString();
        String url = request.getUri().toString();
        if (url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        String body = ((Optional)request.getBody()).isPresent() ? (String)((Optional)request.getBody()).get() : null;
        Request req = new Request(method, url, request.getHeaders(), request.getQueryParameters(), body);
        return req;
    }

    protected HttpResponseMessage buildHttpResponseMessage(HttpRequestMessage<Optional<String>> azReq, Request req, Response res) throws Exception {
        HttpResponseMessage.Builder builder = azReq.createResponseBuilder(HttpStatus.valueOf((int)res.getStatusCode()));
        for (String key : res.getHeaders().keySet()) {
            List values = res.getHeaders().get((Object)key);
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < values.size(); ++i) {
                buff.append(values.get(i));
                if (i >= values.size() - 1) continue;
                buff.append(",");
            }
            builder.header(key, buff.toString());
            res.debug(key + " " + buff, new Object[0]);
        }
        if (!"OPTIONS".equals(req.getMethod())) {
            String contentType = res.getContentType();
            builder.header("Content-Type", contentType);
            String output = res.getOutput();
            builder.body((Object)output);
        }
        return builder.build();
    }

    protected Engine buildEngine(HttpRequestMessage<Optional<String>> request, ExecutionContext context) {
        Engine engine = new Engine();
        if (this.api == null) {
            this.api = this.buildApi(request, context);
        }
        if (this.api != null) {
            engine.withApi(this.api);
        }
        return engine;
    }

    protected Api buildApi(HttpRequestMessage<Optional<String>> request, ExecutionContext context) {
        return null;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Api getApi() {
        return this.api;
    }

    public void setApi(Api api) {
        this.api = api;
    }
}

