/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import io.inversion.utils.JSNode;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class Utils {
    static final String NEW_LINE = System.getProperty("line.separator");
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final String CONTAINS_TOKEN_PLACEHOLDER = "INVERSIONREPLACEDINVERSION";
    static final Pattern CONTAINS_TOKEN_PATTERN = Pattern.compile("\\b\\QINVERSIONREPLACEDINVERSION\\E\\b", 2);

    public static boolean equal(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.equals(obj2)) {
            return true;
        }
        return obj1.toString().equals(obj2.toString());
    }

    public static boolean in(Object toFind, Object ... values) {
        for (Object val : values) {
            if (!Utils.equal(toFind, val)) continue;
            return true;
        }
        return false;
    }

    public static boolean empty(Object ... arr) {
        boolean empty = true;
        for (int i = 0; empty && arr != null && i < arr.length; ++i) {
            Object obj = arr[i];
            if (obj == null || obj.toString().length() <= 0) continue;
            empty = false;
        }
        return empty;
    }

    public static Object first(List list) {
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static Object last(List list) {
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public static <T extends Collection> T add(T collection, Object ... items) {
        if (items != null) {
            Collections.addAll(collection, items);
        }
        return collection;
    }

    public static boolean endsWith(CharSequence seq, String end) {
        int endLen;
        if (end == null) {
            return false;
        }
        int seqLen = seq.length();
        if (seqLen < (endLen = end.length())) {
            return false;
        }
        for (int i = 1; i <= endLen; ++i) {
            char e;
            char s = seq.charAt(seqLen - i);
            if (s == (e = end.charAt(endLen - i))) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(CharSequence seq, String start) {
        int startLen;
        if (start == null) {
            return false;
        }
        int seqLen = seq.length();
        if (seqLen < (startLen = start.length())) {
            return false;
        }
        for (int i = 0; i < startLen; ++i) {
            char e;
            char s = seq.charAt(seqLen);
            if (s == (e = start.charAt(startLen))) continue;
            return false;
        }
        return true;
    }

    public static String implode(String glue, Object ... pieces) {
        if (pieces != null && pieces.length == 1 && pieces[0] instanceof Collection) {
            pieces = ((Collection)pieces[0]).toArray();
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; pieces != null && i < pieces.length; ++i) {
            String piece;
            if (pieces[i] == null) continue;
            String string = piece = pieces[i] instanceof Collection ? Utils.implode(glue, pieces[i]) : pieces[i].toString();
            if (piece.length() <= 0) continue;
            List<String> subPieces = Utils.explode(glue, piece);
            for (String subPiece : subPieces) {
                if (subPiece.length() <= 0) continue;
                if (str.length() > 0) {
                    str.append(glue);
                }
                str.append(subPiece);
            }
        }
        return str.toString();
    }

    public static List<String> explode(String delimiter, String ... pieces) {
        if (".".equals(delimiter)) {
            delimiter = "\\.";
        }
        ArrayList<String> exploded = new ArrayList<String>();
        for (int i = 0; pieces != null && i < pieces.length; ++i) {
            String[] parts;
            if (Utils.empty(pieces[i])) continue;
            for (String s : parts = pieces[i].split(delimiter)) {
                String part = s.trim();
                if (Utils.empty(part)) continue;
                exploded.add(part);
            }
        }
        return exploded;
    }

    public static List<String> split(String string, char splitOn, char ... quoteChars) {
        ArrayList<String> strings = new ArrayList<String>();
        HashSet<Character> quotes = new HashSet<Character>();
        for (char c : quoteChars) {
            quotes.add(Character.valueOf(c));
        }
        boolean quoted = false;
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c;
            c = string.charAt(i);
            if (c == splitOn && !quoted) {
                if (buff.length() <= 0) continue;
                strings.add(buff.toString());
                buff = new StringBuilder();
                continue;
            }
            if (quotes.contains(Character.valueOf(c))) {
                quoted = !quoted;
            }
            buff.append(c);
        }
        if (buff.length() > 0) {
            strings.add(buff.toString());
        }
        return strings;
    }

    public static String substringBefore(String string, String breakBefore) {
        int idx = string.indexOf(breakBefore);
        if (idx > -1) {
            string = string.substring(0, idx);
        }
        return string;
    }

    public static String substringAfter(String string, String breakAfterLast) {
        int idx = string.lastIndexOf(breakAfterLast);
        if (idx > -1) {
            string = string.substring(idx + breakAfterLast.length());
        }
        return string;
    }

    public static String format(String format, Object ... args) {
        int i;
        if (format == null) {
            format = "";
        }
        if (args != null && args.length == 1 && args[0].getClass().isArray()) {
            Object arg0 = args[0];
            int size = Array.getLength(arg0);
            args = new Object[size];
            for (i = 0; i < size; ++i) {
                try {
                    args[i] = Array.get(arg0, i);
                    continue;
                }
                catch (Exception ex) {
                    args[i] = ex.getMessage();
                }
            }
        }
        if (args == null || args.length < 1) {
            return format;
        }
        if ((format = format.trim()).isEmpty()) {
            for (int i2 = 0; i2 < args.length; ++i2) {
                format = format + "{}";
                if (i2 >= args.length - 1) continue;
                format = format + ", ";
            }
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            int i3;
            for (i3 = 0; i3 < args.length; ++i3) {
                try {
                    if (args[i3] == null) {
                        args[i3] = "null";
                        continue;
                    }
                    if (args[i3] instanceof Throwable) {
                        String cause = Utils.getShortCause((Throwable)args[i3]);
                        if (cause == null) {
                            cause = "UNKNOWN NULL CAUSE";
                        }
                        String message = cause;
                        if (cause.indexOf("\n") > 1) {
                            message = cause.substring(0, cause.indexOf("\n")).trim();
                        }
                        errors.add(cause);
                        args[i3] = message;
                        continue;
                    }
                    if (args[i3] instanceof byte[]) {
                        args[i3] = new String((byte[])args[i3]);
                        continue;
                    }
                    if (args[i3].getClass().isArray()) {
                        args[i3] = "[" + Utils.format(null, args[i3]) + "]";
                        continue;
                    }
                    args[i3] = args[i3] + "";
                    continue;
                }
                catch (Exception ex) {
                    args[i3] = "ERROR: " + ex.getMessage();
                }
            }
            format = format.replace("{}", "%s");
            format = String.format(format, args);
            for (i3 = 0; i3 < args.length; ++i3) {
                String arg = (String)args[i3];
                if (format.indexOf(arg) >= 0) continue;
                format = format + ", " + arg;
            }
        }
        catch (Exception ex) {
            for (i = 0; args != null && i < args.length; ++i) {
                try {
                    format = format + ", {" + args[i] + "}";
                    continue;
                }
                catch (Exception ex2) {
                    format = format + ", {" + ex2.getMessage() + "}";
                }
            }
        }
        for (String error : errors) {
            format = format + "\r\n" + error;
        }
        return format;
    }

    public static ArrayListValuedHashMap addToMap(ArrayListValuedHashMap<String, String> multiMap, String ... kvPairs) {
        if (kvPairs != null && kvPairs.length % 2 > 0) {
            throw new RuntimeException("kvPairs.length must be evenly divisible by 2.");
        }
        for (int i = 0; kvPairs != null && i < kvPairs.length - 1; i += 2) {
            multiMap.put((Object)kvPairs[i], (Object)kvPairs[i + 1]);
        }
        return multiMap;
    }

    public static <M extends Map<String, String>> M addToMap(M map, String ... keyValuePairs) {
        if (keyValuePairs != null && keyValuePairs.length % 2 > 0) {
            throw new RuntimeException("keyValuePairs.length must be evenly divisible by 2.");
        }
        for (int i = 0; keyValuePairs != null && i < keyValuePairs.length - 1; i += 2) {
            map.put((String)keyValuePairs[i], (String)keyValuePairs[i + 1]);
        }
        return map;
    }

    public static ArrayList asList(Object ... objects) {
        ArrayList list = new ArrayList(objects != null ? objects.length : 0);
        if (objects != null) {
            Collections.addAll(list, objects);
        }
        return list;
    }

    public static HashSet asSet(Object ... objects) {
        HashSet set = new HashSet();
        if (objects != null) {
            Collections.addAll(set, objects);
        }
        return set;
    }

    public static HashMap asMap(Object ... keyValuePairs) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; keyValuePairs != null && i < keyValuePairs.length - 1; i += 2) {
            map.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return map;
    }

    public static boolean containsToken(String findThisToken, String inThisString) {
        findThisToken = findThisToken.toLowerCase();
        inThisString = inThisString.toLowerCase();
        inThisString = inThisString.replace(findThisToken, CONTAINS_TOKEN_PLACEHOLDER);
        return CONTAINS_TOKEN_PATTERN.matcher(inThisString).find();
    }

    public static String dequote(String str) {
        return Utils.dequote(str, new char[]{'\'', '\"', '`'});
    }

    public static String dequote(String str, char[] quoteChars) {
        if (str == null) {
            return null;
        }
        while (str.length() >= 2 && str.charAt(0) == str.charAt(str.length() - 1)) {
            boolean changed = false;
            for (char quoteChar : quoteChars) {
                if (str.charAt(0) != quoteChar) continue;
                str = str.substring(1, str.length() - 1);
                changed = true;
                break;
            }
            if (changed) continue;
            break;
        }
        return str;
    }

    public static BigDecimal toDollarAmount(double amount) {
        return new BigDecimal(amount).setScale(2, RoundingMode.HALF_UP);
    }

    public static int roundUp(int num, int divisor) {
        int sign = (num > 0 ? 1 : -1) * (divisor > 0 ? 1 : -1);
        return sign * (Math.abs(num) + Math.abs(divisor) - 1) / Math.abs(divisor);
    }

    public static boolean atob(Object str) {
        try {
            String bool = (str + "").trim().toLowerCase();
            return !"0".equals(bool) && !"false".equals(bool);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int atoi(Object str) {
        try {
            return Integer.parseInt(str.toString().trim());
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static long atol(Object str) {
        try {
            return Long.parseLong(str.toString().trim());
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static float atof(Object str) {
        try {
            return Float.parseFloat(str.toString().trim());
        }
        catch (Exception exception) {
            return -1.0f;
        }
    }

    public static double atod(Object str) {
        try {
            return Double.parseDouble(str.toString().trim());
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public static String slugify(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase().trim();
        str = str.replaceAll("[']+", "");
        str = str.replaceAll("[^a-z0-9]+", "-");
        str = str.replaceAll("([\\-])(\\1{2,})", "$1");
        str = str.replaceAll("^-", "");
        str = str.replaceAll("-$", "");
        return str;
    }

    public static String sha1(byte[] bytes) {
        return Utils.hash(bytes, "SHA-1");
    }

    public static String md5(byte[] bytes) {
        return Utils.hash(bytes, "MD5");
    }

    public static String hash(byte[] bytes, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(bytes);
            bytes = digest.digest();
            return new HexBinaryAdapter().marshal(bytes);
        }
        catch (Exception ex) {
            Utils.rethrow(ex);
            return null;
        }
    }

    public static long time() {
        return System.currentTimeMillis();
    }

    public static Date parseIso8601(String date) {
        DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_DATE_TIME;
        TemporalAccessor accessor = timeFormatter.parse(date);
        return Date.from(Instant.from(accessor));
    }

    public static String formatIso8601(Date date) {
        return ISO8601Utils.format((Date)date);
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(date);
    }

    public static Date date(String date, String format) {
        try {
            date = date.trim();
            SimpleDateFormat df = new SimpleDateFormat(format);
            return df.parse(date);
        }
        catch (Exception ex) {
            Utils.rethrow(ex);
            return null;
        }
    }

    public static Date date(String date) {
        try {
            return Utils.parseIso8601(date);
        }
        catch (Exception exception) {
            try {
                SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
                return f.parse(date);
            }
            catch (Exception f) {
                try {
                    SimpleDateFormat f2 = new SimpleDateFormat("MM/dd/yy");
                    int lastSlash = date.lastIndexOf("/");
                    if (lastSlash > 0 && lastSlash == date.length() - 5) {
                        f2 = new SimpleDateFormat("MM/dd/yyyy");
                    }
                    return f2.parse(date);
                }
                catch (Exception f2) {
                    try {
                        SimpleDateFormat f3 = new SimpleDateFormat("yyyyMMdd");
                        return f3.parse(date);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("unsupported format: " + date);
                    }
                }
            }
        }
    }

    public static boolean testCompare(String expected, String actual) {
        expected = expected != null ? expected : "";
        actual = actual != null ? actual : "";
        if (!(expected = expected.replaceAll("\\s+", " ").trim()).equals(actual = actual.replaceAll("\\s+", " ").trim())) {
            System.out.println("EXPECTED : " + expected);
            System.out.println("ACTUAL   : " + actual);
            for (int i = 0; i < expected.length() && i < actual.length(); ++i) {
                if (expected.charAt(i) != actual.charAt(i)) {
                    System.out.println("X");
                    break;
                }
                System.out.print("           ");
            }
            System.out.println(" ");
            return false;
        }
        return true;
    }

    public static Throwable getCause(Throwable t) {
        Throwable original = t;
        for (int guard = 0; t != null && t.getCause() != null && t.getCause() != t && guard < 100; t = t.getCause(), ++guard) {
        }
        if (t == null) {
            t = original;
        }
        return t;
    }

    public static void error(String message) throws RuntimeException {
        throw new RuntimeException(message);
    }

    public static void rethrow(Throwable error) throws RuntimeException {
        Utils.rethrow(null, error);
    }

    public static void rethrow(String message, Throwable error) throws RuntimeException {
        Throwable cause = error;
        while (cause.getCause() != null && cause.getCause() != error) {
            cause = cause.getCause();
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        if (!Utils.empty(message)) {
            throw new RuntimeException(message, error);
        }
        throw new RuntimeException(error);
    }

    public static void sleep(long milliseconds) throws RuntimeException {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Utils.rethrow(e);
        }
    }

    public static String getShortCause(Throwable t) {
        return Utils.getShortCause(t, 15);
    }

    public static String getShortCause(Throwable t, int lines) {
        t = Utils.getCause(t);
        return Utils.limitLines(Utils.cleanStackTrace(Utils.getStackTraceString(t)), lines);
    }

    public static List<String> getStackTraceLines(Throwable stackTrace) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        if (stackTrace != null) {
            stackTrace.printStackTrace(writer);
        } else {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace(writer);
            }
        }
        writer.close();
        String s = new String(baos.toByteArray());
        String[] sArr = s.split("\n");
        return new ArrayList<String>(Arrays.asList(sArr));
    }

    public static String getStackTraceString(Throwable stackTrace) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        boolean createNewTrace = false;
        if (stackTrace != null) {
            try {
                stackTrace.printStackTrace(writer);
            }
            catch (Exception e) {
                createNewTrace = true;
            }
        } else {
            createNewTrace = true;
        }
        if (createNewTrace) {
            try {
                throw new Exception("Unable to get original stacktrace.");
            }
            catch (Exception e) {
                e.printStackTrace(writer);
            }
        }
        writer.close();
        return new String(baos.toByteArray());
    }

    static String cleanStackTrace(String stackTrace) {
        String[] ignoredCauses = new String[]{"java.lang.reflect.UndeclaredThrowableException", "java.lang.reflect.InvocationTargetException"};
        String[] lines = Utils.splitLines(stackTrace);
        boolean chop = false;
        if (stackTrace.indexOf("Caused by: ") > 0) {
            for (String ignoredCause : ignoredCauses) {
                if (!lines[0].contains(ignoredCause)) continue;
                chop = true;
                break;
            }
        }
        int start = 0;
        if (chop) {
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].startsWith("Caused by:")) {
                    lines[i] = lines[i].substring(10);
                    break;
                }
                ++start;
            }
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = start; i < lines.length; ++i) {
            buffer.append(lines[i]).append("\r\n");
        }
        if (chop) {
            return Utils.cleanStackTrace(buffer.toString());
        }
        return buffer.toString();
    }

    public static String[] splitLines(String text) {
        if (text == null || "".equals(text)) {
            return EMPTY_STRING_ARRAY;
        }
        String lineSeparator = text.contains(NEW_LINE) ? NEW_LINE : "\n";
        return text.split(lineSeparator);
    }

    public static String limitLines(String text, int limit) {
        StringBuilder buffer = new StringBuilder();
        String[] lines = Utils.splitLines(text);
        for (int i = 0; i < lines.length && i < limit; ++i) {
            if (i == limit - 1 && i != lines.length - 1) {
                buffer.append("...").append(lines.length - i).append(" more");
                continue;
            }
            buffer.append(lines[i]).append(NEW_LINE);
        }
        return buffer.toString();
    }

    public static Field getField(String fieldName, Class clazz) {
        if (fieldName == null || clazz == null) {
            return null;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            field.setAccessible(true);
            return field;
        }
        if (clazz.getSuperclass() != null && !clazz.equals(clazz.getSuperclass())) {
            return Utils.getField(fieldName, clazz.getSuperclass());
        }
        return null;
    }

    public static List<Field> getFields(Class clazz) {
        HashSet<String> found = new HashSet<String>();
        ArrayList<Field> fields = new ArrayList<Field>();
        while (!clazz.getName().startsWith("java")) {
            Field[] farr;
            for (Field f : farr = clazz.getDeclaredFields()) {
                if (found.contains(f.getName())) continue;
                try {
                    f.setAccessible(true);
                    found.add(f.getName());
                    fields.add(f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((clazz = clazz.getSuperclass()) != null && !Object.class.equals(clazz)) continue;
        }
        return fields;
    }

    public static Method getMethod(Class clazz, String name) {
        while (clazz != null && !Object.class.equals((Object)clazz)) {
            for (Method m : clazz.getMethods()) {
                if (!m.getName().equalsIgnoreCase(name)) continue;
                return m;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Object getBeanProperty(String propertyName, Object bean) {
        try {
            Method getter = Utils.getMethod(bean.getClass(), "get" + propertyName);
            if (getter != null) {
                return getter.invoke(bean, new Object[0]);
            }
            Field field = Utils.getField(propertyName, bean.getClass());
            if (field != null) {
                return field.get(bean);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String read(String fileOrUrl) {
        return Utils.read(Utils.findInputStream(fileOrUrl));
    }

    public static String read(InputStream in) throws RuntimeException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Utils.pipe(in, out);
            return new String(out.toByteArray());
        }
        catch (Exception ex) {
            Utils.rethrow(ex);
            return null;
        }
    }

    public static String read(File file) throws IOException {
        return Utils.read(new BufferedInputStream(new FileInputStream(file)));
    }

    public static void write(File file, String text) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create the parent directory");
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        bw.write(text);
        bw.flush();
        bw.close();
    }

    public static void write(String file, String text) throws IOException {
        if (text == null) {
            return;
        }
        Utils.write(new File(file), text);
    }

    public static void pipe(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) > -1) {
            out.write(buffer, 0, read);
        }
        out.close();
    }

    public static File createTempFile(String fileName) throws IOException {
        if (Utils.empty(fileName)) {
            fileName = "working.tmp";
        }
        fileName = fileName.trim();
        if ((fileName = fileName.replace('\\', '/')).endsWith("/")) {
            fileName = "working.tmp";
        } else if (fileName.lastIndexOf(47) > 0) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        }
        if (Utils.empty(fileName)) {
            fileName = "working.tmp";
        }
        if ((fileName = Utils.slugify(fileName)).lastIndexOf(46) > 0) {
            String prefix = fileName.substring(0, fileName.lastIndexOf(46));
            String suffix = fileName.substring(fileName.lastIndexOf(46));
            return File.createTempFile(prefix + "-", suffix);
        }
        return File.createTempFile(fileName, "");
    }

    public static InputStream findInputStream(String fileOrUrl) throws RuntimeException {
        try {
            if (fileOrUrl.startsWith("file:/")) {
                fileOrUrl = URLDecoder.decode(fileOrUrl, "UTF-8");
            }
            if (fileOrUrl.startsWith("file:///")) {
                fileOrUrl = fileOrUrl.substring(7);
            }
            if (fileOrUrl.startsWith("file:/")) {
                fileOrUrl = fileOrUrl.substring(5);
            }
            if (fileOrUrl.indexOf(58) >= 0) {
                return new URL(fileOrUrl).openStream();
            }
            if (new File(fileOrUrl).exists()) {
                return new FileInputStream(fileOrUrl);
            }
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(fileOrUrl);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static boolean isWildcard(String str) {
        return str.indexOf(42) >= 0 || str.indexOf(63) >= 0;
    }

    public static boolean wildcardMatch(String wildcard, String string) {
        if (wildcard.equals("*")) {
            return true;
        }
        if (Utils.empty(wildcard) || Utils.empty(string)) {
            return false;
        }
        if (!Utils.isWildcard(wildcard)) {
            return wildcard.equals(string);
        }
        return string.matches(Utils.wildcardToRegex(wildcard));
    }

    public static String wildcardToRegex(String wildcard) {
        wildcard = wildcard.replace("**", "*");
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    public static LinkedHashMap<String, String> parseQueryString(String query) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (query != null) {
            try {
                while (query.startsWith("?") || query.startsWith("&") || query.startsWith("=")) {
                    query = query.substring(1);
                }
                if (query.length() > 0) {
                    String[] pairs;
                    for (String pair : pairs = query.split("&")) {
                        if ((pair = pair.trim()).length() == 0) continue;
                        int idx = pair.indexOf("=");
                        if (idx > 0) {
                            String key = pair.substring(0, idx).trim();
                            key = URLDecoder.decode(key, "UTF-8");
                            String value = pair.substring(idx + 1).trim();
                            value = URLDecoder.decode(value, "UTF-8");
                            params.put(key, value);
                            continue;
                        }
                        params.put(URLDecoder.decode(pair, "UTF-8"), null);
                    }
                }
            }
            catch (Exception ex) {
                Utils.rethrow(ex);
            }
        }
        return params;
    }

    public static String findSysEnvProp(String ... names) {
        for (String name : names) {
            String value = Utils.getSysEnvProp(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static String getSysEnvPropStr(String name, Object defaultValue) {
        Object obj = Utils.getSysEnvProp(name, defaultValue);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static int getSysEnvPropInt(String name, Object defaultValue) {
        Object obj = Utils.getSysEnvProp(name, defaultValue);
        if (obj != null) {
            return Integer.parseInt(obj.toString());
        }
        return -1;
    }

    public static boolean getSysEnvPropBool(String name, Object defaultValue) {
        Object obj = Utils.getSysEnvProp(name, defaultValue);
        if (obj != null) {
            return "true".equalsIgnoreCase(obj.toString());
        }
        return false;
    }

    public static Object getSysEnvProp(String name, Object defaultValue) {
        String value = Utils.getSysEnvProp(name);
        return null == value ? defaultValue : value;
    }

    public static String getSysEnvProp(String name) {
        InputStream stream;
        String value = System.getProperty(name);
        if (Utils.empty(value)) {
            value = System.getProperty(name.replace(".", "_"));
        }
        if (Utils.empty(value)) {
            value = System.getenv(name);
        }
        if (Utils.empty(value)) {
            value = System.getenv(name.replace(".", "_"));
        }
        if (Utils.empty(value) && (stream = Utils.findInputStream(".env")) != null) {
            Properties p = new Properties();
            try {
                p.load(stream);
                Utils.close(stream);
                value = p.getProperty(name);
            }
            catch (Exception ex) {
                Utils.rethrow(ex);
            }
        }
        return value;
    }

    public static Object castDbOutput(String type, Object value) {
        if (type == null || value == null) {
            return value;
        }
        if ("json".equalsIgnoreCase(type = type.toLowerCase())) {
            String json = value.toString().trim();
            if (json.isEmpty()) {
                return new JSNode();
            }
            return JSNode.parseJson(json);
        }
        if (Utils.in(type, "char", "nchar", "clob")) {
            value = value.toString().trim();
        }
        if (value instanceof Date && Utils.in(type, "date", "datetime", "timestamp")) {
            value = Utils.formatIso8601((Date)value);
        }
        return value;
    }

    /*
     * Exception decompiling
     */
    public static Object castJsonInput(String type, Object value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [55[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void close(Object ... toClose) {
        for (Object o : toClose) {
            if (o == null) continue;
            try {
                if (o instanceof Closeable) {
                    ((Closeable)o).close();
                    continue;
                }
                Method m = o.getClass().getMethod("close", new Class[0]);
                m.invoke(o, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

