/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.JsonDiff;
import com.flipkart.zjsonpatch.JsonPatch;
import io.inversion.utils.JSArray;
import io.inversion.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class JSNode
implements Map<String, Object> {
    LinkedHashMap<String, JSProperty> properties = new LinkedHashMap();

    public JSNode() {
    }

    public JSNode(Object ... nameValuePairs) {
        this.with(nameValuePairs);
    }

    public JSNode(Map nameValuePairs) {
        this.putAll(nameValuePairs);
    }

    public static Object parseJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = (JsonNode)mapper.readValue(json, JsonNode.class);
            Object parsed = JSNode.mapNode(rootNode);
            return parsed;
        }
        catch (Exception ex) {
            String msg = "Error parsing JSON:" + ex.getMessage();
            if (!(ex instanceof JsonParseException)) {
                msg = msg + "\r\nSource:" + json;
            }
            throw new RuntimeException("400 Bad Request: '" + msg + "'");
        }
    }

    public static JSNode parseJsonNode(String json) throws ClassCastException {
        return (JSNode)JSNode.parseJson(json);
    }

    public static JSArray parseJsonArray(String json) {
        return (JSArray)JSNode.parseJson(json);
    }

    static String toJson(JSNode node, boolean pretty, boolean lowercasePropertyNames) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator((OutputStream)baos);
            if (pretty) {
                json.useDefaultPrettyPrinter();
            }
            JSNode.writeNode(node, json, new HashMap<Object, String>(), lowercasePropertyNames, "#");
            json.flush();
            baos.flush();
            return new String(baos.toByteArray());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static Object mapNode(JsonNode json) {
        if (json == null) {
            return null;
        }
        if (json.isNull()) {
            return null;
        }
        if (json.isValueNode()) {
            if (json.isNumber()) {
                return json.numberValue();
            }
            if (json.isBoolean()) {
                return json.booleanValue();
            }
            return json.asText();
        }
        if (json.isArray()) {
            JSArray retVal = new JSArray(new Object[0]);
            for (JsonNode child : json) {
                retVal.add(JSNode.mapNode(child));
            }
            return retVal;
        }
        if (json.isObject()) {
            JSNode retVal = new JSNode();
            Iterator it = json.fieldNames();
            while (it.hasNext()) {
                String field = (String)it.next();
                JsonNode value = json.get(field);
                retVal.put(field, JSNode.mapNode(value));
            }
            return retVal;
        }
        throw new RuntimeException("unparseable json:" + json);
    }

    static void writeNode(JSNode node, JsonGenerator json, HashMap<Object, String> visited, boolean lowercaseNames, String path) throws Exception {
        JSProperty href = node.getProperty("href");
        if (visited.containsKey(node)) {
            json.writeStartObject();
            if (href != null) {
                json.writeStringField("@link", href.getValue() + "");
            }
            json.writeStringField("$ref", visited.get(node));
            json.writeEndObject();
            return;
        }
        visited.put(node, path);
        if (node instanceof JSArray) {
            JSNode.writeArrayNode((JSArray)node, json, visited, lowercaseNames, path);
            return;
        }
        json.writeStartObject();
        if (href != null) {
            json.writeStringField("href", href.getValue() + "");
        }
        for (String key : node.keySet()) {
            JSProperty p = node.getProperty(key);
            if (p == href) continue;
            String name = lowercaseNames ? p.getName().toLowerCase() : p.getName();
            Object value = p.getValue();
            if (value == null) {
                json.writeNullField(name);
                continue;
            }
            if (value instanceof JSNode) {
                json.writeFieldName(name);
                JSNode.writeNode((JSNode)value, json, visited, lowercaseNames, path + "/" + name);
                continue;
            }
            if (value instanceof String) {
                if (value.equals("null")) {
                    json.writeNullField(name);
                    continue;
                }
                json.writeStringField(name, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                json.writeBooleanField(name, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                json.writeNumberField(name, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                json.writeNumberField(name, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Float) {
                json.writeNumberField(name, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                json.writeNumberField(name, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof BigInteger) {
                json.writeNumberField(name, ((BigInteger)value).intValue());
                continue;
            }
            if (value instanceof BigDecimal) {
                json.writeNumberField(name, (BigDecimal)value);
                continue;
            }
            if (value instanceof Date) {
                json.writeStringField(name, Utils.formatDate((Date)value, "yyyy-MM-dd'T'HH:mmZ"));
                continue;
            }
            String strVal = value + "";
            if ("null".equals(strVal)) {
                json.writeNullField(name);
                continue;
            }
            strVal = JSNode.encodeStringValue(strVal);
            json.writeStringField(name, strVal);
        }
        json.writeEndObject();
    }

    static void writeArrayNode(JSArray array, JsonGenerator json, HashMap<Object, String> visited, boolean lowercaseNames, String path) throws Exception {
        json.writeStartArray();
        List values = array.asList();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value == null) {
                json.writeNull();
                continue;
            }
            if (value instanceof JSNode) {
                path = path + "[" + i + "]";
                JSNode.writeNode((JSNode)value, json, visited, lowercaseNames, path);
                continue;
            }
            if (value instanceof String) {
                if (value.equals("null")) {
                    json.writeNull();
                    continue;
                }
                json.writeString(value.toString());
                continue;
            }
            if (value instanceof Boolean) {
                json.writeBoolean(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                json.writeNumber(((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                json.writeNumber(((Long)value).longValue());
                continue;
            }
            if (value instanceof Float) {
                json.writeNumber(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                json.writeNumber(((Double)value).doubleValue());
                continue;
            }
            if (value instanceof BigInteger) {
                json.writeNumber((BigInteger)value);
                continue;
            }
            if (value instanceof BigDecimal) {
                json.writeNumber((BigDecimal)value);
                continue;
            }
            if (value instanceof Date) {
                json.writeString(Utils.formatDate((Date)value, "yyyy-MM-dd'T'HH:mmZ"));
                continue;
            }
            json.writeString(JSNode.encodeStringValue(value.toString()));
        }
        json.writeEndArray();
    }

    static String encodeStringValue(String str) {
        if (str == null) {
            return null;
        }
        str = str.replaceAll("[\\p{Cntrl}\\p{Cc}\\p{Cf}\\p{Co}\\p{Cn}\u00a0&&[^\r\n\t]]", " ");
        return str;
    }

    static String fromJsonPointer(String jsonPointer) {
        if (jsonPointer.charAt(0) == '#') {
            jsonPointer = jsonPointer.substring(1);
        }
        return jsonPointer.replace('/', '.');
    }

    static String fromJsonPath(String jsonPath) {
        if (jsonPath.charAt(0) == '#') {
            jsonPath = jsonPath.substring(1);
        }
        if (jsonPath.charAt(0) == '$') {
            jsonPath = jsonPath.substring(1);
        }
        jsonPath = jsonPath.replace("@.", "@_");
        jsonPath = jsonPath.replaceAll("([a-zA-Z])\\[", "$1.[");
        jsonPath = jsonPath.replace("..", "**.");
        jsonPath = jsonPath.replaceAll("([a-zA-Z])[*]", "$1.*");
        jsonPath = jsonPath.replaceAll("([a-zA-Z])\\[([0-9]*)\\]", "$1.$2");
        jsonPath = jsonPath.replaceAll("\\.\\[([0-9]*)\\]", ".$1");
        jsonPath = jsonPath.replace("[*]", "*");
        return jsonPath;
    }

    public JSArray findAll(String pathExpression, int qty) {
        pathExpression = JSNode.fromJsonPointer(pathExpression);
        pathExpression = JSNode.fromJsonPath(pathExpression);
        return new JSArray(this.findAll0(pathExpression, qty, new ArrayList(), new HashMap<String, Set<JSNode>>()));
    }

    List findAll0(String pathExpression, int qty, List collected, HashMap<String, Set<JSNode>> visited) {
        JSONPathTokenizer tok = new JSONPathTokenizer("['\"", "]'\"", "]", ".", "", ". \t", pathExpression);
        List<String> path = tok.asList();
        return this.findAll0(path, qty, collected, visited);
    }

    List findAll0(List<String> path, int qty, List collected, HashMap<String, Set<JSNode>> visited) {
        String pathStr = path.toString();
        Set<JSNode> old = visited.get(pathStr);
        if (old == null) {
            old = new HashSet<JSNode>();
            visited.put(pathStr, old);
        }
        if (old.contains(this)) {
            return collected;
        }
        old.add(this);
        if (qty > 1 && collected.size() >= qty) {
            return collected;
        }
        String nextSegment = path.get(0);
        if ("*".equals(nextSegment)) {
            if (path.size() == 1) {
                Collection values = this.values();
                for (Object value : values) {
                    if (collected.contains(value) || qty >= 1 && collected.size() >= qty) continue;
                    collected.add(value);
                }
            } else {
                List<String> nextPath = path.subList(1, path.size());
                for (Object value : this.values()) {
                    if (!(value instanceof JSNode)) continue;
                    ((JSNode)value).findAll0(nextPath, qty, collected, visited);
                }
            }
        } else if ("**".equals(nextSegment)) {
            if (path.size() != 1) {
                List<String> nextPath = path.subList(1, path.size());
                this.findAll0(nextPath, qty, collected, visited);
                for (Object value : this.values()) {
                    if (!(value instanceof JSNode)) continue;
                    ((JSNode)value).findAll0(path, qty, collected, visited);
                }
            }
        } else if (nextSegment.startsWith("[") && nextSegment.endsWith("]")) {
            String expr = nextSegment.substring(1, nextSegment.length() - 1).trim();
            if (expr.startsWith("?(") && expr.endsWith(")")) {
                Object found;
                List found2;
                String token;
                JSONPathTokenizer tokenizer = new JSONPathTokenizer("'\"", "'\"", "?=<>!", "]=<>! ", "[()", "]. \t", expr);
                String func = null;
                String subpath = null;
                String op = null;
                String value = null;
                while ((token = tokenizer.next()) != null) {
                    if (token.equals("?")) {
                        func = "?";
                        continue;
                    }
                    if (token.startsWith("@_")) {
                        subpath = token.substring(2);
                        continue;
                    }
                    if (Utils.in(token, "=", ">", "<", "!")) {
                        if (op == null) {
                            op = token;
                            continue;
                        }
                        op = op + token;
                        continue;
                    }
                    if (subpath == null || op == null || value != null) continue;
                    value = token;
                    if (this.isArray()) {
                        for (Object child : this.values()) {
                            if (!(child instanceof JSNode)) continue;
                            found2 = ((JSNode)child).findAll0(subpath, -1, new ArrayList(), visited);
                            for (Object val : found2) {
                                if (!this.eval(val, op, value) || collected.contains(child) || qty >= 1 && collected.size() >= qty) continue;
                                collected.add(child);
                            }
                        }
                    } else {
                        Object child;
                        found = this.findAll0(subpath, -1, new ArrayList(), visited);
                        child = found.iterator();
                        while (child.hasNext()) {
                            Object val = child.next();
                            if (!this.eval(val, op, value) || collected.contains(this) || qty >= 1 && collected.size() >= qty) continue;
                            collected.add(this);
                            break;
                        }
                    }
                    func = null;
                    subpath = null;
                    op = null;
                    value = null;
                }
                if ("?".equals(func) && subpath != null) {
                    if (op != null || value != null) {
                        // empty if block
                    }
                    if (this.isArray()) {
                        for (Object child : this.values()) {
                            if (!(child instanceof JSNode)) continue;
                            found2 = ((JSNode)child).findAll0(subpath, -1, new ArrayList(), visited);
                            for (Object val : found2) {
                                if (collected.contains(child) || qty >= 1 && collected.size() >= qty) continue;
                                collected.add(child);
                            }
                        }
                    } else {
                        found = this.findAll0(subpath, -1, new ArrayList(), visited);
                        if (!(found.size() <= 0 || collected.contains(this) || qty >= 1 && collected.size() >= qty)) {
                            collected.add(this);
                        }
                    }
                }
            } else if (this.isArray()) {
                int length = ((JSArray)this).length();
                ArrayList<Object> found = new ArrayList<Object>();
                if (expr.startsWith("(@_length-")) {
                    int index = Integer.parseInt(expr.substring(expr.indexOf("-") + 1, expr.length() - 1).trim());
                    if (length - index > 0) {
                        found.add(this.get(length - index));
                    }
                } else if (expr.startsWith(":")) {
                    int count = Integer.parseInt(expr.substring(1).trim());
                    for (int i = 0; i < length && i < count; ++i) {
                        found.add(this.get(count));
                    }
                } else if (expr.endsWith(":")) {
                    int idx = Integer.parseInt(expr.substring(0, expr.length() - 1).trim()) * -1;
                    if (idx <= length) {
                        found.add(this.get(length - idx));
                    }
                } else {
                    int start = Integer.parseInt(expr.substring(0, expr.indexOf(":")).trim());
                    int end = Integer.parseInt(expr.substring(expr.indexOf(":") + 1).trim());
                    for (int i = start; i <= end && i < length; ++i) {
                        found.add(this.get(i));
                    }
                }
                if (found.size() > 0) {
                    if (path.size() > 1) {
                        List<String> list = path.subList(1, path.size());
                    } else {
                        collected.addAll(found);
                    }
                }
            }
        } else {
            Object found = null;
            try {
                found = this.get(nextSegment);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (found != null) {
                if (path.size() == 1) {
                    if (!(collected.contains(found) || qty >= 1 && collected.size() >= qty)) {
                        collected.add(found);
                    }
                } else if (found instanceof JSNode) {
                    ((JSNode)found).findAll0(path.subList(1, path.size()), qty, collected, visited);
                }
            }
        }
        return collected;
    }

    boolean eval(Object var, String op, Object value) {
        value = Utils.dequote(value.toString());
        if (var instanceof Number) {
            try {
                value = Double.parseDouble(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (var instanceof Boolean) {
            try {
                value = Boolean.parseBoolean(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int comp = ((Comparable)var).compareTo(value);
        switch (op) {
            case "=": {
                return comp == 0;
            }
            case ">": {
                return comp > 0;
            }
            case ">=": {
                return comp >= 0;
            }
            case "<": {
                return comp < 0;
            }
            case "<=": {
                return comp <= 0;
            }
            case "!=": {
                return comp != 0;
            }
        }
        throw new UnsupportedOperationException("Unknown operator '" + op + "'");
    }

    public JSArray diff(JSNode source) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode patch = JsonDiff.asJson((JsonNode)((JsonNode)mapper.readValue(source.toString(), JsonNode.class)), (JsonNode)((JsonNode)mapper.readValue(this.toString(), JsonNode.class)));
            JSArray patchesArray = JSNode.parseJsonArray(patch.toPrettyString());
            return patchesArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            Utils.rethrow(e);
            return null;
        }
    }

    public void patch(JSArray patches) {
        for (JSNode patch : patches.asNodeList()) {
            String path = patch.getString("path");
            if (path != null && !path.startsWith("/")) {
                path = "/" + path.replace(".", "/");
            }
            patch.put("path", (Object)path);
            path = patch.getString("from");
            if (path == null || path.startsWith("/")) continue;
            path = "/" + path.replace(".", "/");
            patch.put("from", (Object)path);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode target = JsonPatch.apply((JsonNode)((JsonNode)mapper.readValue(patches.toString(), JsonNode.class)), (JsonNode)((JsonNode)mapper.readValue(this.toString(), JsonNode.class)));
            JSNode patched = JSNode.parseJsonNode(target.toString());
            this.properties = patched.properties;
            if (this.isArray()) {
                ((JSArray)this).objects = ((JSArray)patched).objects;
            }
        }
        catch (Exception e) {
            Utils.rethrow(e);
        }
    }

    JSProperty getProperty(String name) {
        if (name == null) {
            return null;
        }
        return this.properties.get(name.toLowerCase());
    }

    @Override
    public Object get(Object name) {
        if (name == null) {
            return null;
        }
        JSProperty p = this.getProperty(name.toString());
        if (p != null) {
            return p.getValue();
        }
        return null;
    }

    public JSNode getNode(String name) throws ClassCastException {
        return (JSNode)this.get(name);
    }

    public JSArray getArray(String name) {
        return (JSArray)this.get(name);
    }

    public String getString(String name) {
        Object value = this.get(name);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public int getInt(String name) {
        Object found = this.get(name);
        if (found != null) {
            return Utils.atoi(found);
        }
        return -1;
    }

    public long getLong(String name) {
        Object found = this.get(name);
        if (found != null) {
            return Utils.atol(found);
        }
        return -1L;
    }

    public double getDouble(String name) {
        Object found = this.get(name);
        if (found != null) {
            return Utils.atod(found);
        }
        return -1.0;
    }

    public boolean getBoolean(String name) {
        Object found = this.get(name);
        if (found != null) {
            return Utils.atob(found);
        }
        return false;
    }

    public JSNode findNode(String pathExpression) {
        return (JSNode)this.find(pathExpression);
    }

    public JSArray findArray(String pathExpression) {
        return (JSArray)this.find(pathExpression);
    }

    public String findString(String pathExpression) {
        Object found = this.find(pathExpression);
        if (found != null) {
            return found.toString();
        }
        return null;
    }

    public int findInt(String pathExpression) {
        Object found = this.find(pathExpression);
        if (found != null) {
            return Utils.atoi(found);
        }
        return -1;
    }

    public long findLong(String pathExpression) {
        Object found = this.find(pathExpression);
        if (found != null) {
            return Utils.atol(found);
        }
        return -1L;
    }

    public double findDouble(String pathExpression) {
        Object found = this.find(pathExpression);
        if (found != null) {
            return Utils.atod(found);
        }
        return -1.0;
    }

    public boolean findBoolean(String pathExpression) {
        Object found = this.find(pathExpression);
        if (found != null) {
            return Utils.atob(found);
        }
        return false;
    }

    public Object find(String pathExpression) {
        JSArray found = this.findAll(pathExpression, 1);
        if (found.size() > 0) {
            return found.get(0);
        }
        return null;
    }

    public JSArray findAll(String pathExpression) {
        return this.findAll(pathExpression, -1);
    }

    public List<JSNode> findAllNodes(String pathExpression) {
        List found = this.findAll(pathExpression).asList();
        return found;
    }

    @Override
    public Object put(String name, Object value) {
        JSProperty prop = this.properties.put(name.toLowerCase(), new JSProperty(name, value));
        return prop;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        for (String string : map.keySet()) {
            this.put(string.toString(), map.get(string));
        }
    }

    public Object putFirst(String name, Object value) {
        LinkedHashMap<String, JSProperty> temp = new LinkedHashMap<String, JSProperty>();
        temp.put(name.toLowerCase(), new JSProperty(name, value));
        JSProperty prop = (JSProperty)this.properties.remove(name.toLowerCase());
        temp.putAll(this.properties);
        this.properties = temp;
        return prop;
    }

    public JSNode with(Object ... nvPairs) {
        if (nvPairs == null || nvPairs.length == 0) {
            return this;
        }
        if (nvPairs.length % 2 != 0) {
            throw new RuntimeException("You must supply an even number of arguments to JSNode.with()");
        }
        for (int i = 0; i < nvPairs.length - 1; i += 2) {
            Object value = nvPairs[i + 1];
            if (value instanceof Map && !(value instanceof JSNode)) {
                throw new RuntimeException("Invalid map value");
            }
            if (value instanceof List && !(value instanceof JSArray)) {
                throw new RuntimeException("Invalid list value");
            }
            this.put(nvPairs[i] + "", value);
        }
        return this;
    }

    @Override
    public boolean containsKey(Object name) {
        if (name == null) {
            return false;
        }
        return this.properties.containsKey(name.toString().toLowerCase());
    }

    @Override
    public Object remove(Object name) {
        if (name == null) {
            return null;
        }
        JSProperty old = this.removeProperty(name.toString());
        return old != null ? old.getValue() : old;
    }

    public Object removeAll(String ... names) {
        Object first = null;
        for (String name : names) {
            Object removed = this.remove(name);
            first = first != null ? first : removed;
        }
        return first;
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (String key : this.properties.keySet()) {
            JSProperty p = this.getProperty(key);
            keys.add(p.getName());
        }
        return keys;
    }

    public boolean hasProperty(String name) {
        JSProperty property = this.getProperty(name);
        return property != null;
    }

    List<JSProperty> getProperties() {
        return new ArrayList<JSProperty>(this.properties.values());
    }

    JSProperty removeProperty(String name) {
        JSProperty property = this.getProperty(name.toLowerCase());
        if (property != null) {
            this.properties.remove(name.toLowerCase());
        }
        return property;
    }

    public Map<? extends String, ? extends Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (JSProperty p : this.properties.values()) {
            String name = p.name;
            Object value = p.value;
            map.put(name, value);
        }
        return map;
    }

    public JSNode copy() {
        return JSNode.parseJsonNode(this.toString());
    }

    public void sortKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.properties.keySet());
        Collections.sort(keys);
        LinkedHashMap<String, JSProperty> newProps = new LinkedHashMap<String, JSProperty>();
        for (String key : keys) {
            newProps.put(key, this.getProperty(key));
        }
        this.properties = newProps;
    }

    public boolean isArray() {
        return false;
    }

    public String toString() {
        return JSNode.toJson(this, true, false);
    }

    public String toString(boolean pretty) {
        return JSNode.toJson(this, pretty, false);
    }

    public String toString(boolean pretty, boolean lowercasePropertyNames) {
        return JSNode.toJson(this, pretty, lowercasePropertyNames);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (JSProperty prop : this.properties.values()) {
            if (!value.equals(prop.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public Collection values() {
        return this.asMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Map<? extends String, ? extends Object> map = this.asMap();
        return map.entrySet();
    }

    public List asList() {
        ArrayList<JSNode> list = new ArrayList<JSNode>();
        list.add(this);
        return list;
    }

    public List<JSNode> asNodeList() {
        List list = this.asList();
        return list;
    }

    public JSArray asArray() {
        return new JSArray(new Object[]{this});
    }

    public Stream stream() {
        return this.asList().stream();
    }

    public Stream streamAll() {
        List all = this.findAll("**.*").asList();
        all.add(this);
        return all.stream();
    }

    static class JSONPathTokenizer {
        final char escapeChar = (char)92;
        final Set openQuotes;
        final Set closeQuotes;
        final Set breakIncluded;
        final Set breakExcluded;
        final Set unquotedIgnored;
        final Set leadingIgnored;
        char[] chars = null;
        int head = 0;
        boolean escaped = false;
        boolean quoted = false;
        StringBuilder next = new StringBuilder();

        public JSONPathTokenizer(String openQuoteChars, String closeQuoteChars, String breakIncludedChars, String breakExcludedChars, String unquotedIgnoredChars, String leadingIgnoredChars) {
            this(openQuoteChars, closeQuoteChars, breakIncludedChars, breakExcludedChars, unquotedIgnoredChars, leadingIgnoredChars, null);
        }

        public JSONPathTokenizer(String openQuoteChars, String closeQuoteChars, String breakIncludedChars, String breakExcludedChars, String unquotedIgnoredChars, String leadingIgnoredChars, String chars) {
            this.openQuotes = this.toSet(openQuoteChars);
            this.closeQuotes = this.toSet(closeQuoteChars);
            this.breakIncluded = this.toSet(breakIncludedChars);
            this.breakExcluded = this.toSet(breakExcludedChars);
            this.unquotedIgnored = this.toSet(unquotedIgnoredChars);
            this.leadingIgnored = this.toSet(leadingIgnoredChars);
            this.withChars(chars);
        }

        public JSONPathTokenizer withChars(String chars) {
            if (chars != null) {
                this.chars = chars.toCharArray();
            }
            this.head = 0;
            this.next = new StringBuilder();
            this.escaped = false;
            this.quoted = false;
            return this;
        }

        public List<String> asList() {
            String next;
            ArrayList<String> list = new ArrayList<String>();
            while ((next = this.next()) != null) {
                list.add(next);
            }
            return list;
        }

        Set toSet(String string) {
            HashSet<Character> resultSet = new HashSet<Character>();
            for (int i = 0; i < string.length(); ++i) {
                resultSet.add(Character.valueOf(string.charAt(i)));
            }
            return resultSet;
        }

        public String next() {
            if (this.head >= this.chars.length) {
                return null;
            }
            while (this.head < this.chars.length) {
                char c = this.chars[this.head];
                ++this.head;
                if (this.next.length() == 0 && this.leadingIgnored.contains(Character.valueOf(c))) continue;
                if (c == '\\') {
                    if (this.escaped) {
                        this.append(c);
                    }
                    this.escaped = !this.escaped;
                    continue;
                }
                if (!this.quoted && this.unquotedIgnored.contains(Character.valueOf(c))) continue;
                if (!this.quoted && !this.escaped && this.openQuotes.contains(Character.valueOf(c))) {
                    this.quoted = true;
                } else if (this.quoted && !this.escaped && this.closeQuotes.contains(Character.valueOf(c))) {
                    this.quoted = false;
                }
                if (!this.quoted && this.breakExcluded.contains(Character.valueOf(c)) && this.next.length() > 0) {
                    --this.head;
                    break;
                }
                if (!this.quoted && this.breakIncluded.contains(Character.valueOf(c))) {
                    this.append(c);
                    break;
                }
                this.append(c);
            }
            if (this.quoted) {
                throw new RuntimeException("Unable to parse unterminated quoted string: \"" + String.valueOf(this.chars) + "\": -> '" + new String(this.chars) + "'");
            }
            if (this.escaped) {
                throw new RuntimeException("Unable to parse hanging escape character: \"" + String.valueOf(this.chars) + "\": -> '" + new String(this.chars) + "'");
            }
            String str = this.next.toString().trim();
            this.next = new StringBuilder();
            if (str.length() == 0) {
                str = null;
            }
            return str;
        }

        void append(char c) {
            this.next.append(c);
        }
    }

    static class JSProperty {
        String name;
        Object value;

        public JSProperty(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name + " = " + this.value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

