/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import io.inversion.ApiException;
import io.inversion.utils.Utils;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.EnvironmentConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;

public class Config {
    static CompositeConfiguration configuration = null;

    private Config() {
    }

    public static synchronized boolean hasConfiguration() {
        return configuration != null;
    }

    public static synchronized CompositeConfiguration getConfiguration() {
        if (configuration == null) {
            Config.loadConfiguration(null, null);
        }
        return configuration;
    }

    public static synchronized void setConfiguration(CompositeConfiguration configuration) {
        Config.configuration = configuration;
    }

    public static synchronized void clearConfiguration() {
        configuration = null;
    }

    public static synchronized void loadConfiguration(String configPath, String configProfile) {
        configPath = !Utils.empty(configPath) ? configPath : Utils.findSysEnvProp("inversion.configPath", "configPath");
        configProfile = !Utils.empty(configProfile) ? configProfile : Utils.findSysEnvProp("inversion.configProfile", "inversion.profile", "spring.profiles.active", "configProfile", "profile");
        Configurations configs = new Configurations();
        CompositeConfiguration configuration = new CompositeConfiguration();
        System.out.println("LOADING CONFIGURATION...");
        System.out.println("  - configPath    : " + configPath);
        System.out.println("  - configProfile : " + configProfile);
        try {
            String fileName;
            int i;
            URL url = Config.findUrl(".env");
            if (url != null) {
                System.out.println("  - loading file  : " + url);
                configuration.addConfiguration((Configuration)configs.properties(url));
            }
            configuration.addConfiguration((Configuration)new SystemConfiguration());
            configuration.addConfiguration((Configuration)new EnvironmentConfiguration());
            String string = configPath = configPath != null ? configPath : "";
            if (configPath.length() > 0 && !configPath.endsWith("/") && !configPath.endsWith("\\")) {
                configPath = configPath + "/";
            }
            if (configProfile != null) {
                for (i = 100; i >= -1; --i) {
                    fileName = configPath + "inversion" + (i < 0 ? "" : Integer.valueOf(i)) + "-" + configProfile + ".properties";
                    url = Config.findUrl(fileName);
                    if (url == null) {
                        fileName = configPath + "inversion-" + (i < 0 ? "" : Integer.valueOf(i)) + "-" + configProfile + ".properties";
                        url = Config.findUrl(fileName);
                    }
                    if (url == null) {
                        fileName = configPath + "inversion-" + configProfile + (i < 0 ? "" : Integer.valueOf(i)) + ".properties";
                        url = Config.findUrl(fileName);
                    }
                    if (url == null) {
                        fileName = configPath + "inversion-" + configProfile + "-" + (i < 0 ? "" : Integer.valueOf(i)) + ".properties";
                        url = Config.findUrl(fileName);
                    }
                    if (url == null) continue;
                    System.out.println("  - loading file  : " + url);
                    configuration.addConfiguration((Configuration)configs.properties(url));
                }
            }
            for (i = 100; i >= -1; --i) {
                fileName = configPath + "inversion" + (i < 0 ? "" : Integer.valueOf(i)) + ".properties";
                url = Config.findUrl(fileName);
                if (url == null) {
                    fileName = configPath + "inversion-" + (i < 0 ? "" : Integer.valueOf(i)) + ".properties";
                    url = Config.findUrl(fileName);
                }
                if (url == null) continue;
                System.out.println("  - loading file  : " + url);
                PropertiesConfiguration fileConfig = configs.properties(url);
                if (!fileConfig.containsKey("source")) {
                    fileConfig.setProperty("source", (Object)url.toString());
                }
                configuration.addConfiguration((Configuration)fileConfig);
            }
        }
        catch (Exception ex) {
            throw ApiException.new500InternalServerError(ex);
        }
        Config.configuration = configuration;
    }

    protected static URL findUrl(String name) {
        try {
            File file;
            URL url = Config.class.getClassLoader().getResource(name);
            if (url == null && (file = new File(System.getProperty("user.dir"), name)).exists()) {
                url = file.toURI().toURL();
            }
            return url;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Iterator<String> getKeys() {
        Config.getConfiguration();
        return configuration.getKeys();
    }

    public static Object getProperty(String key) {
        Config.getConfiguration();
        return configuration.getProperty(key);
    }

    public static boolean getBoolean(String key) {
        Config.getConfiguration();
        return configuration.getBoolean(key);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        Config.getConfiguration();
        return configuration.getBoolean(key, defaultValue);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        Config.getConfiguration();
        return configuration.getBoolean(key, defaultValue);
    }

    public static byte getByte(String key) {
        Config.getConfiguration();
        return configuration.getByte(key);
    }

    public static byte getByte(String key, byte defaultValue) {
        Config.getConfiguration();
        return configuration.getByte(key, defaultValue);
    }

    public static Byte getByte(String key, Byte defaultValue) {
        Config.getConfiguration();
        return configuration.getByte(key, defaultValue);
    }

    public static double getDouble(String key) {
        Config.getConfiguration();
        return configuration.getDouble(key);
    }

    public static double getDouble(String key, double defaultValue) {
        Config.getConfiguration();
        return configuration.getDouble(key, defaultValue);
    }

    public static Double getDouble(String key, Double defaultValue) {
        Config.getConfiguration();
        return configuration.getDouble(key, defaultValue);
    }

    public static float getFloat(String key) {
        Config.getConfiguration();
        return configuration.getFloat(key);
    }

    public static float getFloat(String key, float defaultValue) {
        Config.getConfiguration();
        return configuration.getFloat(key, defaultValue);
    }

    public static Float getFloat(String key, Float defaultValue) {
        Config.getConfiguration();
        return configuration.getFloat(key, defaultValue);
    }

    public static int getInt(String key) {
        Config.getConfiguration();
        return configuration.getInt(key);
    }

    public static int getInt(String key, int defaultValue) {
        Config.getConfiguration();
        return configuration.getInt(key, defaultValue);
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        Config.getConfiguration();
        return configuration.getInteger(key, defaultValue);
    }

    public static long getLong(String key) {
        Config.getConfiguration();
        return configuration.getLong(key);
    }

    public static long getLong(String key, long defaultValue) {
        Config.getConfiguration();
        return configuration.getLong(key, defaultValue);
    }

    public static Long getLong(String key, Long defaultValue) {
        Config.getConfiguration();
        return configuration.getLong(key, defaultValue);
    }

    public static short getShort(String key) {
        Config.getConfiguration();
        return configuration.getShort(key);
    }

    public static short getShort(String key, short defaultValue) {
        Config.getConfiguration();
        return configuration.getShort(key, defaultValue);
    }

    public static Short getShort(String key, Short defaultValue) {
        Config.getConfiguration();
        return configuration.getShort(key, defaultValue);
    }

    public static BigDecimal getBigDecimal(String key) {
        Config.getConfiguration();
        return configuration.getBigDecimal(key);
    }

    public static BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        Config.getConfiguration();
        return configuration.getBigDecimal(key, defaultValue);
    }

    public static BigInteger getBigInteger(String key) {
        Config.getConfiguration();
        return configuration.getBigInteger(key);
    }

    public static BigInteger getBigInteger(String key, BigInteger defaultValue) {
        Config.getConfiguration();
        return configuration.getBigInteger(key, defaultValue);
    }

    public static String getString(String key) {
        Config.getConfiguration();
        return configuration.getString(key);
    }

    public static String getString(String key, String defaultValue) {
        Config.getConfiguration();
        return configuration.getString(key, defaultValue);
    }
}

