/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.rql;

import io.inversion.Collection;
import io.inversion.Index;
import io.inversion.rql.Builder;
import io.inversion.rql.Query;
import io.inversion.rql.Term;
import java.util.ArrayList;
import java.util.List;

public class Select<T extends Select, P extends Query>
extends Builder<T, P> {
    public Select(P query) {
        super(query);
        this.withFunctions("as", "includes", "excludes", "distinct", "count", "sum", "min", "max", "if", "aggregate", "function", "countascol", "rowcount");
    }

    public boolean isDistinct() {
        Term distinct = this.find("distinct");
        return distinct != null;
    }

    @Override
    protected boolean addTerm(String token, Term term) {
        Collection coll;
        if (term.hasToken("function", "aggregate")) {
            String func = term.getTerm(0).getToken();
            String col = term.getTerm(1).getToken();
            ((Query)this.getParent()).withTerm("group", col);
            Term t = Term.term(null, func, col);
            if (term.size() > 2) {
                Term as = Term.term(null, "as", t, term.getTerm(2).getToken());
                ((Query)this.getParent()).withTerm(as);
            } else {
                ((Query)this.getParent()).withTerm(t);
            }
            return true;
        }
        if (term.hasToken("countascol")) {
            String col = term.getToken(0);
            List<Term> terms = term.getTerms();
            for (int i = 1; i < terms.size(); ++i) {
                ((Query)this.getParent()).withTerm("as(sum(if(eq(" + col + ", " + terms.get(i) + "), 1, 0))," + terms.get(i) + ")");
            }
            StringBuilder str = new StringBuilder("in(" + col);
            for (int i = 1; i < terms.size(); ++i) {
                str.append(",").append(terms.get((int)i).token);
            }
            str.append(")");
            ((Query)this.getParent()).withTerm(str.toString());
            return true;
        }
        if (term.hasToken("includes") && (coll = ((Query)this.getParent()).getCollection()) != null) {
            Index idx = coll.getPrimaryIndex();
            for (String idxCol : idx.getColumnNames()) {
                if (term.hasChildLeafToken(idxCol)) continue;
                term.withTerm(Term.term(term, idxCol, new Object[0]));
            }
        }
        if (this.functions.contains(token.toLowerCase()) && !term.hasToken("as", "includes", "excludes", "distinct")) {
            String asName = "$$$ANON";
            if (term.size() > 1 && term.hasToken("count", "sum", "min", "max")) {
                Term asT = term.getTerm(1);
                term.removeTerm(asT);
                asName = asT.getToken();
            }
            Term as = Term.term(null, "as", term, asName);
            this.withTerm(as);
            return true;
        }
        return super.addTerm(token, term);
    }

    public List<String> getColumnNames() {
        ArrayList<String> columns = new ArrayList<String>();
        for (Term include : this.findAll("includes")) {
            for (Term child : include.getTerms()) {
                columns.add(child.getToken());
            }
        }
        return columns;
    }

    public List<Term> columns() {
        ArrayList<Term> columns = new ArrayList<Term>();
        for (Term include : this.findAll("includes")) {
            columns.addAll(include.getTerms());
        }
        boolean hasIncludes = columns.size() > 0;
        for (Term as : this.findAll("as")) {
            if (!hasIncludes) {
                columns.add(as);
                continue;
            }
            String name = as.getToken(1);
            boolean replaced = false;
            for (int i = 0; i < columns.size(); ++i) {
                Term column = (Term)columns.get(i);
                if (!column.isLeaf() || !column.hasToken(name)) continue;
                columns.set(i, as);
                replaced = true;
                break;
            }
            if (replaced) continue;
            columns.add(as);
        }
        return columns;
    }
}

