/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.rql;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class RqlTokenizer {
    final char[] chars;
    int head = 0;
    boolean escaped = false;
    char quote = '\u0000';
    int function = 0;
    StringBuilder next = new StringBuilder();

    public RqlTokenizer(String chars) {
        this.chars = chars.toCharArray();
    }

    public Stream<String> stream() {
        return this.asList().stream();
    }

    public List<String> asList() {
        String next;
        ArrayList<String> list = new ArrayList<String>();
        while ((next = this.next()) != null) {
            list.add(next);
        }
        return list;
    }

    public String next() {
        if (this.head >= this.chars.length) {
            return null;
        }
        while (this.head < this.chars.length) {
            char c = this.chars[this.head];
            ++this.head;
            if ((c == ' ' || c == '\t') && this.next.length() == 0) continue;
            if (this.isEscaped()) {
                this.append(c);
                this.escaped = false;
                continue;
            }
            if (c == '\\') {
                this.escaped = !this.escaped;
                continue;
            }
            if (c == '\"' || c == '\'') {
                this.append(c);
                if (c == this.quote) {
                    this.quote = '\u0000';
                    break;
                }
                if (this.next.length() != 1) continue;
                this.quote = c;
                continue;
            }
            if (!this.inQuotes() && c == ',') {
                if (this.next.length() <= 0) continue;
                break;
            }
            if (!this.inQuotes() && c == '(') {
                this.append(c);
                ++this.function;
                break;
            }
            if (!this.inQuotes() && (!this.inFunction() && c == '=' || this.inFunction() && c == ')')) {
                if (this.next.length() == 0) {
                    this.append(c);
                    if (c != ')') break;
                    --this.function;
                    break;
                }
                --this.head;
                break;
            }
            if (!this.inQuotes() && c == ')' && !this.inFunction()) {
                this.error("Found ')' as the start of a token but no starting '(' was ever parsed: -> '" + new String(this.chars) + "'");
            }
            this.append(c);
        }
        if (this.inQuotes()) {
            this.error("Unable to parse unterminated quoted string: \"" + String.valueOf(this.chars) + "\": -> '" + new String(this.chars) + "'");
        }
        if (this.isEscaped()) {
            this.error("Unable to parse hanging escape character: \"" + String.valueOf(this.chars) + "\": -> '" + new String(this.chars) + "'");
        }
        if (this.inFunction() && this.head == this.chars.length) {
            this.error("Looks like you are missing a closing ')'");
        }
        String str = this.next.toString().trim();
        this.next = new StringBuilder();
        return str;
    }

    protected void error(String msg) {
        throw new RuntimeException(msg);
    }

    protected boolean inQuotes() {
        return this.quote != '\u0000';
    }

    protected boolean isEscaped() {
        return this.escaped;
    }

    protected boolean inFunction() {
        return this.function > 0;
    }

    protected void append(char c) {
        if (!this.inQuotes() && this.next.length() == 0 && c == ' ') {
            return;
        }
        this.next.append(c);
    }
}

