/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.security;

import io.inversion.Chain;
import io.inversion.Request;
import io.inversion.Rule;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class AclRule
extends Rule<AclRule> {
    protected final List<String> permissions = new ArrayList<String>();
    protected final List<String> roles = new ArrayList<String>();
    protected boolean allow = true;
    protected boolean info = false;
    protected boolean allRolesMustMatch = false;
    protected boolean allPermissionsMustMatch = false;

    public AclRule() {
    }

    public AclRule(String name, String methods, String includePaths, String permission1, String ... permissionsN) {
        this.withName(name);
        this.withIncludeOn(methods, includePaths);
        if (permission1 != null) {
            this.withPermissions(permission1);
        }
        if (permissionsN != null) {
            this.withPermissions(permissionsN);
        }
    }

    public static AclRule allowAll(String methods, String includePaths) {
        AclRule rule = new AclRule(null, methods, includePaths, null, new String[0]);
        return rule;
    }

    public static AclRule requireAllPerms(String methods, String includePaths, String permission1, String ... permissionsN) {
        AclRule rule = new AclRule(null, null, includePaths, permission1, permissionsN);
        rule.withAllPermissionsMustMatch(true);
        return rule;
    }

    public static AclRule requireOnePerm(String methods, String includePaths, String permission1, String ... permissionsN) {
        AclRule rule = new AclRule(null, null, includePaths, permission1, permissionsN);
        rule.withAllPermissionsMustMatch(false);
        return rule;
    }

    public static AclRule requireAllRoles(String methods, String includePaths, String role1, String ... rolesN) {
        AclRule rule = new AclRule(null, null, includePaths, null, new String[0]);
        rule.withAllRolesMustMatch(true);
        rule.withRoles(role1);
        rule.withRoles(rolesN);
        return rule;
    }

    public static AclRule requireOneRole(String methods, String includePaths, String role1, String ... rolesN) {
        AclRule rule = new AclRule(null, null, includePaths, null, new String[0]);
        rule.withAllRolesMustMatch(false);
        rule.withRoles(role1);
        rule.withRoles(rolesN);
        return rule;
    }

    public boolean ruleMatches(Request req) {
        boolean matched;
        if (this.match(req.getMethod(), req.getPath()) == null) {
            return false;
        }
        if (Chain.getUser() == null && (this.roles.size() > 0 || this.permissions.size() > 0)) {
            return false;
        }
        int matches = 0;
        for (String requiredRole : this.roles) {
            matched = Chain.getUser().hasRoles(requiredRole);
            if (matched) {
                ++matches;
                if (this.allRolesMustMatch) continue;
                break;
            }
            if (!this.allRolesMustMatch) continue;
            break;
        }
        for (String requiredPerm : this.permissions) {
            matched = Chain.getUser().hasPermissions(requiredPerm);
            if (matched) {
                ++matches;
                if (this.allPermissionsMustMatch) continue;
                break;
            }
            if (!this.allPermissionsMustMatch) continue;
            break;
        }
        boolean hasRoles = this.roles.size() == 0 || this.allRolesMustMatch && matches == this.roles.size() || !this.allRolesMustMatch && matches > 0;
        boolean hasPermissions = this.permissions.size() == 0 || this.allPermissionsMustMatch && matches == this.permissions.size() || !this.allPermissionsMustMatch && matches > 0;
        return hasRoles || hasPermissions;
    }

    public ArrayList<String> getRoles() {
        return new ArrayList<String>(this.roles);
    }

    public AclRule withRoles(String ... roles) {
        if (roles != null) {
            for (String role : Utils.explode(",", roles)) {
                if (this.roles.contains(role)) continue;
                this.roles.add(role);
            }
        }
        return this;
    }

    public ArrayList<String> getPermissions() {
        return new ArrayList<String>(this.permissions);
    }

    public AclRule withPermissions(String ... permissions) {
        if (permissions != null) {
            for (String permission : Utils.explode(",", permissions)) {
                if (this.permissions.contains(permission)) continue;
                this.permissions.add(permission);
            }
        }
        return this;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public AclRule withAllow(boolean allow) {
        this.allow = allow;
        return this;
    }

    public boolean isInfo() {
        return this.info;
    }

    public AclRule withInfo(boolean info) {
        this.info = info;
        return this;
    }

    public boolean isAllRolesMustMatch() {
        return this.allRolesMustMatch;
    }

    public AclRule withAllRolesMustMatch(boolean allRolesMustMatch) {
        this.allRolesMustMatch = allRolesMustMatch;
        return this;
    }

    public boolean isAllPermissionsMustMatch() {
        return this.allPermissionsMustMatch;
    }

    public AclRule withAllPermissionsMustMatch(boolean allPermissionsMustMatch) {
        this.allPermissionsMustMatch = allPermissionsMustMatch;
        return this;
    }
}

