/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.security;

import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.action.security.AclRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AclAction
extends Action<AclAction> {
    protected final List<AclRule> aclRules = new ArrayList<AclRule>();

    public AclAction orRequireAllPerms(String httpMethods, String includePaths, String permission1, String ... permissionsN) {
        this.withAclRules(AclRule.requireAllPerms(httpMethods, includePaths, permission1, permissionsN));
        return this;
    }

    public AclAction orRequireOnePerm(String httpMethods, String includePaths, String permission1, String ... permissionsN) {
        this.withAclRules(AclRule.requireOnePerm(httpMethods, includePaths, permission1, permissionsN));
        return this;
    }

    public AclAction orRequireAllRoles(String httpMethods, String includePaths, String role1, String ... rolesN) {
        this.withAclRules(AclRule.requireAllRoles(httpMethods, includePaths, role1, rolesN));
        return this;
    }

    public AclAction orRequireOneRole(String httpMethods, String includePaths, String role1, String ... rolesN) {
        this.withAclRules(AclRule.requireOneRole(httpMethods, includePaths, role1, rolesN));
        return this;
    }

    public AclAction withAclRules(AclRule ... acls) {
        for (AclRule acl : acls) {
            if (this.aclRules.contains(acl)) continue;
            this.aclRules.add(acl);
        }
        Collections.sort(this.aclRules);
        return this;
    }

    @Override
    public void run(Request req, Response resp) throws ApiException {
        this.log.debug("Request Path: " + req.getPath());
        boolean allowed = false;
        for (AclRule aclRule : this.aclRules) {
            if (!aclRule.ruleMatches(req)) continue;
            if (!aclRule.isAllow()) {
                Chain.debug("AclAction: MATCH_DENY" + aclRule);
                allowed = false;
                break;
            }
            if (!aclRule.isInfo() && aclRule.isAllow()) {
                Chain.debug("AclAction: MATCH_ALLOW " + aclRule);
                allowed = true;
                break;
            }
            Chain.debug("AclAction: MATCH_INFO " + aclRule);
        }
        if (!allowed) {
            Chain.debug("AclAction: NO_MATCH_DENY");
            throw ApiException.new403Forbidden();
        }
    }
}

