/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.db;

import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Engine;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.utils.JSNode;
import io.inversion.utils.Rows;
import io.inversion.utils.Utils;
import java.util.HashSet;

public class DbDeleteAction
extends Action<DbDeleteAction> {
    @Override
    public void run(Request req, Response res) throws ApiException {
        String resourceKey = req.getResourceKey();
        String relationshipKey = req.getRelationshipKey();
        if (Utils.empty(resourceKey)) {
            throw ApiException.new400BadRequest("An resource key must be included in the url path for a DELETE request.", new Object[0]);
        }
        if (!Utils.empty(relationshipKey)) {
            throw ApiException.new400BadRequest("A relationship key in the url path is not valid for a DELETE request", new Object[0]);
        }
        if (req.getJson() != null) {
            throw ApiException.new501NotImplemented("A JSON body can not be included with a DELETE.  Batch delete is not supported.", new Object[0]);
        }
        int deleted = this.delete(req.getEngine(), req.getCollection(), req.getUrl().toString());
        if (deleted < 1) {
            res.withStatus("404 Not Found");
        } else {
            res.withStatus("204 No Content");
        }
    }

    protected int delete(Engine engine, Collection collection, String url) throws ApiException {
        Response res;
        int deleted = 0;
        HashSet<String> alreadyDeleted = new HashSet<String>();
        for (int i = 0; i < 1000 && (res = engine.get(url).assertStatus(200, 404)).getData().size() != 0; ++i) {
            Rows rows = new Rows();
            for (JSNode node : res.getData().asNodeList()) {
                String href = node.getString("href");
                if (alreadyDeleted.contains(href)) {
                    throw ApiException.new500InternalServerError("Deletion of '{}' was not successful.", href);
                }
                alreadyDeleted.add(href);
                Rows.Row key = collection.decodeResourceKey((String)Utils.last(Utils.explode("/", href)));
                rows.add(key);
            }
            collection.getDb().delete(collection, rows);
            deleted += res.getData().size();
        }
        return deleted;
    }
}

