/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Chain;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class User {
    protected final Set<String> groups = new HashSet<String>();
    protected final Set<String> roles = new HashSet<String>();
    protected final Set<String> permissions = new HashSet<String>();
    protected int id = 0;
    protected String tenant = null;
    protected String username = null;
    protected String password = null;
    protected String displayName = null;
    protected String accessKey = null;
    protected String secretKey = null;
    protected long requestAt = -1L;
    protected String remoteAddr = null;
    protected int failedNum = 0;

    public User() {
    }

    public User(String username, String roles, String permissions) {
        this.withUsername(username);
        this.withRoles(roles);
        this.withPermissions(permissions);
    }

    @Deprecated
    public String getTenantCode() {
        if (Chain.peek() != null) {
            return Chain.peek().getRequest().getUrl().getParam("tenant");
        }
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public User withUsername(String username) {
        this.username = username;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public User withId(int id) {
        this.id = id;
        return this;
    }

    public long getRequestAt() {
        return this.requestAt;
    }

    public User withRequestAt(long requestAt) {
        this.requestAt = requestAt;
        return this;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public User withRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
        return this;
    }

    public int getFailedNum() {
        return this.failedNum;
    }

    public User withFailedNum(int failedNum) {
        this.failedNum = failedNum;
        return this;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public User withAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public User withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public User withPassword(String password) {
        this.password = password;
        return this;
    }

    public List<String> getPermissions() {
        return new ArrayList<String>(this.permissions);
    }

    public boolean hasPermissions(String ... permissions) {
        if (permissions == null) {
            return true;
        }
        for (String permission : Utils.explode(",", permissions)) {
            if (this.permissions.contains(permission)) continue;
            return false;
        }
        return true;
    }

    public User withPermissions(String ... permissions) {
        if (permissions != null) {
            this.permissions.addAll(Utils.explode(",", permissions));
        }
        return this;
    }

    public boolean hasGroups(String ... groups) {
        if (groups == null) {
            return true;
        }
        for (String group : groups) {
            if (this.groups.contains(group)) continue;
            return false;
        }
        return true;
    }

    public List<String> getGroups() {
        return new ArrayList<String>(this.groups);
    }

    public User withGroups(String ... groups) {
        if (groups != null) {
            this.groups.addAll(Utils.explode(",", groups));
        }
        return this;
    }

    public Set<String> getRoles() {
        return new HashSet<String>(this.roles);
    }

    public boolean hasRoles(String ... roles) {
        if (roles == null) {
            return true;
        }
        for (String role : roles) {
            if (this.roles.contains(role)) continue;
            return false;
        }
        return true;
    }

    public User withRoles(String ... roles) {
        if (roles != null) {
            Collections.addAll(this.roles, roles);
        }
        return this;
    }

    public String getTenant() {
        return this.tenant;
    }

    public User withTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public User withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }
}

