/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.utils.JSNode;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Rule<R extends Rule>
implements Comparable<R> {
    protected final transient Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    protected final List<RuleMatcher> includeMatchers = new ArrayList<RuleMatcher>();
    protected final List<RuleMatcher> excludeMatchers = new ArrayList<RuleMatcher>();
    protected final transient JSNode configMap = new JSNode();
    protected String name = null;
    protected int order = 1000;
    protected String configStr = null;
    protected String includeOn = null;
    protected String excludeOn = null;
    transient boolean lazyConfiged = false;

    static List<Path> asPathsList(String ... paths) {
        ArrayList<Path> pathsList = new ArrayList<Path>();
        for (String path : Utils.explode(",", paths)) {
            pathsList.add(new Path(path));
        }
        return pathsList;
    }

    static Path[] asPathsArray(String ... paths) {
        List<Path> list = Rule.asPathsList(paths);
        return list.toArray(new Path[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLazyConfig() {
        if (!this.lazyConfiged) {
            Rule rule = this;
            synchronized (rule) {
                if (!this.lazyConfiged) {
                    this.lazyConfiged = true;
                    this.doLazyConfig();
                }
            }
        }
    }

    protected void doLazyConfig() {
        if (this.includeOn != null) {
            this.withIncludeOn(this.includeOn);
        }
        if (this.excludeOn != null) {
            this.withExcludeOn(this.excludeOn);
        }
        if (this.getAllIncludePaths().size() == 0 && this.getAllExcludePaths().size() == 0) {
            this.withIncludeOn(this.getDefaultIncludeMatch());
        }
    }

    protected RuleMatcher getDefaultIncludeMatch() {
        return new RuleMatcher(null, "*");
    }

    public boolean matches(String method, String path) {
        return this.matches(method, new Path(path));
    }

    public boolean matches(String method, Path path) {
        return this.match(method, path) != null;
    }

    protected Path match(String method, Path path) {
        this.checkLazyConfig();
        for (RuleMatcher excluder : this.excludeMatchers) {
            if (excluder.methods.size() > 0 && !excluder.methods.contains(method)) continue;
            for (Path excludePath : excluder.paths) {
                if (!excludePath.matches(path)) continue;
                return null;
            }
        }
        int includePathCount = 0;
        for (RuleMatcher includer : this.includeMatchers) {
            includePathCount += includer.paths.size();
            if (includer.methods.size() > 0 && !includer.methods.contains(method)) continue;
            for (Path includePath : includer.paths) {
                if (!includePath.matches(path)) continue;
                return includePath;
            }
        }
        if (includePathCount == 0) {
            return new Path("*");
        }
        return null;
    }

    public List<Path> getAllIncludePaths() {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        for (RuleMatcher includer : this.includeMatchers) {
            paths.addAll(includer.paths);
        }
        return new ArrayList<Path>(paths);
    }

    public List<Path> getAllExcludePaths() {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        for (RuleMatcher excluder : this.excludeMatchers) {
            paths.addAll(excluder.paths);
        }
        return new ArrayList<Path>(paths);
    }

    public List<RuleMatcher> getIncludeMatchers() {
        return new ArrayList<RuleMatcher>(this.includeMatchers);
    }

    public R withIncludeOn(RuleMatcher matcher) {
        this.includeMatchers.add(matcher);
        return (R)this;
    }

    public R withIncludeOn(String methods, String paths) {
        this.withIncludeOn(new RuleMatcher(methods, paths));
        return (R)this;
    }

    public R withIncludeOn(String methodsAndOrPaths) {
        Rule.parseRuleMatcher(methodsAndOrPaths).forEach(matcher -> this.withIncludeOn((RuleMatcher)matcher));
        return (R)this;
    }

    public R withExcludeOn(String methods, String paths) {
        this.withExcludeOn(new RuleMatcher(methods, paths));
        return (R)this;
    }

    public R withExcludeOn(RuleMatcher matcher) {
        this.excludeMatchers.add(matcher);
        return (R)this;
    }

    public R withExcludeOn(String methodsAndOrPaths) {
        Rule.parseRuleMatcher(methodsAndOrPaths).forEach(matcher -> this.withExcludeOn((RuleMatcher)matcher));
        return (R)this;
    }

    public List<RuleMatcher> getExcludeMatchers() {
        return new ArrayList<RuleMatcher>(this.excludeMatchers);
    }

    public String getName() {
        return this.name;
    }

    public R withName(String name) {
        this.name = name;
        return (R)this;
    }

    public int getOrder() {
        return this.order;
    }

    public R withOrder(int order) {
        this.order = order;
        return (R)this;
    }

    public Set<String> getConfigKeys() {
        return new HashSet<String>(this.configMap.keySet());
    }

    public String getConfig(String key) {
        return (String)this.configMap.get(key);
    }

    public String getConfig(String key, String defaultValue) {
        String value = this.configMap.getString(key);
        if (Utils.empty(value)) {
            value = defaultValue;
        }
        return value;
    }

    public R withConfig(String queryString) {
        try {
            if (queryString != null) {
                this.configStr = this.configStr == null ? queryString : this.configStr + "&" + queryString;
                LinkedHashMap<String, String> parsed = Utils.parseQueryString(queryString);
                this.configMap.putAll((Map<? extends String, ? extends Object>)parsed);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (R)this;
    }

    @Override
    public int compareTo(Rule a) {
        int compare = Integer.compare(this.getOrder(), a.getOrder());
        return compare;
    }

    R clearIncludeRuleMatchers() {
        this.includeMatchers.clear();
        return (R)this;
    }

    R clearExcludeRuleMatchers() {
        this.excludeMatchers.clear();
        return (R)this;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(this.getClass().getSimpleName());
        if (this.name != null) {
            buff.append(":").append(this.name);
        }
        if (this.includeMatchers.size() > 0 || this.excludeMatchers.size() > 0) {
            buff.append(" -");
            if (this.includeMatchers.size() > 0) {
                buff.append(" includes: ").append(this.includeMatchers);
            }
            if (this.excludeMatchers.size() > 0) {
                buff.append(" exclude: ").append(this.excludeMatchers);
            }
        }
        return buff.toString();
    }

    static List<RuleMatcher> parseRuleMatcher(String methodsAndOrPaths) {
        ArrayList<RuleMatcher> matchers = new ArrayList<RuleMatcher>();
        String[] parts = methodsAndOrPaths.split("\\|");
        for (int i = 0; i < parts.length; ++i) {
            if (parts.length - i == 1) {
                ArrayList<String> methodsList = new ArrayList<String>();
                ArrayList<String> pathsList = new ArrayList<String>();
                for (String part : parts[i].split(",")) {
                    if (Utils.in((part = part.trim()).toLowerCase(), "get", "post", "put", "patch", "delete")) {
                        methodsList.add(part);
                        continue;
                    }
                    pathsList.add(part);
                }
                String methods = methodsList.size() == 0 ? "*" : Utils.implode(",", methodsList);
                String paths = pathsList.size() == 0 ? "*" : Utils.implode(",", pathsList);
                matchers.add(new RuleMatcher(methods, paths));
                continue;
            }
            matchers.add(new RuleMatcher(parts[i], parts[i + 1]));
            ++i;
        }
        return matchers;
    }

    public static class RuleMatcher {
        protected final Set<String> methods = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        protected final List<Path> paths = new ArrayList<Path>();

        public RuleMatcher(String methods, String ... paths) {
            this(methods, Rule.asPathsList(paths));
        }

        public RuleMatcher(String methods, Path path) {
            this.withMethods(methods);
            this.withPaths(path);
        }

        public RuleMatcher(String methods, List<Path> paths) {
            this.withMethods(methods);
            this.withPaths(paths);
        }

        public void withMethods(String ... methods) {
            for (String method : Utils.explode(",", methods)) {
                if ("*".equals(method)) {
                    this.methods.add("GET");
                    this.methods.add("POST");
                    this.methods.add("PUT");
                    this.methods.add("PATCH");
                    this.methods.add("DELETE");
                    continue;
                }
                if ("read".equalsIgnoreCase(method)) {
                    this.methods.add("GET");
                    continue;
                }
                if ("write".equalsIgnoreCase(method)) {
                    this.methods.add("POST");
                    this.methods.add("PUT");
                    this.methods.add("PATCH");
                    this.methods.add("DELETE");
                    continue;
                }
                this.methods.add(method.toUpperCase());
            }
        }

        public void withPaths(Path ... paths) {
            this.paths.addAll(Arrays.asList(paths));
        }

        public void withPaths(List<Path> paths) {
            this.paths.addAll(paths);
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            if (this.methods.size() == 0) {
                buff.append("*");
            } else {
                buff.append(this.methods);
            }
            buff.append(":");
            if (this.paths.size() == 0) {
                buff.append("*");
            } else {
                buff.append(this.paths);
            }
            return buff.toString();
        }
    }
}

