/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Collection;
import io.inversion.utils.Utils;
import java.io.Serializable;

public class Property
implements Serializable {
    protected String jsonName = null;
    protected String columnName = null;
    protected String type = "string";
    protected boolean nullable = false;
    protected String hint = null;
    protected boolean exclude = false;
    protected Property pk = null;
    protected Collection collection = null;

    public Property() {
    }

    public Property(String name) {
        this(name, "string", true);
    }

    public Property(String name, String type) {
        this(name, type, true);
    }

    public Property(String name, String type, boolean nullable) {
        this.withColumnName(name);
        this.withJsonName(name);
        this.withType(type);
        this.withNullable(nullable);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Property) {
            Property column = (Property)object;
            return (this.collection == null || this.collection == column.collection) && Utils.equal(this.columnName, column.columnName);
        }
        return false;
    }

    public String toString() {
        return this.hint == null ? this.getJsonName() : this.hint;
    }

    public Property getPk() {
        return this.pk;
    }

    public Property withPk(Property primaryKey) {
        this.pk = primaryKey;
        return this;
    }

    public boolean isFk() {
        return this.pk != null;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Property withColumnName(String name) {
        this.columnName = name;
        return this;
    }

    public String getJsonName() {
        return this.jsonName;
    }

    public Property withJsonName(String name) {
        this.jsonName = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Property withType(String type) {
        if (!Utils.empty(type) && !"null".equalsIgnoreCase(type)) {
            this.type = type;
        }
        return this;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Property withCollection(Collection collection) {
        if (this.collection != collection) {
            this.collection = collection;
            collection.withProperties(this);
        }
        return this;
    }

    public String getHint() {
        return this.hint;
    }

    public Property withHint(String hint) {
        this.hint = hint;
        return this;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Property withNullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public Property withExclude(boolean exclude) {
        this.exclude = exclude;
        return this;
    }
}

