/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Collection;
import io.inversion.Property;
import io.inversion.utils.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Index
implements Serializable {
    protected final List<Property> properties = new ArrayList<Property>();
    protected Collection collection = null;
    protected String name = null;
    protected String type = null;
    protected boolean unique = true;

    public Index() {
    }

    public Index(String name, String type, boolean unique, Property ... properties) {
        this.withName(name);
        this.withType(type);
        this.withUnique(unique);
        this.withProperties(properties);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Index) {
            Index index = (Index)object;
            return (this.collection == null || this.collection == index.collection) && Utils.equal(this.name, index.name);
        }
        return false;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(this.getCollection().getTableName()).append(".").append(this.name).append("(");
        for (int i = 0; i < this.size(); ++i) {
            buff.append(this.getPropertyName(i));
            if (i >= this.size() - 1) continue;
            buff.append(", ");
        }
        buff.append(")");
        return buff.toString();
    }

    public boolean isExclude() {
        if (this.collection.isExclude()) {
            return true;
        }
        for (Property property : this.properties) {
            if (!property.isExclude()) continue;
            return true;
        }
        return false;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Index withCollection(Collection coll) {
        if (this.collection != coll) {
            this.collection = coll;
            coll.withIndexes(this);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Index withName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Index withType(String type) {
        this.type = type;
        return this;
    }

    public boolean isType(String ... types) {
        for (String type : types) {
            if (!type.equalsIgnoreCase(this.type)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public Index withUnique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public Index withProperties(Property ... properties) {
        for (int i = 0; properties != null && i < properties.length; ++i) {
            if (properties[i] == null || this.properties.contains(properties[i])) continue;
            this.properties.add(properties[i]);
        }
        return this;
    }

    public List<Property> getProperties() {
        return new ArrayList<Property>(this.properties);
    }

    public Property getProperty(int idx) {
        return this.properties.get(idx);
    }

    public int size() {
        return this.properties.size();
    }

    public String getPropertyName(int index) {
        return index < this.properties.size() ? this.properties.get(index).getJsonName() : null;
    }

    public String getColumnName(int index) {
        return index < this.properties.size() ? this.properties.get(index).getColumnName() : null;
    }

    public List<String> getJsonNames() {
        return this.properties.stream().map(Property::getJsonName).collect(Collectors.toList());
    }

    public List<String> getColumnNames() {
        return this.properties.stream().map(Property::getColumnName).collect(Collectors.toList());
    }
}

