/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.ApiException;
import io.inversion.Engine;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

public class EngineServlet
extends HttpServlet {
    Engine engine = null;

    public static String readBody(HttpServletRequest request) throws ApiException {
        if (request == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            Object inputStream = request.getInputStream();
            if (inputStream != null) {
                int bytesRead;
                if ("gzip".equalsIgnoreCase(request.getHeader("Content-Encoding"))) {
                    inputStream = new GZIPInputStream((InputStream)inputStream, 1024);
                }
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            }
        }
        catch (Exception ex) {
            throw ApiException.new400BadRequest(ex, "Unable to read request body", new Object[0]);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString();
    }

    public void destroy() {
        this.engine.shutdown();
    }

    public void init(ServletConfig config) {
        this.engine.startup();
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void service(HttpServletRequest httpReq, HttpServletResponse httpResp) throws ServletException, IOException {
        EngineServletLocal.set(httpReq, httpResp);
        try {
            String method = httpReq.getMethod();
            String urlstr = httpReq.getRequestURL().toString();
            if (!urlstr.endsWith("/")) {
                urlstr = urlstr + "/";
            }
            String query = httpReq.getQueryString();
            if (!Utils.empty(query)) {
                urlstr = urlstr + "?" + query;
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            Enumeration headerEnum = httpReq.getHeaderNames();
            while (headerEnum.hasMoreElements()) {
                String key = (String)headerEnum.nextElement();
                String val = httpReq.getHeader(key);
                headers.put(key, val);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration paramsEnumer = httpReq.getParameterNames();
            while (paramsEnumer.hasMoreElements()) {
                String key = (String)paramsEnumer.nextElement();
                String val = httpReq.getParameter(key);
                params.put(key, val);
            }
            String body = EngineServlet.readBody(httpReq);
            Request req = new Request(method, urlstr, headers, params, body);
            req.withRemoteAddr(httpReq.getRemoteAddr());
            req.withUploader(() -> {
                try {
                    String fileName = null;
                    long fileSize = 0L;
                    String requestPath = null;
                    InputStream inputStream = null;
                    for (Part part : httpReq.getParts()) {
                        if (part.getName() == null) continue;
                        if (part.getName().equals("file")) {
                            inputStream = part.getInputStream();
                            fileName = part.getSubmittedFileName();
                            fileSize = part.getSize();
                            continue;
                        }
                        if (!part.getName().equals("requestPath") || !Utils.startsWith(requestPath = Utils.read(part.getInputStream()), "/")) continue;
                        requestPath = requestPath.substring(1);
                    }
                    ArrayList<Request.Upload> uploads = new ArrayList<Request.Upload>();
                    if (inputStream != null) {
                        uploads.add(new Request.Upload(fileName, fileSize, requestPath, inputStream));
                    }
                    return uploads;
                }
                catch (Exception ex) {
                    Utils.rethrow(ex);
                    return null;
                }
            });
            Response res = new Response();
            this.engine.service(req, res);
            this.writeResponse(req, res, httpResp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            httpResp.setStatus(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeResponse(Request req, Response res, HttpServletResponse http) throws Exception {
        String method = req != null ? req.getMethod() : null;
        http.setStatus(res.getStatusCode());
        ServletOutputStream out = http.getOutputStream();
        try {
            for (String key : res.getHeaders().keySet()) {
                List values = res.getHeaders().get((Object)key);
                StringBuilder buff = new StringBuilder();
                for (int i = 0; i < values.size(); ++i) {
                    buff.append(values.get(i));
                    if (i >= values.size() - 1) continue;
                    buff.append(",");
                }
                http.setHeader(key, buff.toString());
                res.debug(key + " " + buff, new Object[0]);
            }
            if ("OPTIONS".equals(method)) {
            } else {
                String contentType = res.getContentType();
                byte[] bytes = res.getOutput().getBytes();
                http.setContentType(contentType);
                http.setContentLength(bytes.length);
                res.debug("Content-Length " + bytes.length + "", new Object[0]);
                out.write(bytes);
            }
        }
        finally {
            out.flush();
            out.close();
        }
    }

    static class EngineServletLocal {
        static final ThreadLocal<HttpServletRequest> request = new ThreadLocal();
        static final ThreadLocal<HttpServletResponse> response = new ThreadLocal();

        EngineServletLocal() {
        }

        public static void set(HttpServletRequest req, HttpServletResponse res) {
            request.set(req);
            response.set(res);
        }

        public static HttpServletRequest getRequest() {
            return request.get();
        }

        public static void setRequest(HttpServletRequest req) {
            request.set(req);
        }

        public static HttpServletResponse getResponse() {
            return response.get();
        }

        public static void setResponse(HttpServletResponse res) {
            response.set(res);
        }
    }
}

