/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import io.inversion.Action;
import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Endpoint;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Rule;
import io.inversion.rql.RqlParser;
import io.inversion.utils.Config;
import io.inversion.utils.Configurator;
import io.inversion.utils.JSArray;
import io.inversion.utils.JSNode;
import io.inversion.utils.Path;
import io.inversion.utils.Url;
import io.inversion.utils.Utils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.LoggerFactory;

public class Engine
extends Rule<Engine> {
    protected final transient List<EngineListener> listeners = new ArrayList<EngineListener>();
    protected volatile transient Response lastResponse = null;
    protected List<Api> apis = new Vector<Api>();
    protected String corsAllowHeaders = "accept,accept-encoding,accept-language,access-control-request-headers,access-control-request-method,authorization,connection,content-type,host,user-agent,x-auth-token";
    protected String configPath = null;
    protected String configProfile = null;
    volatile transient boolean started = false;
    volatile transient boolean starting = false;

    public Engine() {
    }

    public Engine(Api ... apis) {
        if (apis != null) {
            for (Api api : apis) {
                this.withApi(api);
            }
        }
    }

    protected void startup0() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Engine startup() {
        if (this.started || this.starting) {
            return this;
        }
        System.out.println("STARTING ENGINE...");
        this.starting = true;
        try {
            this.startup0();
            if (!Config.hasConfiguration()) {
                Config.loadConfiguration(this.getConfigPath(), this.getConfigProfile());
            }
            new Configurator().configure(this, (Configuration)Config.getConfiguration());
            this.started = true;
            boolean hasApi = false;
            for (Api api : this.apis) {
                hasApi = true;
                if (api.getEndpoints().size() == 0) {
                    throw ApiException.new500InternalServerError("CONFIGURATION ERROR: You have configured an Api without any Endpoints.", new Object[0]);
                }
                this.startupApi(api);
            }
            if (!hasApi) {
                throw ApiException.new500InternalServerError("CONFIGURATION ERROR: You don't have any Apis configured.", new Object[0]);
            }
            for (Api api : this.apis) {
                System.out.println("\r\n--------------------------------------------");
                System.out.println("API             " + api);
                for (Endpoint e : api.getEndpoints()) {
                    System.out.println("  - ENDPOINT:   " + e);
                }
                ArrayList<String> collectionDebugs = new ArrayList<String>();
                for (Collection c : api.getCollections()) {
                    if (c.getDb() != null && c.getDb().getEndpointPath() != null) {
                        collectionDebugs.add(c.getDb().getEndpointPath() + c.getName());
                        continue;
                    }
                    collectionDebugs.add(c.getName());
                }
                Collections.sort(collectionDebugs);
                for (String coll : collectionDebugs) {
                    System.out.println("  - COLLECTION: " + coll);
                }
            }
            Engine engine = this;
            return engine;
        }
        finally {
            this.starting = false;
        }
    }

    public void shutdown() {
        for (Api api : this.getApis()) {
            this.removeApi(api);
        }
        for (EngineListener listener : this.listeners) {
            try {
                listener.onShutdown(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Chain.resetAll();
    }

    public Response get(String url) {
        return this.service("GET", url, null);
    }

    public Response get(String url, Map<String, String> params) {
        return this.service("GET", url, null, params);
    }

    public Response get(String url, List queryTerms) {
        if (queryTerms != null && queryTerms.size() > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            queryTerms.stream().filter(Objects::nonNull).forEach(key -> {
                String cfr_ignored_0 = params.put(key.toString(), null);
            });
            return this.service("GET", url, null, params);
        }
        return this.service("GET", url, null, null);
    }

    public Response post(String url, JSNode body) {
        return this.service("POST", url, body.toString());
    }

    public Response put(String url, JSNode body) {
        return this.service("PUT", url, body.toString());
    }

    public Response patch(String url, JSNode body) {
        return this.service("PATCH", url, body.toString());
    }

    public Response delete(String url) {
        return this.service("DELETE", url, null);
    }

    public Response delete(String url, JSArray hrefs) {
        return this.service("DELETE", url, hrefs.toString());
    }

    public Response service(String method, String url) {
        return this.service(method, url, null);
    }

    public Response service(String method, String url, String body) {
        return this.service(method, url, body, null);
    }

    public Response service(String method, String url, String body, Map<String, String> params) {
        Request req = new Request(method, url, body);
        req.withEngine(this);
        if (params != null) {
            for (String key : params.keySet()) {
                req.getUrl().withParam(key, params.get(key));
            }
        }
        Response res = new Response();
        this.service(req, res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Chain service(Request req, Response res) {
        Chain chain = null;
        if (res.getRequest() == null) {
            res.withRequest(req);
        }
        try {
            void var16_45;
            if (!this.started) {
                this.startup();
            }
            chain = Chain.push(this, req, res);
            req.withEngine(this);
            req.withChain(chain);
            res.withChain(chain);
            String allowedHeaders = this.corsAllowHeaders;
            String corsRequestHeader = req.getHeader("Access-Control-Request-Header");
            if (corsRequestHeader != null) {
                for (String h : corsRequestHeader.split(",")) {
                    h = h.trim();
                    allowedHeaders = allowedHeaders.concat(h).concat(",");
                }
            }
            res.withHeader("Access-Control-Allow-Origin", "*");
            res.withHeader("Access-Control-Allow-Credentials", "true");
            res.withHeader("Access-Control-Allow-Methods", "GET, POST, PUT, PATCH, DELETE, OPTIONS");
            res.withHeader("Access-Control-Allow-Headers", allowedHeaders);
            if (req.isMethod("options")) {
                res.withStatus("200 OK");
                Chain chain2 = chain;
                return chain2;
            }
            Url url = req.getUrl();
            if (url.toString().contains("/favicon.ico")) {
                res.withStatus("404 Not Found");
                Chain ex = chain;
                return ex;
            }
            String xfp = req.getHeader("X-Forwarded-Proto");
            String xfh = req.getHeader("X-Forwarded-Host");
            if (xfp != null || xfh != null) {
                if (xfp != null) {
                    url.withProtocol(xfp);
                }
                if (xfh != null) {
                    url.withHost(xfh);
                }
            }
            if (Chain.getDepth() < 2) {
                Map<String, String> urlParams = req.getUrl().getParams();
                for (String key : urlParams.keySet()) {
                    List illegals;
                    if (key.indexOf("_") <= 0 || (illegals = RqlParser.parse(key, urlParams.get(key)).stream().filter(t -> !t.isLeaf() && t.getToken().startsWith("_")).collect(Collectors.toList())).size() <= 0) continue;
                    req.getUrl().clearParams(key);
                }
            }
            String method = req.getMethod();
            Path parts = new Path(url.getPath());
            HashMap<String, String> pathParams = new HashMap<String, String>();
            Path containerPath = this.match(method, parts);
            if (containerPath == null) {
                throw ApiException.new400BadRequest("Somehow a request was routed to your Engine with an unsupported containerPath. This is a configuration error.", new Object[0]);
            }
            if (containerPath != null) {
                containerPath.extract(pathParams, parts);
            }
            Path afterApiPath = null;
            Path afterEndpointPath = null;
            block33: for (Api api : this.apis) {
                Path apiPath = api.match(method, parts);
                if (apiPath == null) continue;
                Path path = new Path(apiPath);
                apiPath = apiPath.extract(pathParams, parts);
                req.withApi(api, apiPath, path);
                afterApiPath = new Path(parts);
                for (Endpoint endpoint : api.getEndpoints()) {
                    Path endpointPath;
                    if (Chain.getDepth() < 2 && endpoint.isInternal() || (endpointPath = endpoint.match(req.getMethod(), parts)) == null) continue;
                    Path endpointMatchPath = new Path(endpointPath);
                    endpointPath = endpointPath.extract(pathParams, parts);
                    req.withEndpoint(endpoint, endpointPath, endpointMatchPath);
                    afterEndpointPath = new Path(parts);
                    for (Collection collection : api.getCollections()) {
                        Path collectionPath;
                        Db db = collection.getDb();
                        if (db != null && db.getEndpointPath() != null && !db.getEndpointPath().matches(endpointPath) || (collectionPath = collection.match(method, parts)) == null) continue;
                        Path collectionMatchPath = new Path(collectionPath);
                        collectionPath = collectionPath.extract(pathParams, parts, true);
                        req.withCollection(collection, collectionPath, collectionMatchPath);
                        if (db == null || db.getEndpointPath() == null) break block33;
                        db.getEndpointPath().extract(pathParams, afterApiPath, true);
                        break block33;
                    }
                }
            }
            chain.withPathParams(pathParams);
            if (req.getEndpoint() == null || req.isDebug()) {
                res.debug("", new Object[0]);
                res.debug("", new Object[0]);
                res.debug(">> request --------------", new Object[0]);
                res.debug(req.getMethod() + ": " + url, new Object[0]);
                ArrayListValuedHashMap<String, String> headers = req.getHeaders();
                for (String key : headers.keys()) {
                    res.debug(key + " " + Utils.implode(",", headers.get((Object)key)), new Object[0]);
                }
                res.debug("", new Object[0]);
            }
            if (req.getApi() == null) {
                throw ApiException.new400BadRequest("No API found matching URL: '{}'", url);
            }
            if (req.getEndpoint() == null) {
                StringBuilder buff = new StringBuilder();
                for (Endpoint e : req.getApi().getEndpoints()) {
                    if (e.isInternal()) continue;
                    buff.append(e.toString()).append(" | ");
                }
                throw ApiException.new404NotFound("No Endpoint found matching '{}:{}' Valid endpoints are: {}", req.getMethod(), url, buff.toString());
            }
            ArrayList<Chain.ActionMatch> actions = new ArrayList<Chain.ActionMatch>();
            for (Action action : req.getEndpoint().getActions()) {
                Path path = action.match(method, afterEndpointPath);
                if (path == null) continue;
                actions.add(new Chain.ActionMatch(path, new Path(afterEndpointPath), action));
            }
            for (Action action : req.getApi().getActions()) {
                Path path = action.match(method, afterApiPath);
                if (path == null) continue;
                actions.add(new Chain.ActionMatch(path, new Path(afterApiPath), action));
            }
            if (actions.size() == 0) {
                throw ApiException.new404NotFound("No Actions are configured to handle your request.  Check your server configuration.", new Object[0]);
            }
            Collections.sort(actions);
            if (req.isDebug()) {
                Chain.debug("Endpoint: " + req.getEndpoint());
                Chain.debug("Actions: " + actions);
            }
            this.run(chain, actions);
            Object var16_44 = null;
            for (Api.ApiListener apiListener : this.getApiListeners(req)) {
                try {
                    apiListener.afterRequest(req, res);
                }
                catch (Exception ex) {
                    if (var16_45 != null) continue;
                    Exception exception = ex;
                }
            }
            if (var16_45 != null) {
                throw var16_45;
            }
            Chain chain3 = chain;
            return chain3;
        }
        catch (Throwable ex) {
            String status = "500 Internal Server Error";
            if (ex instanceof ApiException) {
                if (req != null && req.isDebug() && ((ApiException)ex).getStatus().startsWith("5")) {
                    this.log.error("Error in Engine", ex);
                }
                status = ((ApiException)ex).getStatus();
            } else {
                ex = Utils.getCause(ex);
                if (Chain.getDepth() == 1) {
                    this.log.error("Non ApiException was caught in Engine.", ex);
                }
            }
            res.withStatus(status);
            String string = ex.getMessage();
            JSNode response = new JSNode("message", string);
            if ("500 Internal Server Error".equals(status)) {
                response.put("error", (Object)Utils.getShortCause(ex));
            }
            res.withError(ex);
            res.withJson(response);
            for (Api.ApiListener listener : this.getApiListeners(req)) {
                try {
                    listener.afterError(req, res);
                }
                catch (Exception ex2) {
                    this.log.warn("Error notifying EngineListener.beforeError", ex);
                }
            }
        }
        finally {
            for (Api.ApiListener listener : this.getApiListeners(req)) {
                try {
                    listener.beforeFinally(req, res);
                }
                catch (Exception ex) {
                    this.log.warn("Error notifying EngineListener.onFinally", (Throwable)ex);
                }
            }
            try {
                this.writeResponse(req, res);
            }
            catch (Throwable ex) {
                this.log.error("Error writing response.", ex);
            }
            if (chain != null) {
                Chain.pop();
            }
            this.lastResponse = res;
        }
        return chain;
    }

    void run(Chain chain, List<Chain.ActionMatch> actions) throws ApiException {
        chain.withActions(actions).go();
    }

    void writeResponse(Request req, Response res) throws ApiException {
        String method;
        boolean debug = req != null && req.isDebug();
        boolean explain = req != null && req.isExplain();
        String string = method = req != null ? req.getMethod() : null;
        if (!"OPTIONS".equals(method)) {
            if (debug) {
                res.debug("\r\n<< response -------------\r\n", new Object[0]);
                res.debug(res.getStatusCode() + "", new Object[0]);
            }
            if (!Utils.empty(res.getRedirect())) {
                res.withHeader("Location", res.getRedirect());
                res.withStatus("308 Permanent Redirect");
            } else {
                String output = res.getContent();
                String contentType = res.getContentType();
                if (output != null && contentType == null) {
                    contentType = res.getJson() != null ? "application/json" : (output.contains("<html") ? "text/html" : "text/text");
                    res.withContentType(contentType);
                }
                res.out(output);
            }
            if (debug) {
                for (String key : res.getHeaders().keySet()) {
                    List values = res.getHeaders().get((Object)key);
                    StringBuilder buff = new StringBuilder();
                    for (int i = 0; i < values.size(); ++i) {
                        buff.append(values.get(i));
                        if (i >= values.size() - 1) continue;
                        buff.append(",");
                    }
                    res.debug(key + " " + buff, new Object[0]);
                }
                res.debug("\r\n-- done -----------------\r\n", new Object[0]);
            }
            if (explain) {
                res.withOutput(res.getDebug());
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public Engine withEngineListener(EngineListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    LinkedHashSet<Api.ApiListener> getApiListeners(Request req) {
        LinkedHashSet<Api.ApiListener> listeners = new LinkedHashSet<Api.ApiListener>();
        if (req.getApi() != null) {
            listeners.addAll(req.getApi().getApiListeners());
        }
        listeners.addAll(this.listeners);
        return listeners;
    }

    public List<Api> getApis() {
        return new ArrayList<Api>(this.apis);
    }

    public synchronized Api getApi(String apiName) {
        for (Api api : this.apis) {
            if (!apiName.equalsIgnoreCase(api.getName())) continue;
            return api;
        }
        return null;
    }

    public synchronized Engine withApi(Api api) {
        if (this.apis.contains(api)) {
            return this;
        }
        ArrayList<Api> newList = new ArrayList<Api>(this.apis);
        Api existingApi = this.getApi(api.getName());
        if (existingApi != null && existingApi != api) {
            newList.remove(existingApi);
            newList.add(api);
        } else if (existingApi == null) {
            newList.add(api);
        }
        if (existingApi != api && this.isStarted()) {
            api.startup();
        }
        this.apis = newList;
        if (existingApi != null && existingApi != api) {
            existingApi.shutdown();
        }
        return this;
    }

    protected void startupApi(Api api) {
        if (this.started) {
            try {
                api.startup();
            }
            catch (Exception ex) {
                this.log.warn("Error starting api '" + api.getName() + "'", (Throwable)ex);
            }
            for (EngineListener listener : this.listeners) {
                try {
                    listener.onStartup(api);
                }
                catch (Exception ex) {
                    this.log.warn("Error starting api '" + api.getName() + "'", (Throwable)ex);
                }
            }
        }
    }

    public synchronized void removeApi(Api api) {
        ArrayList<Api> newList = new ArrayList<Api>(this.apis);
        newList.remove(api);
        this.apis = newList;
        this.shutdownApi(api);
    }

    protected void shutdownApi(Api api) {
        if (api.isStarted()) {
            try {
                api.shutdown();
            }
            catch (Exception ex) {
                this.log.warn("Error shutting down api '" + api.getName() + "'", (Throwable)ex);
            }
            for (EngineListener listener : this.listeners) {
                try {
                    listener.onShutdown(api);
                }
                catch (Exception ex) {
                    this.log.warn("Error shutting down api '" + api.getName() + "'", (Throwable)ex);
                }
            }
        }
    }

    public Engine withAllowHeaders(String allowHeaders) {
        this.corsAllowHeaders = allowHeaders;
        return this;
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    public URL getResource(String name) {
        try {
            File file;
            URL url = this.getClass().getClassLoader().getResource(name);
            if (url == null && (file = new File(System.getProperty("user.dir"), name)).exists()) {
                url = file.toURI().toURL();
            }
            return url;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public Engine withConfigPath(String configPath) {
        this.configPath = configPath;
        return this;
    }

    public String getConfigProfile() {
        return this.configProfile;
    }

    public Engine withConfigProfile(String configProfile) {
        this.configProfile = configProfile;
        return this;
    }

    static {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.setLevel(Level.WARN);
    }

    public static interface EngineListener
    extends Api.ApiListener {
        default public void onStartup(Engine engine) {
        }

        default public void onShutdown(Engine engine) {
        }
    }
}

