/*
 * Decompiled with CFR 0.152.
 */
package roguelikestarterkit.ui.components;

import indigo.shared.Outcome;
import indigo.shared.assets.AssetName$package$;
import indigo.shared.collections.Batch;
import indigo.shared.datatypes.Point;
import indigo.shared.datatypes.RGBA;
import indigo.shared.datatypes.Rectangle;
import indigo.shared.datatypes.Size;
import indigo.shared.materials.Material;
import indigo.shared.scenegraph.CloneBlank$package$;
import indigo.shared.scenegraph.Graphic;
import indigo.shared.scenegraph.Layer;
import indigo.shared.scenegraph.Layer$Content$;
import indigoextras.ui.component.Component;
import indigoextras.ui.components.Button;
import indigoextras.ui.components.Button$;
import indigoextras.ui.datatypes.Bounds$package$;
import indigoextras.ui.datatypes.Coords$package$;
import indigoextras.ui.datatypes.Dimensions$package$;
import indigoextras.ui.datatypes.UIContext;
import java.io.Serializable;
import roguelikestarterkit.package$package$;
import roguelikestarterkit.syntax$;
import roguelikestarterkit.terminal.RogueTerminalEmulator;
import roguelikestarterkit.terminal.RogueTerminalEmulator$;
import roguelikestarterkit.terminal.TerminalClones;
import roguelikestarterkit.terminal.TerminalMaterial;
import roguelikestarterkit.terminal.TerminalMaterial$;
import roguelikestarterkit.tiles.Tile$package$Tile$;
import roguelikestarterkit.ui.components.TerminalBorderTiles;
import roguelikestarterkit.ui.components.TerminalButton;
import roguelikestarterkit.ui.components.TerminalButton$Theme$;
import roguelikestarterkit.ui.datatypes.CharSheet;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class TerminalButton$
implements Serializable {
    private static final Graphic<TerminalMaterial> graphic;
    public static final TerminalButton$Theme$ Theme;
    public static final TerminalButton$ MODULE$;

    private TerminalButton$() {
    }

    static {
        AssetName$package$ assetName$package$;
        MODULE$ = new TerminalButton$();
        AssetName$package$ AssetName$package$_this = assetName$package$ = AssetName$package$.MODULE$;
        graphic = indigo.package$package$.MODULE$.Graphic().apply(0, 0, (Material)TerminalMaterial$.MODULE$.apply("", indigo.package$package$.MODULE$.RGBA().White(), indigo.package$package$.MODULE$.RGBA().Black()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TerminalButton$.class);
    }

    private <ReferenceData> Function2<UIContext<ReferenceData>, Button<ReferenceData>, Outcome<Layer>> presentButton(Function1<UIContext<ReferenceData>, Batch<Object>> label, RGBA fgColor, RGBA bgColor, CharSheet charSheet, boolean hasBorder, TerminalBorderTiles borderTiles) {
        if (hasBorder) {
            return this.presentButtonWithBorder(label, fgColor, bgColor, charSheet, borderTiles);
        }
        return this.presentButtonNoBorder(label, fgColor, bgColor, charSheet);
    }

    private <ReferenceData> Function2<UIContext<ReferenceData>, Button<ReferenceData>, Outcome<Layer>> presentButtonNoBorder(Function1<UIContext<ReferenceData>, Batch<Object>> label, RGBA fgColor, RGBA bgColor, CharSheet charSheet) {
        return (Function2 & Serializable)(context, button) -> {
            Coords$package$ coords$package$;
            CloneBlank$package$ cloneBlank$package$;
            Size d$proxy1;
            Dimensions$package$ dimensions$package$;
            Dimensions$package$ dimensions$package$2 = Dimensions$package$.MODULE$;
            Bounds$package$ bounds$package$ = Bounds$package$.MODULE$;
            Rectangle r$proxy1 = button.bounds();
            Dimensions$package$ Dimensions$package$_this = dimensions$package$ = Dimensions$package$.MODULE$;
            Size size = d$proxy1 = r$proxy1.size();
            CloneBlank$package$ CloneBlank$package$_this = cloneBlank$package$ = CloneBlank$package$.MODULE$;
            String value$proxy1 = new StringBuilder(7).append("button_").append(charSheet.assetName().toString()).toString();
            Coords$package$ coords$package$2 = Coords$package$.MODULE$;
            Bounds$package$ bounds$package$2 = Bounds$package$.MODULE$;
            Rectangle r$proxy2 = button.bounds();
            Coords$package$ Coords$package$_this = coords$package$ = Coords$package$.MODULE$;
            Point c$proxy1 = r$proxy2.position();
            Coords$package$ coords$package$3 = Coords$package$.MODULE$;
            Point c$proxy2 = context.parent().coords();
            TerminalClones terminal = RogueTerminalEmulator$.MODULE$.apply(size).fill(Tile$package$Tile$.MODULE$.$u0020(), fgColor, bgColor).putTileLine(indigo.package$package$.MODULE$.Point().zero(), (Batch<Object>)((Batch)label.apply(context)), fgColor, bgColor).toCloneTiles(value$proxy1, c$proxy1.$times(charSheet.size().toPoint()).moveBy(c$proxy2.$times(charSheet.size().toPoint())), (Batch)charSheet.charCrops(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    RGBA fg = (RGBA)tuple2._1();
                    RGBA bg = (RGBA)tuple2._2();
                    return graphic.withMaterial((Material)TerminalMaterial$.MODULE$.apply(charSheet.assetName(), fg, bg));
                }
                throw new MatchError((Object)tuple2);
            });
            return indigo.package$package$.MODULE$.Outcome().apply(() -> TerminalButton$.presentButtonNoBorder$$anonfun$1$$anonfun$1(terminal));
        };
    }

    private <ReferenceData> Function2<UIContext<ReferenceData>, Button<ReferenceData>, Outcome<Layer>> presentButtonWithBorder(Function1<UIContext<ReferenceData>, Batch<Object>> label, RGBA fgColor, RGBA bgColor, CharSheet charSheet, TerminalBorderTiles borderTiles) {
        return (Function2 & Serializable)(context, button) -> {
            Coords$package$ coords$package$;
            CloneBlank$package$ cloneBlank$package$;
            Size d$proxy2;
            Dimensions$package$ dimensions$package$;
            Rectangle bounds = indigoextras.ui.syntax$.MODULE$.bounds(button, (Component)Button$.MODULE$.given_Component_Button_ReferenceData(), context);
            Bounds$package$ bounds$package$ = Bounds$package$.MODULE$;
            Rectangle r$proxy3 = bounds;
            Batch txt = ((Batch)label.apply(context)).take(r$proxy3.width() - 2);
            Bounds$package$ bounds$package$2 = Bounds$package$.MODULE$;
            Rectangle r$proxy4 = bounds;
            Batch hBar = indigo.package$package$.MODULE$.Batch().fill(r$proxy4.width() - 2, () -> TerminalButton$.$anonfun$2(borderTiles));
            Dimensions$package$ dimensions$package$2 = Dimensions$package$.MODULE$;
            Bounds$package$ bounds$package$3 = Bounds$package$.MODULE$;
            Rectangle r$proxy5 = bounds;
            Dimensions$package$ Dimensions$package$_this = dimensions$package$ = Dimensions$package$.MODULE$;
            Size size = d$proxy2 = r$proxy5.size();
            RogueTerminalEmulator terminal = RogueTerminalEmulator$.MODULE$.apply(size).fill(borderTiles.fill(), fgColor, bgColor).put(indigo.package$package$.MODULE$.Point().apply(0, 0), borderTiles.topLeft(), fgColor, bgColor).put(indigo.package$package$.MODULE$.Point().apply(size.width() - 1, 0), borderTiles.topRight(), fgColor, bgColor).put(indigo.package$package$.MODULE$.Point().apply(0, size.height() - 1), borderTiles.bottomLeft(), fgColor, bgColor).put(indigo.package$package$.MODULE$.Point().apply(size.width() - 1, size.height() - 1), borderTiles.bottomRight(), fgColor, bgColor).put(indigo.package$package$.MODULE$.Point().apply(0, 1), borderTiles.vertical(), fgColor, bgColor).put(indigo.package$package$.MODULE$.Point().apply(size.width() - 1, 1), borderTiles.vertical(), fgColor, bgColor).putTileLine(indigo.package$package$.MODULE$.Point().apply(1, 0), (Batch<Object>)hBar, fgColor, bgColor).putTileLine(indigo.package$package$.MODULE$.Point().apply(1, 1), (Batch<Object>)txt, fgColor, bgColor).putTileLine(indigo.package$package$.MODULE$.Point().apply(1, 2), (Batch<Object>)hBar, fgColor, bgColor);
            CloneBlank$package$ CloneBlank$package$_this = cloneBlank$package$ = CloneBlank$package$.MODULE$;
            String value$proxy2 = new StringBuilder(7).append("button_").append(charSheet.assetName().toString()).toString();
            Coords$package$ coords$package$2 = Coords$package$.MODULE$;
            Bounds$package$ bounds$package$4 = Bounds$package$.MODULE$;
            Rectangle r$proxy6 = bounds;
            Coords$package$ Coords$package$_this = coords$package$ = Coords$package$.MODULE$;
            Point c$proxy3 = r$proxy6.position();
            Coords$package$ coords$package$3 = Coords$package$.MODULE$;
            Point c$proxy4 = context.parent().coords();
            TerminalClones terminalClones = terminal.toCloneTiles(value$proxy2, c$proxy3.$times(charSheet.size().toPoint()).moveBy(c$proxy4.$times(charSheet.size().toPoint())), (Batch)charSheet.charCrops(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    RGBA fg = (RGBA)tuple2._1();
                    RGBA bg = (RGBA)tuple2._2();
                    return graphic.withMaterial((Material)TerminalMaterial$.MODULE$.apply(charSheet.assetName(), fg, bg));
                }
                throw new MatchError((Object)tuple2);
            });
            return indigo.package$package$.MODULE$.Outcome().apply(() -> TerminalButton$.presentButtonWithBorder$$anonfun$1$$anonfun$1(terminalClones));
        };
    }

    private Rectangle findBounds(int labelLength, boolean hasBorder) {
        Bounds$package$ bounds$package$;
        if (hasBorder) {
            Bounds$package$ bounds$package$2;
            Bounds$package$ Bounds$package$_this = bounds$package$2 = Bounds$package$.MODULE$;
            int width$proxy1 = labelLength + 2;
            return indigo.package$package$.MODULE$.Rectangle().apply(0, 0, width$proxy1, 3);
        }
        Bounds$package$ Bounds$package$_this = bounds$package$ = Bounds$package$.MODULE$;
        return indigo.package$package$.MODULE$.Rectangle().apply(0, 0, labelLength, 1);
    }

    public <ReferenceData> Button<ReferenceData> apply(Function1<UIContext<ReferenceData>, String> label, TerminalButton.Theme theme, Function1<UIContext<ReferenceData>, Rectangle> calculateBounds) {
        Function1 & Serializable tileLabel = (Function1 & Serializable)ctx -> package$package$.MODULE$.TerminalEmulator().stringToTileBatch((String)label.apply(ctx));
        return this.fromTiles(tileLabel, theme, calculateBounds);
    }

    public <ReferenceData> Button<ReferenceData> apply(String label, TerminalButton.Theme theme, Rectangle bounds) {
        return this.apply((Function1 & Serializable)_$1 -> label, theme, (Function1 & Serializable)_$2 -> bounds);
    }

    public <ReferenceData> Button<ReferenceData> apply(String label, TerminalButton.Theme theme) {
        return this.apply(label, theme, this.findBounds(label.length(), theme.hasBorder()));
    }

    public <ReferenceData> Button<ReferenceData> apply(Function1<UIContext<ReferenceData>, String> label, TerminalButton.Theme theme) {
        return this.apply(label, theme, (Function1 & Serializable)ctx -> MODULE$.findBounds(((String)label.apply(ctx)).length(), theme.hasBorder()));
    }

    public <ReferenceData> Button<ReferenceData> fromTiles(Function1<UIContext<ReferenceData>, Batch<Object>> tileLabel, TerminalButton.Theme theme, Function1<UIContext<ReferenceData>, Rectangle> calculateBounds) {
        return indigoextras.ui.package$package$.MODULE$.Button().apply(calculateBounds, this.presentButton(tileLabel, theme.up().foreground(), theme.up().background(), theme.charSheet(), theme.hasBorder(), theme.borderTiles())).presentOver(this.presentButton(tileLabel, theme.over().foreground(), theme.over().background(), theme.charSheet(), theme.hasBorder(), theme.borderTiles())).presentDown(this.presentButton(tileLabel, theme.down().foreground(), theme.down().background(), theme.charSheet(), theme.hasBorder(), theme.borderTiles()));
    }

    public <ReferenceData> Button<ReferenceData> fromTiles(Batch<Object> label, TerminalButton.Theme theme, Rectangle bounds) {
        return this.fromTiles((Function1 & Serializable)_$3 -> label, theme, (Function1 & Serializable)_$4 -> bounds);
    }

    public <ReferenceData> Button<ReferenceData> fromTiles(Batch<Object> label, TerminalButton.Theme theme) {
        return this.fromTiles(label, theme, this.findBounds(label.length(), theme.hasBorder()));
    }

    public <ReferenceData> Button<ReferenceData> fromTiles(Function1<UIContext<ReferenceData>, Batch<Object>> label, TerminalButton.Theme theme) {
        return this.fromTiles(label, theme, (Function1 & Serializable)ctx -> MODULE$.findBounds(((Batch)label.apply(ctx)).length(), theme.hasBorder()));
    }

    public <ReferenceData> Button<ReferenceData> fromTile(int label, TerminalButton.Theme theme) {
        return this.fromTiles((Batch<Object>)indigo.package$package$.MODULE$.Batch().apply((Object)BoxesRunTime.boxToInteger((int)label)), theme, this.findBounds(1, theme.hasBorder()));
    }

    public <ReferenceData> Button<ReferenceData> fromTile(Function1<UIContext<ReferenceData>, Object> label, TerminalButton.Theme theme) {
        return this.fromTiles((Function1 & Serializable)ctx -> indigo.package$package$.MODULE$.Batch().apply(label.apply(ctx)), theme, (Function1 & Serializable)_$5 -> MODULE$.findBounds(1, theme.hasBorder()));
    }

    private static final Layer.Content presentButtonNoBorder$$anonfun$1$$anonfun$1(TerminalClones terminal$1) {
        indigo.package$package$.MODULE$.Layer();
        return syntax$.MODULE$.apply(Layer$Content$.MODULE$, terminal$1);
    }

    private static final int $anonfun$2(TerminalBorderTiles borderTiles$6) {
        return borderTiles$6.horizontal();
    }

    private static final Layer.Content presentButtonWithBorder$$anonfun$1$$anonfun$1(TerminalClones terminalClones$1) {
        indigo.package$package$.MODULE$.Layer();
        return syntax$.MODULE$.apply(Layer$Content$.MODULE$, terminalClones$1);
    }
}

