/*
 * Decompiled with CFR 0.152.
 */
package roguelikestarterkit.terminal;

import indigo.shared.collections.Batch;
import indigo.shared.datatypes.Circle;
import indigo.shared.datatypes.Point;
import indigo.shared.datatypes.RGBA;
import indigo.shared.datatypes.Rectangle;
import indigo.shared.datatypes.Size;
import indigo.shared.geometry.LineSegment;
import indigoextras.datatypes.SparseGrid;
import java.io.Serializable;
import roguelikestarterkit.package$package$;
import roguelikestarterkit.terminal.MapTile;
import roguelikestarterkit.terminal.MapTile$;
import roguelikestarterkit.terminal.RogueTerminalEmulator;
import roguelikestarterkit.terminal.RogueTerminalEmulator$;
import roguelikestarterkit.terminal.Terminal;
import roguelikestarterkit.terminal.Terminal$;
import roguelikestarterkit.terminal.TerminalEmulator$;
import roguelikestarterkit.tiles.Tile$package$;
import roguelikestarterkit.tiles.Tile$package$Tile$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.ArrayOps$;

public final class TerminalEmulator
implements Terminal,
Product,
Serializable {
    private final Size size;
    private final SparseGrid<MapTile> charMap;
    private Batch coordsBatch$lzy1;
    private boolean coordsBatchbitmap$1;

    public static TerminalEmulator apply(Size size) {
        return TerminalEmulator$.MODULE$.apply(size);
    }

    public static TerminalEmulator apply(Size size, SparseGrid<MapTile> sparseGrid) {
        return TerminalEmulator$.MODULE$.apply(size, sparseGrid);
    }

    public static TerminalEmulator fromProduct(Product product) {
        return TerminalEmulator$.MODULE$.fromProduct(product);
    }

    public static Batch<Object> stringToTileBatch(String string) {
        return TerminalEmulator$.MODULE$.stringToTileBatch(string);
    }

    public static TerminalEmulator unapply(TerminalEmulator terminalEmulator) {
        return TerminalEmulator$.MODULE$.unapply(terminalEmulator);
    }

    public TerminalEmulator(Size size, SparseGrid<MapTile> charMap) {
        this.size = size;
        this.charMap = charMap;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TerminalEmulator)) return false;
        TerminalEmulator terminalEmulator = (TerminalEmulator)object;
        Size size = this.size();
        Size size2 = terminalEmulator.size();
        if (size == null) {
            if (size2 != null) {
                return false;
            }
        } else if (!size.equals(size2)) return false;
        SparseGrid<MapTile> sparseGrid = this.charMap();
        SparseGrid<MapTile> sparseGrid2 = terminalEmulator.charMap();
        if (sparseGrid == null) {
            if (sparseGrid2 == null) return true;
            return false;
        } else {
            if (!sparseGrid.equals(sparseGrid2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TerminalEmulator;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "TerminalEmulator";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "size";
        }
        if (1 == n2) {
            return "charMap";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public Size size() {
        return this.size;
    }

    public SparseGrid<MapTile> charMap() {
        return this.charMap;
    }

    private Batch<Point> coordsBatch() {
        if (!this.coordsBatchbitmap$1) {
            this.coordsBatch$lzy1 = indigo.package$package$.MODULE$.Batch().fromIndexedSeq((IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size().height()).flatMap((Function1 & Serializable)y -> this.coordsBatch$$anonfun$1(BoxesRunTime.unboxToInt((Object)y))));
            this.coordsBatchbitmap$1 = true;
        }
        return this.coordsBatch$lzy1;
    }

    @Override
    public TerminalEmulator put(Point coords, int tile, RGBA fgColor, RGBA bgColor) {
        SparseGrid sparseGrid = this.charMap().put(coords, (Object)MapTile$.MODULE$.apply(tile, fgColor, bgColor));
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator put(Point coords, int tile, RGBA fgColor) {
        SparseGrid sparseGrid = this.charMap().put(coords, (Object)MapTile$.MODULE$.apply(tile, fgColor));
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator put(Point coords, int tile) {
        SparseGrid sparseGrid = this.charMap().put(coords, (Object)MapTile$.MODULE$.apply(tile));
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator put(Batch<Tuple2<Point, MapTile>> tiles) {
        SparseGrid sparseGrid = this.charMap().put(tiles.map((Function1 & Serializable)p -> Tuple2$.MODULE$.apply(p._1(), p._2())));
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator put(Batch<Tuple2<Point, MapTile>> tiles, Point offset) {
        SparseGrid sparseGrid = this.charMap().put(tiles.map((Function1 & Serializable)p -> Tuple2$.MODULE$.apply((Object)((Point)p._1()).$plus(offset), p._2())));
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator put(Seq<Tuple2<Point, MapTile>> tiles) {
        return this.put(indigo.package$package$.MODULE$.Batch().fromSeq(tiles));
    }

    @Override
    public TerminalEmulator put(Point coords, MapTile mapTile) {
        Point point = (Point)Predef$.MODULE$.ArrowAssoc((Object)coords);
        return this.put(indigo.package$package$.MODULE$.Batch().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)point, (Object)mapTile)));
    }

    @Override
    public TerminalEmulator fill(MapTile mapTile) {
        SparseGrid sparseGrid = this.charMap().put(this.coordsBatch().map((Function1 & Serializable)pt -> {
            Point point = (Point)Predef$.MODULE$.ArrowAssoc(pt);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)point, (Object)mapTile);
        }));
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator fill(int tile, RGBA foregroundColor, RGBA backgroundColor) {
        return this.fill(MapTile$.MODULE$.apply(tile, foregroundColor, backgroundColor));
    }

    @Override
    public TerminalEmulator putLine(Point startCoords, String text, RGBA fgColor, RGBA bgColor) {
        Batch tiles = TerminalEmulator$.MODULE$.stringToTileBatch(text).zipWithIndex().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int t = BoxesRunTime.unboxToInt((Object)tuple2._1());
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Point point = (Point)Predef$.MODULE$.ArrowAssoc((Object)startCoords.$plus(indigo.package$package$.MODULE$.Point().apply(i, 0)));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)point, (Object)MapTile$.MODULE$.apply(t, fgColor, bgColor));
            }
            throw new MatchError((Object)tuple2);
        });
        return this.put(tiles);
    }

    @Override
    public TerminalEmulator putLines(Point startCoords, Batch<String> textLines, RGBA fgColor, RGBA bgColor) {
        return TerminalEmulator.rec$1(startCoords, fgColor, bgColor, textLines.toList(), 0, this);
    }

    public TerminalEmulator putTileLine(Point startCoords, Batch<Object> tiles, RGBA fgColor, RGBA bgColor) {
        Batch res = tiles.zipWithIndex().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int t = BoxesRunTime.unboxToInt((Object)tuple2._1());
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Point point = (Point)Predef$.MODULE$.ArrowAssoc((Object)startCoords.$plus(indigo.package$package$.MODULE$.Point().apply(i, 0)));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)point, (Object)MapTile$.MODULE$.apply(t, fgColor, bgColor));
            }
            throw new MatchError((Object)tuple2);
        });
        return this.put(res);
    }

    public TerminalEmulator putTileLines(Point startCoords, Batch<Batch<Object>> textLines, RGBA fgColor, RGBA bgColor) {
        return TerminalEmulator.rec$2(startCoords, fgColor, bgColor, textLines.toList(), 0, this);
    }

    @Override
    public Option<MapTile> get(Point coords) {
        return this.charMap().get(coords);
    }

    @Override
    public TerminalEmulator delete(Point coords) {
        SparseGrid sparseGrid = this.charMap().remove(coords);
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator clear() {
        SparseGrid sparseGrid = this.charMap().clear();
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public Batch<MapTile> toTileBatch() {
        return this.charMap().toBatch((Object)Terminal$.MODULE$.EmptyTile());
    }

    @Override
    public Batch<MapTile> toTileBatch(Rectangle region) {
        return this.charMap().toBatch(region, (Object)Terminal$.MODULE$.EmptyTile());
    }

    @Override
    public Batch<MapTile> toBatch() {
        return this.charMap().toBatch().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Option x) {
                Option option = x;
                if (option instanceof Some) {
                    MapTile v = (MapTile)((Some)option).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                Option option = x;
                if (option instanceof Some) {
                    MapTile v = (MapTile)((Some)option).value();
                    return v;
                }
                return function1.apply((Object)x);
            }
        });
    }

    @Override
    public Batch<MapTile> toBatch(Rectangle region) {
        return this.charMap().toBatch(region);
    }

    @Override
    public Batch<Tuple2<Point, MapTile>> toPositionedBatch() {
        return this.charMap().toPositionedBatch();
    }

    @Override
    public Batch<Tuple2<Point, MapTile>> toPositionedBatch(Rectangle region) {
        return this.charMap().toPositionedBatch(region);
    }

    @Override
    public TerminalEmulator $bar$plus$bar(Terminal otherConsole) {
        return this.combine(otherConsole);
    }

    @Override
    public TerminalEmulator combine(Terminal otherConsole) {
        SparseGrid sparseGrid = this.charMap().put(otherConsole.toPositionedBatch());
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator inset(Terminal otherConsole, Point offset) {
        return this.put((Batch)otherConsole.toPositionedBatch(), offset);
    }

    public RogueTerminalEmulator toRogueTerminalEmulator() {
        return RogueTerminalEmulator$.MODULE$.apply(this.size()).inset(this, indigo.package$package$.MODULE$.Point().zero());
    }

    private Function2<Point, Option<MapTile>, Option<MapTile>> liftModifier(Function2<Point, MapTile, MapTile> modifier) {
        return (Function2 & Serializable)(pt, opt) -> {
            Option option = opt;
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                MapTile value = (MapTile)((Some)option).value();
                return Option$.MODULE$.apply(modifier.apply(pt, (Object)value));
            }
            throw new MatchError((Object)option);
        };
    }

    @Override
    public TerminalEmulator modifyAt(Point position, Function1<MapTile, MapTile> modifier) {
        SparseGrid sparseGrid = this.charMap().modifyAt(position, (Function1 & Serializable)_$1 -> _$1.map(modifier));
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator map(Function2<Point, MapTile, MapTile> modifier) {
        SparseGrid sparseGrid = this.charMap().map(this.liftModifier(modifier));
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator mapRectangle(Rectangle region, Function2<Point, MapTile, MapTile> modifier) {
        SparseGrid sparseGrid = this.charMap().mapRectangle(region, this.liftModifier(modifier));
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator fillRectangle(Rectangle region, MapTile mapTile) {
        return this.mapRectangle(region, (Function2 & Serializable)(_$2, _$3) -> mapTile);
    }

    @Override
    public TerminalEmulator fillRectangle(Rectangle region, int tile) {
        return this.mapRectangle(region, (Function2 & Serializable)(_$4, mt) -> mt.withChar(tile));
    }

    @Override
    public TerminalEmulator fillRectangle(Rectangle region, int tile, RGBA foreground) {
        return this.mapRectangle(region, (Function2 & Serializable)(_$5, mt) -> MapTile$.MODULE$.apply(tile, foreground, mt.background()));
    }

    @Override
    public TerminalEmulator fillRectangle(Rectangle region, int tile, RGBA foreground, RGBA background) {
        return this.mapRectangle(region, (Function2 & Serializable)(_$6, mt) -> MapTile$.MODULE$.apply(tile, foreground, background));
    }

    @Override
    public TerminalEmulator mapCircle(Circle circle, Function2<Point, MapTile, MapTile> modifier) {
        SparseGrid sparseGrid = this.charMap().mapCircle(circle, this.liftModifier(modifier));
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator fillCircle(Circle circle, MapTile mapTile) {
        return this.mapCircle(circle, (Function2 & Serializable)(_$7, _$8) -> mapTile);
    }

    @Override
    public TerminalEmulator fillCircle(Circle circle, int tile) {
        return this.mapCircle(circle, (Function2 & Serializable)(_$9, mt) -> mt.withChar(tile));
    }

    @Override
    public TerminalEmulator fillCircle(Circle circle, int tile, RGBA foreground) {
        return this.mapCircle(circle, (Function2 & Serializable)(_$10, mt) -> MapTile$.MODULE$.apply(tile, foreground, mt.background()));
    }

    @Override
    public TerminalEmulator fillCircle(Circle circle, int tile, RGBA foreground, RGBA background) {
        return this.mapCircle(circle, (Function2 & Serializable)(_$11, mt) -> MapTile$.MODULE$.apply(tile, foreground, background));
    }

    @Override
    public TerminalEmulator mapLine(Point from, Point to, Function2<Point, MapTile, MapTile> modifier) {
        SparseGrid sparseGrid = this.charMap().mapLine(from, to, this.liftModifier(modifier));
        Size size = this.copy$default$1();
        return this.copy(size, (SparseGrid<MapTile>)sparseGrid);
    }

    @Override
    public TerminalEmulator mapLine(LineSegment line, Function2<Point, MapTile, MapTile> modifier) {
        return this.mapLine(line.start().toPoint(), line.end().toPoint(), (Function2)modifier);
    }

    @Override
    public TerminalEmulator fillLine(LineSegment line, MapTile mapTile) {
        return this.mapLine(line.start().toPoint(), line.end().toPoint(), (Function2 & Serializable)(_$12, _$13) -> mapTile);
    }

    @Override
    public TerminalEmulator fillLine(LineSegment line, int tile) {
        return this.mapLine(line.start().toPoint(), line.end().toPoint(), (Function2 & Serializable)(_$14, mt) -> mt.withChar(tile));
    }

    @Override
    public TerminalEmulator fillLine(LineSegment line, int tile, RGBA foreground) {
        return this.mapLine(line.start().toPoint(), line.end().toPoint(), (Function2 & Serializable)(_$15, mt) -> MapTile$.MODULE$.apply(tile, foreground, mt.background()));
    }

    @Override
    public TerminalEmulator fillLine(LineSegment line, int tile, RGBA foreground, RGBA background) {
        return this.mapLine(line.start().toPoint(), line.end().toPoint(), (Function2 & Serializable)(_$16, mt) -> MapTile$.MODULE$.apply(tile, foreground, background));
    }

    @Override
    public TerminalEmulator fillLine(Point from, Point to, MapTile mapTile) {
        return this.mapLine(from, to, (Function2 & Serializable)(_$17, _$18) -> mapTile);
    }

    @Override
    public TerminalEmulator fillLine(Point from, Point to, int tile) {
        return this.mapLine(from, to, (Function2 & Serializable)(_$19, mt) -> mt.withChar(tile));
    }

    @Override
    public TerminalEmulator fillLine(Point from, Point to, int tile, RGBA foreground) {
        return this.mapLine(from, to, (Function2 & Serializable)(_$20, mt) -> MapTile$.MODULE$.apply(tile, foreground, mt.background()));
    }

    @Override
    public TerminalEmulator fillLine(Point from, Point to, int tile, RGBA foreground, RGBA background) {
        return this.mapLine(from, to, (Function2 & Serializable)(_$21, mt) -> MapTile$.MODULE$.apply(tile, foreground, background));
    }

    public String toASCII(int nullReplacement) {
        Tile$package$ tile$package$;
        Tile$package$ Tile$package$_this = tile$package$ = Tile$package$.MODULE$;
        int char$proxy1 = Tile$package$Tile$.MODULE$.toInt(nullReplacement);
        Array array = Any$.MODULE$.jsArrayOps(this.charMap().toBatch((Object)MapTile$.MODULE$.apply(Math.min(255, Math.max(0, char$proxy1)))).map((Function1 & Serializable)_$22 -> Tile$package$Tile$.MODULE$.toInt(_$22.char())).map((Function1 & Serializable)x$1 -> TerminalEmulator.toASCII$$anonfun$2(nullReplacement, BoxesRunTime.unboxToInt((Object)x$1))).toJSArray());
        return ArrayOps$.MODULE$.sliding$extension(array, this.size().width(), this.size().width()).map((Function1 & Serializable)_$23 -> Any$.MODULE$.wrapArray(_$23).mkString()).mkString("\n");
    }

    public String toASCII() {
        return this.toASCII(package$package$.MODULE$.Tile().SPACE());
    }

    public TerminalEmulator copy(Size size, SparseGrid<MapTile> charMap) {
        return new TerminalEmulator(size, charMap);
    }

    public Size copy$default$1() {
        return this.size();
    }

    public SparseGrid<MapTile> copy$default$2() {
        return this.charMap();
    }

    public Size _1() {
        return this.size();
    }

    public SparseGrid<MapTile> _2() {
        return this.charMap();
    }

    private static final /* synthetic */ Point coordsBatch$$anonfun$1$$anonfun$1(int y$1, int x) {
        return indigo.package$package$.MODULE$.Point().apply(x, y$1);
    }

    private final /* synthetic */ IterableOnce coordsBatch$$anonfun$1(int y) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size().width()).map((Function1 & Serializable)x -> TerminalEmulator.coordsBatch$$anonfun$1$$anonfun$1(y, BoxesRunTime.unboxToInt((Object)x)));
    }

    private static final TerminalEmulator rec$1(Point startCoords$2, RGBA fgColor$2, RGBA bgColor$2, List remaining, int yOffset, TerminalEmulator term) {
        List list;
        while (true) {
            List xs;
            list = remaining;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return term;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next();
            String x = (String)colon2.head();
            List list4 = xs = list3;
            int n = yOffset + 1;
            TerminalEmulator terminalEmulator = term.putLine(startCoords$2.$plus(indigo.package$package$.MODULE$.Point().apply(0, yOffset)), x, fgColor$2, bgColor$2);
            remaining = list4;
            yOffset = n;
            term = terminalEmulator;
        }
        throw new MatchError((Object)list);
    }

    private static final TerminalEmulator rec$2(Point startCoords$4, RGBA fgColor$4, RGBA bgColor$4, List remaining, int yOffset, TerminalEmulator term) {
        List list;
        while (true) {
            List xs;
            list = remaining;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return term;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next();
            Batch x = (Batch)colon2.head();
            List list4 = xs = list3;
            int n = yOffset + 1;
            TerminalEmulator terminalEmulator = term.putTileLine(startCoords$4.$plus(indigo.package$package$.MODULE$.Point().apply(0, yOffset)), (Batch<Object>)x, fgColor$4, bgColor$4);
            remaining = list4;
            yOffset = n;
            term = terminalEmulator;
        }
        throw new MatchError((Object)list);
    }

    private static final /* synthetic */ char toASCII$$anonfun$2(int nullReplacement$1, int x$1) {
        int n = x$1;
        if (0 == n) {
            return (char)Tile$package$Tile$.MODULE$.toInt(nullReplacement$1);
        }
        int c = n;
        return (char)c;
    }
}

