/*
 * Decompiled with CFR 0.152.
 */
package roguelikestarterkit.terminal;

import indigo.package$package$;
import indigo.shared.collections.Batch;
import indigo.shared.datatypes.Circle;
import indigo.shared.datatypes.Point;
import indigo.shared.datatypes.RGBA;
import indigo.shared.datatypes.Rectangle;
import indigo.shared.datatypes.Size;
import indigo.shared.geometry.LineSegment;
import indigoextras.utils.Bresenham$;
import java.io.Serializable;
import roguelikestarterkit.terminal.MapTile;
import roguelikestarterkit.terminal.MapTile$;
import roguelikestarterkit.terminal.RogueTerminalEmulator$;
import roguelikestarterkit.terminal.Terminal;
import roguelikestarterkit.terminal.Terminal$;
import roguelikestarterkit.terminal.TerminalEmulator;
import roguelikestarterkit.terminal.TerminalEmulator$;
import roguelikestarterkit.tiles.Tile$package$Tile$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.ArrayOps$;

public final class RogueTerminalEmulator
implements Terminal {
    private final Size size;
    private final Array<Object> _tiles;
    private final Array<RGBA> _foreground;
    private final Array<RGBA> _background;
    private int length$lzy1;
    private boolean lengthbitmap$1;
    private Batch tiles$lzy1;
    private boolean tilesbitmap$1;
    private Batch foregroundColors$lzy1;
    private boolean foregroundColorsbitmap$1;
    private Batch backgroundColors$lzy1;
    private boolean backgroundColorsbitmap$1;

    public static RogueTerminalEmulator apply(Size size) {
        return RogueTerminalEmulator$.MODULE$.apply(size);
    }

    public RogueTerminalEmulator(Size size, Array<Object> _tiles, Array<RGBA> _foreground, Array<RGBA> _background) {
        this.size = size;
        this._tiles = _tiles;
        this._foreground = _foreground;
        this._background = _background;
    }

    @Override
    public Size size() {
        return this.size;
    }

    public int length() {
        if (!this.lengthbitmap$1) {
            this.length$lzy1 = this.size().width() * this.size().height();
            this.lengthbitmap$1 = true;
        }
        return this.length$lzy1;
    }

    public Batch<Object> tiles() {
        if (!this.tilesbitmap$1) {
            this.tiles$lzy1 = package$package$.MODULE$.Batch().apply(this._tiles.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Array[0])));
            this.tilesbitmap$1 = true;
        }
        return this.tiles$lzy1;
    }

    public Batch<RGBA> foregroundColors() {
        if (!this.foregroundColorsbitmap$1) {
            this.foregroundColors$lzy1 = package$package$.MODULE$.Batch().apply(this._foreground.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Array[0])));
            this.foregroundColorsbitmap$1 = true;
        }
        return this.foregroundColors$lzy1;
    }

    public Batch<RGBA> backgroundColors() {
        if (!this.backgroundColorsbitmap$1) {
            this.backgroundColors$lzy1 = package$package$.MODULE$.Batch().apply(this._foreground.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Array[0])));
            this.backgroundColorsbitmap$1 = true;
        }
        return this.backgroundColors$lzy1;
    }

    public RogueTerminalEmulator clone() {
        return new RogueTerminalEmulator(this.size(), (Array<Object>)this._tiles.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Array[0])), (Array<RGBA>)this._foreground.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Array[0])), (Array<RGBA>)this._background.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Array[0])));
    }

    private void updateAt(int index, int tile, RGBA foregroundColor, RGBA backgroundColor) {
        this._tiles.update(index, (Object)BoxesRunTime.boxToInteger((int)tile));
        this._foreground.update(index, (Object)foregroundColor);
        this._background.update(index, (Object)backgroundColor);
    }

    @Override
    public RogueTerminalEmulator put(Point coords, int tile, RGBA foregroundColor, RGBA backgroundColor) {
        this.updateAt(coords.x() + coords.y() * this.size().width(), tile, foregroundColor, backgroundColor);
        return this;
    }

    @Override
    public RogueTerminalEmulator put(Point coords, int tile, RGBA foregroundColor) {
        return this.put(coords, tile, foregroundColor, package$package$.MODULE$.RGBA().Zero());
    }

    @Override
    public RogueTerminalEmulator put(Point coords, int tile) {
        return this.put(coords, tile, package$package$.MODULE$.RGBA().White(), package$package$.MODULE$.RGBA().Zero());
    }

    @Override
    public RogueTerminalEmulator put(Batch<Tuple2<Point, MapTile>> tiles) {
        tiles.foreach((Function1 & Serializable)t -> {
            this.put$$anonfun$1((Tuple2)t);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    @Override
    public RogueTerminalEmulator put(Batch<Tuple2<Point, MapTile>> tiles, Point offset) {
        tiles.foreach((Function1 & Serializable)t -> {
            this.put$$anonfun$2(offset, (Tuple2)t);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    @Override
    public RogueTerminalEmulator put(Seq<Tuple2<Point, MapTile>> tiles) {
        return this.put(package$package$.MODULE$.Batch().fromSeq(tiles));
    }

    @Override
    public RogueTerminalEmulator put(Point coords, MapTile mapTile) {
        return this.put(coords, mapTile.char(), mapTile.foreground(), mapTile.background());
    }

    @Override
    public RogueTerminalEmulator fill(int tile, RGBA foregroundColor, RGBA backgroundColor) {
        int count = this.length();
        for (int i = 0; i < count; ++i) {
            this.updateAt(i, tile, foregroundColor, backgroundColor);
        }
        return this;
    }

    @Override
    public RogueTerminalEmulator fill(MapTile mapTile) {
        return this.fill(mapTile.char(), mapTile.foreground(), mapTile.background());
    }

    @Override
    public RogueTerminalEmulator putLine(Point startCoords, String text, RGBA foregroundColor, RGBA backgroundColor) {
        TerminalEmulator$.MODULE$.stringToTileBatch(text).zipWithIndex().foreach((Function1 & Serializable)x$1 -> {
            this.putLine$$anonfun$1(startCoords, foregroundColor, backgroundColor, (Tuple2)x$1);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    @Override
    public RogueTerminalEmulator putLines(Point startCoords, Batch<String> textLines, RGBA foregroundColor, RGBA backgroundColor) {
        return RogueTerminalEmulator.rec$1(startCoords, foregroundColor, backgroundColor, textLines.toList(), 0, this);
    }

    public RogueTerminalEmulator putTileLine(Point startCoords, Batch<Object> tiles, RGBA foregroundColor, RGBA backgroundColor) {
        tiles.zipWithIndex().foreach((Function1 & Serializable)x$1 -> {
            this.putTileLine$$anonfun$1(startCoords, foregroundColor, backgroundColor, (Tuple2)x$1);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public RogueTerminalEmulator putTileLines(Point startCoords, Batch<Batch<Object>> tileLines, RGBA foregroundColor, RGBA backgroundColor) {
        return RogueTerminalEmulator.rec$2(startCoords, foregroundColor, backgroundColor, tileLines.toList(), 0, this);
    }

    @Override
    public Option<MapTile> get(Point coords) {
        MapTile mt;
        int idx = coords.x() + coords.y() * this.size().width();
        int t = BoxesRunTime.unboxToInt((Object)this._tiles.apply(idx));
        RGBA f = (RGBA)this._foreground.apply(idx);
        RGBA b = (RGBA)this._background.apply(idx);
        MapTile mapTile = mt = MapTile$.MODULE$.apply(t, f, b);
        MapTile mapTile2 = Terminal$.MODULE$.EmptyTile();
        if (!(mapTile != null ? !((Object)mapTile).equals(mapTile2) : mapTile2 != null)) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)mt);
    }

    @Override
    public RogueTerminalEmulator delete(Point coords) {
        return this.put(coords, Terminal$.MODULE$.EmptyTile());
    }

    @Override
    public RogueTerminalEmulator clear() {
        return this.fill(Terminal$.MODULE$.EmptyTile());
    }

    @Override
    public Batch<MapTile> toBatch() {
        return this.toTileBatch();
    }

    @Override
    public Batch<MapTile> toBatch(Rectangle region) {
        return this.toTileBatch(region);
    }

    @Override
    public Batch<MapTile> toTileBatch() {
        int count = this.length();
        Array acc = new Array(count);
        for (int i = 0; i < count; ++i) {
            acc.update(i, (Object)MapTile$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)this._tiles.apply(i)), (RGBA)this._foreground.apply(i), (RGBA)this._background.apply(i)));
        }
        return package$package$.MODULE$.Batch().apply(acc);
    }

    @Override
    public Batch<MapTile> toTileBatch(Rectangle region) {
        int count = this.length();
        int j = 0;
        Array acc = new Array(region.size().width() * region.size().height());
        for (int i = 0; i < count; ++i) {
            int index$proxy1 = i;
            if (!region.contains(package$package$.MODULE$.Point().apply(index$proxy1 % this.size().width(), index$proxy1 / this.size().width()))) continue;
            acc.update(j, (Object)MapTile$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)this._tiles.apply(i)), (RGBA)this._foreground.apply(i), (RGBA)this._background.apply(i)));
            ++j;
        }
        return package$package$.MODULE$.Batch().apply(acc);
    }

    @Override
    public Batch<Tuple2<Point, MapTile>> toPositionedBatch() {
        int count = this.length();
        Array acc = new Array(count);
        for (int i = 0; i < count; ++i) {
            int index$proxy2 = i;
            Point point = (Point)Predef$.MODULE$.ArrowAssoc((Object)package$package$.MODULE$.Point().apply(index$proxy2 % this.size().width(), index$proxy2 / this.size().width()));
            acc.update(i, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)point, (Object)MapTile$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)this._tiles.apply(i)), (RGBA)this._foreground.apply(i), (RGBA)this._background.apply(i))));
        }
        return package$package$.MODULE$.Batch().apply(acc);
    }

    @Override
    public Batch<Tuple2<Point, MapTile>> toPositionedBatch(Rectangle region) {
        int count = this.length();
        int j = 0;
        Array acc = new Array(region.size().width() * region.size().height());
        for (int i = 0; i < count; ++i) {
            int index$proxy3 = i;
            Point pt = package$package$.MODULE$.Point().apply(index$proxy3 % this.size().width(), index$proxy3 / this.size().width());
            if (!region.contains(pt)) continue;
            Point point = (Point)Predef$.MODULE$.ArrowAssoc((Object)pt);
            acc.update(j, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)point, (Object)MapTile$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)this._tiles.apply(i)), (RGBA)this._foreground.apply(i), (RGBA)this._background.apply(i))));
            ++j;
        }
        return package$package$.MODULE$.Batch().apply(acc);
    }

    @Override
    public RogueTerminalEmulator $bar$plus$bar(Terminal otherConsole) {
        return this.combine(otherConsole);
    }

    @Override
    public RogueTerminalEmulator combine(Terminal otherConsole) {
        return this.put(otherConsole.toPositionedBatch().filterNot((Function1 & Serializable)_$1 -> {
            Object object = _$1._2();
            MapTile mapTile = Terminal$.MODULE$.EmptyTile();
            return !(object != null ? !object.equals(mapTile) : mapTile != null);
        }));
    }

    @Override
    public RogueTerminalEmulator inset(Terminal otherConsole, Point offset) {
        return this.put(otherConsole.toPositionedBatch().filterNot((Function1 & Serializable)_$2 -> {
            Object object = _$2._2();
            MapTile mapTile = Terminal$.MODULE$.EmptyTile();
            return !(object != null ? !object.equals(mapTile) : mapTile != null);
        }), offset);
    }

    public TerminalEmulator toTerminalEmulator() {
        return TerminalEmulator$.MODULE$.apply(this.size()).inset(this, package$package$.MODULE$.Point().zero());
    }

    @Override
    public RogueTerminalEmulator modifyAt(Point position, Function1<MapTile, MapTile> modifier) {
        int idx = position.x() + position.y() * this.size().width();
        int t = BoxesRunTime.unboxToInt((Object)this._tiles.apply(idx));
        RGBA f = (RGBA)this._foreground.apply(idx);
        RGBA b = (RGBA)this._background.apply(idx);
        MapTile mt = (MapTile)modifier.apply((Object)MapTile$.MODULE$.apply(t, f, b));
        this.updateAt(idx, mt.char(), mt.foreground(), mt.background());
        return this;
    }

    @Override
    public RogueTerminalEmulator map(Function2<Point, MapTile, MapTile> modifier) {
        int count = this.length();
        for (int i = 0; i < count; ++i) {
            int t = BoxesRunTime.unboxToInt((Object)this._tiles.apply(i));
            RGBA f = (RGBA)this._foreground.apply(i);
            RGBA b = (RGBA)this._background.apply(i);
            int index$proxy4 = i;
            MapTile mt = (MapTile)modifier.apply((Object)package$package$.MODULE$.Point().apply(index$proxy4 % this.size().width(), index$proxy4 / this.size().width()), (Object)MapTile$.MODULE$.apply(t, f, b));
            this.updateAt(i, mt.char(), mt.foreground(), mt.background());
        }
        return this;
    }

    @Override
    public RogueTerminalEmulator mapRectangle(Rectangle region, Function2<Point, MapTile, MapTile> modifier) {
        int count = this.length();
        for (int i = 0; i < count; ++i) {
            int index$proxy5 = i;
            Point pos = package$package$.MODULE$.Point().apply(index$proxy5 % this.size().width(), index$proxy5 / this.size().width());
            if (!region.contains(pos)) continue;
            int t = BoxesRunTime.unboxToInt((Object)this._tiles.apply(i));
            RGBA f = (RGBA)this._foreground.apply(i);
            RGBA b = (RGBA)this._background.apply(i);
            MapTile mt = (MapTile)modifier.apply((Object)pos, (Object)MapTile$.MODULE$.apply(t, f, b));
            this.updateAt(i, mt.char(), mt.foreground(), mt.background());
        }
        return this;
    }

    @Override
    public RogueTerminalEmulator fillRectangle(Rectangle region, MapTile mapTile) {
        return this.mapRectangle(region, (Function2 & Serializable)(_$3, _$4) -> mapTile);
    }

    @Override
    public RogueTerminalEmulator fillRectangle(Rectangle region, int tile) {
        return this.mapRectangle(region, (Function2 & Serializable)(_$5, mt) -> mt.withChar(tile));
    }

    @Override
    public RogueTerminalEmulator fillRectangle(Rectangle region, int tile, RGBA foreground) {
        return this.mapRectangle(region, (Function2 & Serializable)(_$6, mt) -> MapTile$.MODULE$.apply(tile, foreground, mt.background()));
    }

    @Override
    public RogueTerminalEmulator fillRectangle(Rectangle region, int tile, RGBA foreground, RGBA background) {
        return this.mapRectangle(region, (Function2 & Serializable)(_$7, mt) -> MapTile$.MODULE$.apply(tile, foreground, background));
    }

    @Override
    public RogueTerminalEmulator mapCircle(Circle circle, Function2<Point, MapTile, MapTile> modifier) {
        int count = this.length();
        for (int i = 0; i < count; ++i) {
            int index$proxy6 = i;
            Point pos = package$package$.MODULE$.Point().apply(index$proxy6 % this.size().width(), index$proxy6 / this.size().width());
            if (!circle.contains(pos)) continue;
            int t = BoxesRunTime.unboxToInt((Object)this._tiles.apply(i));
            RGBA f = (RGBA)this._foreground.apply(i);
            RGBA b = (RGBA)this._background.apply(i);
            MapTile mt = (MapTile)modifier.apply((Object)pos, (Object)MapTile$.MODULE$.apply(t, f, b));
            this.updateAt(i, mt.char(), mt.foreground(), mt.background());
        }
        return this;
    }

    @Override
    public RogueTerminalEmulator fillCircle(Circle circle, MapTile mapTile) {
        return this.mapCircle(circle, (Function2 & Serializable)(_$8, _$9) -> mapTile);
    }

    @Override
    public RogueTerminalEmulator fillCircle(Circle circle, int tile) {
        return this.mapCircle(circle, (Function2 & Serializable)(_$10, mt) -> mt.withChar(tile));
    }

    @Override
    public RogueTerminalEmulator fillCircle(Circle circle, int tile, RGBA foreground) {
        return this.mapCircle(circle, (Function2 & Serializable)(_$11, mt) -> MapTile$.MODULE$.apply(tile, foreground, mt.background()));
    }

    @Override
    public RogueTerminalEmulator fillCircle(Circle circle, int tile, RGBA foreground, RGBA background) {
        return this.mapCircle(circle, (Function2 & Serializable)(_$12, mt) -> MapTile$.MODULE$.apply(tile, foreground, background));
    }

    @Override
    public RogueTerminalEmulator mapLine(Point from, Point to, Function2<Point, MapTile, MapTile> modifier) {
        Batch pts = Bresenham$.MODULE$.line(from, to);
        int count = this.length();
        for (int i = 0; i < count; ++i) {
            int index$proxy7 = i;
            Point pos = package$package$.MODULE$.Point().apply(index$proxy7 % this.size().width(), index$proxy7 / this.size().width());
            if (!pts.contains((Object)pos)) continue;
            int t = BoxesRunTime.unboxToInt((Object)this._tiles.apply(i));
            RGBA f = (RGBA)this._foreground.apply(i);
            RGBA b = (RGBA)this._background.apply(i);
            MapTile mt = (MapTile)modifier.apply((Object)pos, (Object)MapTile$.MODULE$.apply(t, f, b));
            this.updateAt(i, mt.char(), mt.foreground(), mt.background());
        }
        return this;
    }

    @Override
    public RogueTerminalEmulator mapLine(LineSegment line, Function2<Point, MapTile, MapTile> modifier) {
        return this.mapLine(line.start().toPoint(), line.end().toPoint(), (Function2)modifier);
    }

    @Override
    public RogueTerminalEmulator fillLine(LineSegment line, MapTile mapTile) {
        return this.mapLine(line.start().toPoint(), line.end().toPoint(), (Function2 & Serializable)(_$13, _$14) -> mapTile);
    }

    @Override
    public RogueTerminalEmulator fillLine(LineSegment line, int tile) {
        return this.mapLine(line.start().toPoint(), line.end().toPoint(), (Function2 & Serializable)(_$15, mt) -> mt.withChar(tile));
    }

    @Override
    public RogueTerminalEmulator fillLine(LineSegment line, int tile, RGBA foreground) {
        return this.mapLine(line.start().toPoint(), line.end().toPoint(), (Function2 & Serializable)(_$16, mt) -> MapTile$.MODULE$.apply(tile, foreground, mt.background()));
    }

    @Override
    public RogueTerminalEmulator fillLine(LineSegment line, int tile, RGBA foreground, RGBA background) {
        return this.mapLine(line.start().toPoint(), line.end().toPoint(), (Function2 & Serializable)(_$17, mt) -> MapTile$.MODULE$.apply(tile, foreground, background));
    }

    @Override
    public RogueTerminalEmulator fillLine(Point from, Point to, MapTile mapTile) {
        return this.mapLine(from, to, (Function2 & Serializable)(_$18, _$19) -> mapTile);
    }

    @Override
    public RogueTerminalEmulator fillLine(Point from, Point to, int tile) {
        return this.mapLine(from, to, (Function2 & Serializable)(_$20, mt) -> mt.withChar(tile));
    }

    @Override
    public RogueTerminalEmulator fillLine(Point from, Point to, int tile, RGBA foreground) {
        return this.mapLine(from, to, (Function2 & Serializable)(_$21, mt) -> MapTile$.MODULE$.apply(tile, foreground, mt.background()));
    }

    @Override
    public RogueTerminalEmulator fillLine(Point from, Point to, int tile, RGBA foreground, RGBA background) {
        return this.mapLine(from, to, (Function2 & Serializable)(_$22, mt) -> MapTile$.MODULE$.apply(tile, foreground, background));
    }

    public String toASCII(char nullReplacement) {
        Array array = Any$.MODULE$.jsArrayOps(this._tiles);
        Array array2 = Any$.MODULE$.jsArrayOps(ArrayOps$.MODULE$.map$extension(array, (Function1 & Serializable)_$23 -> Tile$package$Tile$.MODULE$.toInt(BoxesRunTime.unboxToInt((Object)_$23))));
        Array array3 = Any$.MODULE$.jsArrayOps(ArrayOps$.MODULE$.map$extension(array2, (Function1 & Serializable)x$1 -> RogueTerminalEmulator.toASCII$$anonfun$2(nullReplacement, BoxesRunTime.unboxToInt((Object)x$1))));
        return ArrayOps$.MODULE$.sliding$extension(array3, this.size().width(), this.size().width()).map((Function1 & Serializable)_$24 -> Any$.MODULE$.wrapArray(_$24).mkString()).mkString("\n");
    }

    public String toASCII() {
        return this.toASCII(' ');
    }

    private final /* synthetic */ void put$$anonfun$1(Tuple2 t) {
        int idx = ((Point)t._1()).x() + ((Point)t._1()).y() * this.size().width();
        MapTile tt = (MapTile)t._2();
        this.updateAt(idx, tt.char(), tt.foreground(), tt.background());
    }

    private final /* synthetic */ void put$$anonfun$2(Point offset$1, Tuple2 t) {
        Point point$proxy1 = ((Point)t._1()).$plus(offset$1);
        int idx = point$proxy1.x() + point$proxy1.y() * this.size().width();
        MapTile tt = (MapTile)t._2();
        this.updateAt(idx, tt.char(), tt.foreground(), tt.background());
    }

    private final /* synthetic */ void putLine$$anonfun$1(Point startCoords$1, RGBA foregroundColor$1, RGBA backgroundColor$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int t = BoxesRunTime.unboxToInt((Object)tuple2._1());
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Point point$proxy2 = startCoords$1.$plus(package$package$.MODULE$.Point().apply(i, 0));
            this.updateAt(point$proxy2.x() + point$proxy2.y() * this.size().width(), t, foregroundColor$1, backgroundColor$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final RogueTerminalEmulator rec$1(Point startCoords$2, RGBA foregroundColor$2, RGBA backgroundColor$2, List remaining, int yOffset, RogueTerminalEmulator term) {
        List list;
        while (true) {
            List xs;
            list = remaining;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return term;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next();
            String x = (String)colon2.head();
            List list4 = xs = list3;
            int n = yOffset + 1;
            RogueTerminalEmulator rogueTerminalEmulator = term.putLine(startCoords$2.$plus(package$package$.MODULE$.Point().apply(0, yOffset)), x, foregroundColor$2, backgroundColor$2);
            remaining = list4;
            yOffset = n;
            term = rogueTerminalEmulator;
        }
        throw new MatchError((Object)list);
    }

    private final /* synthetic */ void putTileLine$$anonfun$1(Point startCoords$3, RGBA foregroundColor$3, RGBA backgroundColor$3, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int t = BoxesRunTime.unboxToInt((Object)tuple2._1());
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Point point$proxy3 = startCoords$3.$plus(package$package$.MODULE$.Point().apply(i, 0));
            this.updateAt(point$proxy3.x() + point$proxy3.y() * this.size().width(), t, foregroundColor$3, backgroundColor$3);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final RogueTerminalEmulator rec$2(Point startCoords$4, RGBA foregroundColor$4, RGBA backgroundColor$4, List remaining, int yOffset, RogueTerminalEmulator term) {
        List list;
        while (true) {
            List xs;
            list = remaining;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return term;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next();
            Batch x = (Batch)colon2.head();
            List list4 = xs = list3;
            int n = yOffset + 1;
            RogueTerminalEmulator rogueTerminalEmulator = term.putTileLine(startCoords$4.$plus(package$package$.MODULE$.Point().apply(0, yOffset)), (Batch<Object>)x, foregroundColor$4, backgroundColor$4);
            remaining = list4;
            yOffset = n;
            term = rogueTerminalEmulator;
        }
        throw new MatchError((Object)list);
    }

    private static final /* synthetic */ char toASCII$$anonfun$2(char nullReplacement$1, int x$1) {
        int n = x$1;
        if (0 == n) {
            return nullReplacement$1;
        }
        int c = n;
        return (char)c;
    }
}

