/*
 * Decompiled with CFR 0.152.
 */
package io.indigoengine.roguelike.starterkit.utils;

import indigo.shared.collections.Batch;
import indigo.shared.datatypes.Point;
import indigo.shared.datatypes.Size;
import indigo.shared.dice.Dice;
import io.indigoengine.roguelike.starterkit.utils.GridSquare;
import io.indigoengine.roguelike.starterkit.utils.PathFinder$;
import java.io.Serializable;
import scala.Function1;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class PathFinder
implements Product,
Serializable {
    private final Size size;
    private final Batch grid;

    public static PathFinder apply(Size size, Batch<GridSquare> batch) {
        return PathFinder$.MODULE$.apply(size, batch);
    }

    public static PathFinder fromImpassable(Size size, Batch<Point> batch) {
        return PathFinder$.MODULE$.fromImpassable(size, batch);
    }

    public static PathFinder fromProduct(Product product) {
        return PathFinder$.MODULE$.fromProduct(product);
    }

    public static PathFinder fromWalkable(Size size, Batch<Point> batch) {
        return PathFinder$.MODULE$.fromWalkable(size, batch);
    }

    public static Batch<GridSquare> sampleAt(PathFinder pathFinder, Point point, int n) {
        return PathFinder$.MODULE$.sampleAt(pathFinder, point, n);
    }

    public static Batch<GridSquare> scoreGridSquares(Point point, Point point2, PathFinder pathFinder, Function1<GridSquare, Object> function1) {
        return PathFinder$.MODULE$.scoreGridSquares(point, point2, pathFinder, function1);
    }

    public static PathFinder unapply(PathFinder pathFinder) {
        return PathFinder$.MODULE$.unapply(pathFinder);
    }

    public PathFinder(Size size, Batch<GridSquare> grid) {
        this.size = size;
        this.grid = grid;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof PathFinder)) return false;
        PathFinder pathFinder = (PathFinder)object;
        Size size = this.size();
        Size size2 = pathFinder.size();
        if (size == null) {
            if (size2 != null) {
                return false;
            }
        } else if (!size.equals(size2)) return false;
        Batch<GridSquare> batch = this.grid();
        Batch<GridSquare> batch2 = pathFinder.grid();
        if (batch == null) {
            if (batch2 == null) return true;
            return false;
        } else {
            if (!batch.equals(batch2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof PathFinder;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "PathFinder";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "size";
        }
        if (1 == n2) {
            return "grid";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Size size() {
        return this.size;
    }

    public Batch<GridSquare> grid() {
        return this.grid;
    }

    public boolean contains(Point coords) {
        return coords.x() >= 0 && coords.y() >= 0 && coords.x() < this.size().width() && coords.y() < this.size().height();
    }

    public Batch<Point> locatePath(Dice dice, Point start, Point end, Function1<GridSquare, Object> scoreAmount) {
        Batch<GridSquare> batch = PathFinder$.MODULE$.scoreGridSquares(start, end, this, scoreAmount);
        Size size = this.copy$default$1();
        return PathFinder$.MODULE$.locatePath(dice, start, end, this.copy(size, batch));
    }

    public PathFinder copy(Size size, Batch<GridSquare> grid) {
        return new PathFinder(size, grid);
    }

    public Size copy$default$1() {
        return this.size();
    }

    public Batch<GridSquare> copy$default$2() {
        return this.grid();
    }

    public Size _1() {
        return this.size();
    }

    public Batch<GridSquare> _2() {
        return this.grid();
    }
}

