/*
 * Decompiled with CFR 0.152.
 */
package io.indigoengine.roguelike.starterkit.utils;

import indigo.shared.collections.Batch;
import indigo.shared.collections.Batch$;
import indigo.shared.datatypes.Point;
import indigo.shared.datatypes.Size;
import indigo.shared.dice.Dice;
import io.indigoengine.roguelike.starterkit.utils.Coords$;
import io.indigoengine.roguelike.starterkit.utils.GridSquare;
import io.indigoengine.roguelike.starterkit.utils.GridSquare$;
import io.indigoengine.roguelike.starterkit.utils.GridSquare$Blocked$;
import io.indigoengine.roguelike.starterkit.utils.GridSquare$Walkable$;
import io.indigoengine.roguelike.starterkit.utils.PathFinder;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class PathFinder$
implements Mirror.Product,
Serializable {
    public static final PathFinder$ MODULE$ = new PathFinder$();

    private PathFinder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PathFinder$.class);
    }

    public PathFinder apply(Size size, Batch<GridSquare> grid) {
        return new PathFinder(size, grid);
    }

    public PathFinder unapply(PathFinder x$1) {
        return x$1;
    }

    public String toString() {
        return "PathFinder";
    }

    public Batch<GridSquare> sampleAt(PathFinder searchGrid, Point coords, int gridWidth) {
        return Batch$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Point[]{coords.$plus(Coords$.MODULE$.relativeUp()), coords.$plus(Coords$.MODULE$.relativeLeft()), coords.$plus(Coords$.MODULE$.relativeRight()), coords.$plus(Coords$.MODULE$.relativeDown())})).filter((Function1 & Serializable)c -> searchGrid.contains((Point)c)).map((Function1 & Serializable)c -> (GridSquare)searchGrid.grid().apply(Coords$.MODULE$.toGridPosition((Point)c, gridWidth)));
    }

    public PathFinder fromImpassable(Size size, Batch<Point> impassable) {
        Batch grid = Batch$.MODULE$.fromIndexedSeq((IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size.width() * size.height())).map((Function1 & Serializable)index -> this.$anonfun$1(size, impassable, BoxesRunTime.unboxToInt((Object)index)));
        return this.apply(size, (Batch<GridSquare>)grid);
    }

    public PathFinder fromWalkable(Size size, Batch<Point> walkable) {
        Batch grid = Batch$.MODULE$.fromIndexedSeq((IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size.width() * size.height())).map((Function1 & Serializable)index -> this.$anonfun$2(size, walkable, BoxesRunTime.unboxToInt((Object)index)));
        return this.apply(size, (Batch<GridSquare>)grid);
    }

    public Batch<GridSquare> scoreGridSquares(Point start, Point end, PathFinder searchGrid, Function1<GridSquare, Object> scoreAmount) {
        Tuple2 tuple2 = searchGrid.grid().partition((Function1 & Serializable)_$4 -> {
            Point point = _$4.coords();
            Point point2 = end;
            return !(point != null ? !point.equals(point2) : point2 != null);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Batch done = (Batch)tuple2._1();
        Batch todo = (Batch)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)done, (Object)todo);
        Batch done2 = (Batch)tuple22._1();
        Batch todo2 = (Batch)tuple22._2();
        return this.rec$1(searchGrid, scoreAmount, start, todo2, 0, Batch$.MODULE$.apply((Object)end), done2.map((Function1 & Serializable)_$5 -> _$5.withScore(0))).sortBy((Function1 & Serializable)_$6 -> _$6.index(), (Ordering)Ordering.Int$.MODULE$);
    }

    public Batch<Point> locatePath(Dice dice, Point start, Point end, PathFinder searchGrid) {
        int width = searchGrid.size().width();
        return this.rec$2(dice, end, searchGrid, width, start, GridSquare$.MODULE$.Max(), Batch$.MODULE$.apply((Object)start));
    }

    public PathFinder fromProduct(Product x$0) {
        return new PathFinder((Size)x$0.productElement(0), (Batch<GridSquare>)((Batch)x$0.productElement(1)));
    }

    private final /* synthetic */ GridSquare $anonfun$1(Size size$2, Batch impassable$1, int index) {
        Product product;
        Point point = Coords$.MODULE$.fromIndex(index, size$2.width());
        if (point != null) {
            Point point2 = point;
            Point c = point2;
            if (impassable$1.contains((Object)c)) {
                product = GridSquare$Blocked$.MODULE$.apply(index, c);
            } else {
                Point c2 = point2;
                product = GridSquare$Walkable$.MODULE$.apply(index, c2, -1);
            }
        } else {
            throw new MatchError((Object)point);
        }
        return product;
    }

    private final /* synthetic */ GridSquare $anonfun$2(Size size$3, Batch walkable$1, int index) {
        Product product;
        Point point = Coords$.MODULE$.fromIndex(index, size$3.width());
        if (point != null) {
            Point point2 = point;
            Point c = point2;
            if (walkable$1.contains((Object)c)) {
                product = GridSquare$Walkable$.MODULE$.apply(index, c, -1);
            } else {
                Point c2 = point2;
                product = GridSquare$Blocked$.MODULE$.apply(index, c2);
            }
        } else {
            throw new MatchError((Object)point);
        }
        return product;
    }

    private final Batch rec$1(PathFinder searchGrid$3, Function1 scoreAmount$1, Point target, Batch unscored, int scoreValue, Batch lastCoords, Batch scored) {
        Tuple2 tuple2;
        while ((tuple2 = Tuple2$.MODULE$.apply((Object)unscored, (Object)lastCoords)) != null) {
            Batch batch = (Batch)tuple2._1();
            Batch batch2 = (Batch)tuple2._2();
            Batch a = batch;
            Batch b = batch2;
            if (a.isEmpty() || b.isEmpty()) {
                return scored.$plus$plus(unscored);
            }
            Batch last = batch2;
            if (last.exists((Function1 & Serializable)_$1 -> {
                Point point = _$1;
                Point point2 = target;
                return !(point != null ? !point.equals(point2) : point2 != null);
            })) {
                return scored.$plus$plus(unscored);
            }
            Batch remainingSquares = batch;
            Batch lastScoredLocations = batch2;
            Batch roughEdges = lastScoredLocations.map((Function1 & Serializable)c -> this.sampleAt(searchGrid$3, (Point)c, searchGrid$3.size().width()));
            Batch edges = roughEdges.flatMap((Function1 & Serializable)_$2 -> _$2.filter((Function1 & Serializable)c -> remainingSquares.contains(c)));
            Batch next = ((Batch)edges.foldLeft((Object)Batch$.MODULE$.empty(), (Function2 & Serializable)(l, x) -> {
                if (l.exists((Function1 & Serializable)p -> {
                    Point point = p.coords();
                    Point point2 = x.coords();
                    return !(point != null ? !point.equals(point2) : point2 != null);
                })) {
                    return l;
                }
                return l.$plus$plus(Batch$.MODULE$.apply(x));
            })).map((Function1 & Serializable)gs -> gs.withScore(scoreValue + BoxesRunTime.unboxToInt((Object)scoreAmount$1.apply(gs))));
            Batch batch3 = remainingSquares.filterNot((Function1 & Serializable)p -> next.exists((Function1 & Serializable)q -> {
                Point point = q.coords();
                Point point2 = p.coords();
                return !(point != null ? !point.equals(point2) : point2 != null);
            }));
            int n = scoreValue + 1;
            Batch batch4 = next.map((Function1 & Serializable)_$3 -> _$3.coords());
            Batch batch5 = next.$plus$plus(scored);
            unscored = batch3;
            scoreValue = n;
            lastCoords = batch4;
            scored = batch5;
        }
        throw new MatchError((Object)tuple2);
    }

    private final Batch rec$2(Dice dice$1, Point end$2, PathFinder searchGrid$5, int width$1, Point currentPosition, int currentScore, Batch acc) {
        while (true) {
            Point point = currentPosition;
            Point point2 = end$2;
            if (!(point != null ? !point.equals(point2) : point2 != null)) {
                return acc;
            }
            Batch squares = this.sampleAt(searchGrid$5, currentPosition, width$1).filter((Function1 & Serializable)c -> c.score() != -1 && c.score() < currentScore);
            if (squares.isEmpty()) {
                return acc;
            }
            if (squares.size() == 1) {
                GridSquare next = (GridSquare)squares.head();
                Point point3 = next.coords();
                int n = next.score();
                Batch batch = acc.$plus$plus(Batch$.MODULE$.apply((Object)next.coords()));
                currentPosition = point3;
                currentScore = n;
                acc = batch;
                continue;
            }
            GridSquare next = (GridSquare)squares.apply(dice$1.rollFromZero(squares.length() - 1));
            Point point4 = next.coords();
            int n = next.score();
            Batch batch = acc.$plus$plus(Batch$.MODULE$.apply((Object)next.coords()));
            currentPosition = point4;
            currentScore = n;
            acc = batch;
        }
    }
}

