/*
 * Decompiled with CFR 0.152.
 */
package io.indigoengine.roguelike.starterkit.terminal;

import indigo.package$package$;
import indigo.shared.collections.Batch;
import indigo.shared.collections.Batch$;
import indigo.shared.datatypes.Flip;
import indigo.shared.datatypes.Point;
import indigo.shared.datatypes.RGB;
import indigo.shared.datatypes.RGBA;
import indigo.shared.datatypes.Size;
import indigo.shared.datatypes.Vector2;
import indigo.shared.events.GlobalEvent;
import indigo.shared.materials.ShaderData;
import indigo.shared.materials.ShaderData$;
import indigo.shared.scenegraph.EntityNode;
import indigo.shared.shader.ShaderPrimitive;
import indigo.shared.shader.UltravioletShader;
import indigo.shared.shader.UniformBlock;
import indigo.shared.shader.UniformBlock$;
import indigo.shared.shader.UniformBlock$package$;
import io.indigoengine.roguelike.starterkit.terminal.MapTile;
import io.indigoengine.roguelike.starterkit.terminal.TerminalEntity$;
import io.indigoengine.roguelike.starterkit.tiles.Tile$package$Tile$;
import java.io.Serializable;
import scala.Array$;
import scala.Function$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.scalajs.js.Array;

public final class TerminalEntity
implements EntityNode<TerminalEntity>,
Product,
Serializable {
    private final String tileSheet;
    private final Size gridSize;
    private final Size charSize;
    private final RGBA mask;
    private final Batch map;
    private final Point position;
    private final int depth;
    private final int maxTileCount;
    private final Batch<Object> emptyColors;
    private Array fgArray$lzy1;
    private boolean fgArraybitmap$1;
    private Array bgArray$lzy1;
    private boolean bgArraybitmap$1;

    public static TerminalEntity apply(String string, Size size, Size size2, Batch<MapTile> batch, int n) {
        return TerminalEntity$.MODULE$.apply(string, size, size2, batch, n);
    }

    public static TerminalEntity apply(String string, Size size, Size size2, int n) {
        return TerminalEntity$.MODULE$.apply(string, size, size2, n);
    }

    public static TerminalEntity apply(String string, Size size, Size size2, RGBA rGBA, Batch<MapTile> batch, Point point, int n, int n2) {
        return TerminalEntity$.MODULE$.apply(string, size, size2, rGBA, batch, point, n, n2);
    }

    public static TerminalEntity fromProduct(Product product) {
        return TerminalEntity$.MODULE$.fromProduct(product);
    }

    public static UltravioletShader shader(int n) {
        return TerminalEntity$.MODULE$.shader(n);
    }

    public static String shaderId() {
        return TerminalEntity$.MODULE$.shaderId();
    }

    public static TerminalEntity unapply(TerminalEntity terminalEntity) {
        return TerminalEntity$.MODULE$.unapply(terminalEntity);
    }

    public TerminalEntity(String tileSheet, Size gridSize, Size charSize, RGBA mask, Batch<MapTile> map, Point position, int depth, int maxTileCount) {
        this.tileSheet = tileSheet;
        this.gridSize = gridSize;
        this.charSize = charSize;
        this.mask = mask;
        this.map = map;
        this.position = position;
        this.depth = depth;
        this.maxTileCount = maxTileCount;
        int count = gridSize.width() * gridSize.height();
        this.emptyColors = package$package$.MODULE$.Batch().fromArray(Array$.MODULE$.fill((maxTileCount - count) * 4, TerminalEntity::$init$$$anonfun$1, ClassTag$.MODULE$.apply(Float.TYPE)));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tileSheet()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.gridSize()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.charSize()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.mask()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.map()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.position()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)BoxesRunTime.boxToInteger((int)this.depth())));
        n = Statics.mix((int)n, (int)this.maxTileCount());
        return Statics.finalizeHash((int)n, (int)8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TerminalEntity)) return false;
        TerminalEntity terminalEntity = (TerminalEntity)object;
        if (this.maxTileCount() != terminalEntity.maxTileCount()) return false;
        String string = this.tileSheet();
        String string2 = terminalEntity.tileSheet();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Size size = this.gridSize();
        Size size2 = terminalEntity.gridSize();
        if (size == null) {
            if (size2 != null) {
                return false;
            }
        } else if (!size.equals(size2)) return false;
        Size size3 = this.charSize();
        Size size4 = terminalEntity.charSize();
        if (size3 == null) {
            if (size4 != null) {
                return false;
            }
        } else if (!size3.equals(size4)) return false;
        RGBA rGBA = this.mask();
        RGBA rGBA2 = terminalEntity.mask();
        if (rGBA == null) {
            if (rGBA2 != null) {
                return false;
            }
        } else if (!rGBA.equals(rGBA2)) return false;
        Batch<MapTile> batch = this.map();
        Batch<MapTile> batch2 = terminalEntity.map();
        if (batch == null) {
            if (batch2 != null) {
                return false;
            }
        } else if (!batch.equals(batch2)) return false;
        Point point = this.position();
        Point point2 = terminalEntity.position();
        if (point == null) {
            if (point2 != null) {
                return false;
            }
        } else if (!point.equals(point2)) return false;
        if (this.depth() != terminalEntity.depth()) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TerminalEntity;
    }

    public int productArity() {
        return 8;
    }

    public String productPrefix() {
        return "TerminalEntity";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return BoxesRunTime.boxToInteger((int)this._7());
            }
            case 7: {
                return BoxesRunTime.boxToInteger((int)this._8());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "tileSheet";
            }
            case 1: {
                return "gridSize";
            }
            case 2: {
                return "charSize";
            }
            case 3: {
                return "mask";
            }
            case 4: {
                return "map";
            }
            case 5: {
                return "position";
            }
            case 6: {
                return "depth";
            }
            case 7: {
                return "maxTileCount";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String tileSheet() {
        return this.tileSheet;
    }

    public Size gridSize() {
        return this.gridSize;
    }

    public Size charSize() {
        return this.charSize;
    }

    public RGBA mask() {
        return this.mask;
    }

    public Batch<MapTile> map() {
        return this.map;
    }

    public Point position() {
        return this.position;
    }

    public int depth() {
        return this.depth;
    }

    public int maxTileCount() {
        return this.maxTileCount;
    }

    public Flip flip() {
        return package$package$.MODULE$.Flip().default();
    }

    public Point ref() {
        return package$package$.MODULE$.Point().zero();
    }

    public double rotation() {
        return package$package$.MODULE$.Radians().zero();
    }

    public Vector2 scale() {
        return package$package$.MODULE$.Vector2().one();
    }

    public Size size() {
        return this.gridSize().$times(this.charSize());
    }

    public TerminalEntity moveTo(Point pt) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), pt, this.copy$default$7(), this.copy$default$8());
    }

    public TerminalEntity moveTo(int x, int y) {
        return this.moveTo(package$package$.MODULE$.Point().apply(x, y));
    }

    public TerminalEntity withPosition(Point newPosition) {
        return this.moveTo(newPosition);
    }

    public TerminalEntity moveBy(Point pt) {
        Point point = this.position().$plus(pt);
        String string = this.copy$default$1();
        Size size = this.copy$default$2();
        Size size2 = this.copy$default$3();
        RGBA rGBA = this.copy$default$4();
        Batch<MapTile> batch = this.copy$default$5();
        int n = this.copy$default$7();
        int n2 = this.copy$default$8();
        return this.copy(string, size, size2, rGBA, batch, point, n, n2);
    }

    public TerminalEntity moveBy(int x, int y) {
        return this.moveBy(package$package$.MODULE$.Point().apply(x, y));
    }

    public TerminalEntity withTileSheet(String newTileSheet) {
        return this.copy(newTileSheet, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public TerminalEntity withGridSize(Size newGridSize) {
        return this.copy(this.copy$default$1(), newGridSize, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public TerminalEntity withCharSize(Size newCharSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), newCharSize, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public TerminalEntity withMask(RGBA newColor) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), newColor, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public TerminalEntity withMask(RGB newColor) {
        RGBA rGBA = newColor.toRGBA();
        String string = this.copy$default$1();
        Size size = this.copy$default$2();
        Size size2 = this.copy$default$3();
        Batch<MapTile> batch = this.copy$default$5();
        Point point = this.copy$default$6();
        int n = this.copy$default$7();
        int n2 = this.copy$default$8();
        return this.copy(string, size, size2, rGBA, batch, point, n, n2);
    }

    public TerminalEntity withMap(Batch<MapTile> newMap) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), newMap, this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public TerminalEntity withDepth(int newDepth) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), newDepth, this.copy$default$8());
    }

    private Array<Object> fgArray() {
        if (!this.fgArraybitmap$1) {
            this.fgArray$lzy1 = this.map().flatMap((Function1 & Serializable)t -> {
                RGBA color = t.foreground();
                return package$package$.MODULE$.Batch().apply((Seq)ScalaRunTime$.MODULE$.wrapFloatArray(new float[]{Tile$package$Tile$.MODULE$.toFloat(t.char()), (float)color.r(), (float)color.g(), (float)color.b()}));
            }).$plus$plus(this.emptyColors).toJSArray();
            this.fgArraybitmap$1 = true;
        }
        return this.fgArray$lzy1;
    }

    private Array<Object> bgArray() {
        if (!this.bgArraybitmap$1) {
            this.bgArray$lzy1 = this.map().flatMap((Function1 & Serializable)t -> {
                RGBA color = t.background();
                return package$package$.MODULE$.Batch().apply((Seq)ScalaRunTime$.MODULE$.wrapFloatArray(new float[]{(float)color.r(), (float)color.g(), (float)color.b(), (float)color.a()}));
            }).$plus$plus(this.emptyColors).toJSArray();
            this.bgArraybitmap$1 = true;
        }
        return this.bgArray$lzy1;
    }

    public ShaderData toShaderData() {
        UniformBlock$package$ uniformBlock$package$;
        UniformBlock$package$ uniformBlock$package$2;
        UniformBlock$package$ uniformBlock$package$3;
        UniformBlock$package$ uniformBlock$package$4;
        UniformBlock$package$ uniformBlock$package$5;
        UniformBlock$package$ uniformBlock$package$6;
        UniformBlock$package$ uniformBlock$package$7;
        ShaderData$ shaderData$ = package$package$.MODULE$.ShaderData();
        String string = TerminalEntity$.MODULE$.shaderId();
        Object[] objectArray = new UniformBlock[3];
        UniformBlock$ uniformBlock$ = package$package$.MODULE$.UniformBlock();
        UniformBlock$package$ UniformBlock$package$_this = uniformBlock$package$7 = UniformBlock$package$.MODULE$;
        Batch$ batch$ = package$package$.MODULE$.Batch();
        Object[] objectArray2 = new Tuple2[2];
        UniformBlock$package$ UniformBlock$package$_this2 = uniformBlock$package$6 = UniformBlock$package$.MODULE$;
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"GRID_DIMENSIONS_CHAR_SIZE");
        package$package$.MODULE$.ShaderPrimitive();
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)ShaderPrimitive.vec4$.MODULE$.apply((float)this.gridSize().width(), (float)this.gridSize().height(), (float)this.charSize().width(), (float)this.charSize().height()));
        UniformBlock$package$ UniformBlock$package$_this3 = uniformBlock$package$5 = UniformBlock$package$.MODULE$;
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"MASK");
        package$package$.MODULE$.ShaderPrimitive();
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)ShaderPrimitive.vec4$.MODULE$.apply(this.mask().r(), this.mask().g(), this.mask().b(), this.mask().a()));
        objectArray[0] = uniformBlock$.apply("RogueLikeData", batch$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        UniformBlock$ uniformBlock$2 = package$package$.MODULE$.UniformBlock();
        UniformBlock$package$ UniformBlock$package$_this4 = uniformBlock$package$4 = UniformBlock$package$.MODULE$;
        Batch$ batch$2 = package$package$.MODULE$.Batch();
        UniformBlock$package$ UniformBlock$package$_this5 = uniformBlock$package$3 = UniformBlock$package$.MODULE$;
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"CHAR_FOREGROUND");
        package$package$.MODULE$.ShaderPrimitive();
        objectArray[1] = uniformBlock$2.apply("RogueLikeMapForeground", batch$2.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)ShaderPrimitive.rawJSArray$.MODULE$.apply(this.fgArray()))));
        UniformBlock$ uniformBlock$3 = package$package$.MODULE$.UniformBlock();
        UniformBlock$package$ UniformBlock$package$_this6 = uniformBlock$package$2 = UniformBlock$package$.MODULE$;
        Batch$ batch$3 = package$package$.MODULE$.Batch();
        UniformBlock$package$ UniformBlock$package$_this7 = uniformBlock$package$ = UniformBlock$package$.MODULE$;
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"BACKGROUND");
        package$package$.MODULE$.ShaderPrimitive();
        objectArray[2] = uniformBlock$3.apply("RogueLikeMapBackground", batch$3.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)ShaderPrimitive.rawJSArray$.MODULE$.apply(this.bgArray()))));
        return shaderData$.apply(string, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).withChannel0(this.tileSheet());
    }

    public Function1<Tuple2<TerminalEntity, GlobalEvent>, Option<GlobalEvent>> eventHandler() {
        None$ none$ = None$.MODULE$;
        return (Function1 & Serializable)y -> (Option)Function$.MODULE$.const((Object)none$, y);
    }

    public boolean eventHandlerEnabled() {
        return false;
    }

    public TerminalEntity copy(String tileSheet, Size gridSize, Size charSize, RGBA mask, Batch<MapTile> map, Point position, int depth, int maxTileCount) {
        return new TerminalEntity(tileSheet, gridSize, charSize, mask, map, position, depth, maxTileCount);
    }

    public String copy$default$1() {
        return this.tileSheet();
    }

    public Size copy$default$2() {
        return this.gridSize();
    }

    public Size copy$default$3() {
        return this.charSize();
    }

    public RGBA copy$default$4() {
        return this.mask();
    }

    public Batch<MapTile> copy$default$5() {
        return this.map();
    }

    public Point copy$default$6() {
        return this.position();
    }

    public int copy$default$7() {
        return this.depth();
    }

    public int copy$default$8() {
        return this.maxTileCount();
    }

    public String _1() {
        return this.tileSheet();
    }

    public Size _2() {
        return this.gridSize();
    }

    public Size _3() {
        return this.charSize();
    }

    public RGBA _4() {
        return this.mask();
    }

    public Batch<MapTile> _5() {
        return this.map();
    }

    public Point _6() {
        return this.position();
    }

    public int _7() {
        return this.depth();
    }

    public int _8() {
        return this.maxTileCount();
    }

    private static final float $init$$$anonfun$1() {
        return 0.0f;
    }
}

