/*
 * Decompiled with CFR 0.152.
 */
package io.indigoengine.roguelike.starterkit.terminal;

import indigo.shared.collections.Batch;
import indigo.shared.datatypes.Point;
import indigo.shared.datatypes.RGBA;
import indigo.shared.datatypes.Size;
import indigo.shared.geometry.BoundingBox;
import indigo.shared.scenegraph.CloneBlank;
import indigo.shared.scenegraph.CloneBlank$package$;
import indigo.shared.scenegraph.CloneTileData;
import indigo.shared.scenegraph.CloneTiles;
import indigo.shared.scenegraph.Cloneable;
import indigoextras.trees.QuadTree;
import indigoextras.trees.QuadTree$;
import io.indigoengine.roguelike.starterkit.package$package$;
import io.indigoengine.roguelike.starterkit.terminal.MapTile;
import io.indigoengine.roguelike.starterkit.terminal.MapTile$;
import io.indigoengine.roguelike.starterkit.terminal.TerminalClones;
import io.indigoengine.roguelike.starterkit.terminal.TerminalClones$;
import io.indigoengine.roguelike.starterkit.terminal.TerminalEmulator$;
import io.indigoengine.roguelike.starterkit.terminal.TerminalEntity;
import io.indigoengine.roguelike.starterkit.terminal.TerminalEntity$;
import io.indigoengine.roguelike.starterkit.tiles.Tile$package$;
import io.indigoengine.roguelike.starterkit.tiles.Tile$package$Tile$;
import java.io.Serializable;
import scala.CanEqual$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class TerminalEmulator
implements Product,
Serializable {
    private final Size screenSize;
    private final QuadTree charMap;
    private final Batch<Point> coordsBatch;

    public static TerminalEmulator apply(Size size) {
        return TerminalEmulator$.MODULE$.apply(size);
    }

    public static TerminalEmulator apply(Size size, QuadTree<MapTile> quadTree) {
        return TerminalEmulator$.MODULE$.apply(size, quadTree);
    }

    public static TerminalEmulator fromProduct(Product product) {
        return TerminalEmulator$.MODULE$.fromProduct(product);
    }

    public static TerminalEmulator unapply(TerminalEmulator terminalEmulator) {
        return TerminalEmulator$.MODULE$.unapply(terminalEmulator);
    }

    public TerminalEmulator(Size screenSize, QuadTree<MapTile> charMap) {
        this.screenSize = screenSize;
        this.charMap = charMap;
        this.coordsBatch = indigo.package$package$.MODULE$.Batch().fromIndexedSeq((IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), screenSize.height()).flatMap((Function1 & Serializable)y -> TerminalEmulator.$init$$$anonfun$1(screenSize, BoxesRunTime.unboxToInt((Object)y))));
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TerminalEmulator)) return false;
        TerminalEmulator terminalEmulator = (TerminalEmulator)object;
        Size size = this.screenSize();
        Size size2 = terminalEmulator.screenSize();
        if (size == null) {
            if (size2 != null) {
                return false;
            }
        } else if (!size.equals(size2)) return false;
        QuadTree<MapTile> quadTree = this.charMap();
        QuadTree<MapTile> quadTree2 = terminalEmulator.charMap();
        if (quadTree == null) {
            if (quadTree2 == null) return true;
            return false;
        } else {
            if (!quadTree.equals(quadTree2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TerminalEmulator;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "TerminalEmulator";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "screenSize";
        }
        if (1 == n2) {
            return "charMap";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Size screenSize() {
        return this.screenSize;
    }

    public QuadTree<MapTile> charMap() {
        return this.charMap;
    }

    public TerminalEmulator put(Point coords, int tile, RGBA fgColor, RGBA bgColor) {
        QuadTree quadTree = this.charMap().insertElement((Object)MapTile$.MODULE$.apply(tile, fgColor, bgColor), indigo.package$package$.MODULE$.Vertex().fromPoint(coords));
        Size size = this.copy$default$1();
        return this.copy(size, (QuadTree<MapTile>)quadTree);
    }

    public TerminalEmulator put(Point coords, int tile, RGBA fgColor) {
        QuadTree quadTree = this.charMap().insertElement((Object)MapTile$.MODULE$.apply(tile, fgColor), indigo.package$package$.MODULE$.Vertex().fromPoint(coords));
        Size size = this.copy$default$1();
        return this.copy(size, (QuadTree<MapTile>)quadTree);
    }

    public TerminalEmulator put(Point coords, int tile) {
        QuadTree quadTree = this.charMap().insertElement((Object)MapTile$.MODULE$.apply(tile), indigo.package$package$.MODULE$.Vertex().fromPoint(coords));
        Size size = this.copy$default$1();
        return this.copy(size, (QuadTree<MapTile>)quadTree);
    }

    public TerminalEmulator put(Batch<Tuple2<Point, MapTile>> tiles) {
        QuadTree quadTree = this.charMap().insertElements(tiles.map((Function1 & Serializable)p -> Tuple2$.MODULE$.apply(p._2(), (Object)indigo.package$package$.MODULE$.Vertex().fromPoint((Point)p._1()))));
        Size size = this.copy$default$1();
        return this.copy(size, (QuadTree<MapTile>)quadTree);
    }

    public TerminalEmulator put(Seq<Tuple2<Point, MapTile>> tiles) {
        return this.put((Batch<Tuple2<Point, MapTile>>)indigo.package$package$.MODULE$.Batch().fromSeq(tiles));
    }

    public TerminalEmulator put(Point coords, MapTile mapTile) {
        Point point = (Point)Predef$.MODULE$.ArrowAssoc((Object)coords);
        return this.put((Batch<Tuple2<Point, MapTile>>)indigo.package$package$.MODULE$.Batch().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)point, (Object)mapTile)));
    }

    public TerminalEmulator putLine(Point startCoords, String text, RGBA fgColor, RGBA bgColor) {
        Batch tiles = indigo.package$package$.MODULE$.Batch().fromArray((Object)text.toCharArray()).zipWithIndex().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                char c = BoxesRunTime.unboxToChar((Object)tuple2._1());
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Option option = package$package$.MODULE$.Tile().charCodes().get((Object)(c == '\\' ? "\\" : BoxesRunTime.boxToCharacter((char)c).toString()));
                if (None$.MODULE$.equals(option)) {
                    Point point = (Point)Predef$.MODULE$.ArrowAssoc((Object)startCoords.$plus(indigo.package$package$.MODULE$.Point().apply(i, 0)));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)point, (Object)MapTile$.MODULE$.apply(package$package$.MODULE$.Tile().SPACE(), fgColor, bgColor));
                }
                if (option instanceof Some) {
                    Tile$package$ tile$package$;
                    int n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                    Point point = (Point)Predef$.MODULE$.ArrowAssoc((Object)startCoords.$plus(indigo.package$package$.MODULE$.Point().apply(i, 0)));
                    Tile$package$ Tile$package$_this = tile$package$ = Tile$package$.MODULE$;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)point, (Object)MapTile$.MODULE$.apply(n, fgColor, bgColor));
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        return this.put((Batch<Tuple2<Point, MapTile>>)tiles);
    }

    public TerminalEmulator putLines(Point startCoords, Batch<String> textLines, RGBA fgColor, RGBA bgColor) {
        return TerminalEmulator.rec$1(startCoords, fgColor, bgColor, textLines.toList(), 0, this);
    }

    public Option<MapTile> get(Point coords) {
        return this.charMap().fetchElementAt(indigo.package$package$.MODULE$.Vertex().fromPoint(coords), CanEqual$.MODULE$.canEqualAny());
    }

    public TerminalEmulator delete(Point coords) {
        QuadTree quadTree = this.charMap().removeElement(indigo.package$package$.MODULE$.Vertex().fromPoint(coords));
        Size size = this.copy$default$1();
        return this.copy(size, (QuadTree<MapTile>)quadTree);
    }

    public TerminalEmulator clear() {
        QuadTree quadTree = QuadTree$.MODULE$.empty((double)this.screenSize().width(), (double)this.screenSize().height());
        Size size = this.copy$default$1();
        return this.copy(size, (QuadTree<MapTile>)quadTree);
    }

    public TerminalEmulator optimise() {
        QuadTree quadTree = this.charMap().prune();
        Size size = this.copy$default$1();
        return this.copy(size, (QuadTree<MapTile>)quadTree);
    }

    public Batch<MapTile> toTileBatch(MapTile mapTile) {
        return this.coordsBatch.map((Function1 & Serializable)pt -> (MapTile)this.get((Point)pt).getOrElse(() -> TerminalEmulator.toTileBatch$$anonfun$1$$anonfun$1(mapTile)));
    }

    public TerminalEntity draw(String tileSheet, Size charSize, MapTile mapTile, int maxTileCount) {
        return TerminalEntity$.MODULE$.apply(tileSheet, this.screenSize(), charSize, this.toTileBatch(mapTile), maxTileCount);
    }

    private Batch<CloneTileData> toCloneTileData(Point position, Batch<Tuple4<Object, Object, Object, Object>> charCrops, Batch<Tuple2<Point, MapTile>> data) {
        return data.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Point pt = (Point)tuple2._1();
                MapTile t = (MapTile)tuple2._2();
                Tuple4 crop = (Tuple4)charCrops.apply(Tile$package$Tile$.MODULE$.toInt(t.char()));
                return indigo.package$package$.MODULE$.CloneTileData().apply(pt.x() * BoxesRunTime.unboxToInt((Object)crop._3()) + position.x(), pt.y() * BoxesRunTime.unboxToInt((Object)crop._4()) + position.y(), BoxesRunTime.unboxToInt((Object)crop._1()), BoxesRunTime.unboxToInt((Object)crop._2()), BoxesRunTime.unboxToInt((Object)crop._3()), BoxesRunTime.unboxToInt((Object)crop._4()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public TerminalClones toCloneTiles(Point position, Batch<Tuple4<Object, Object, Object, Object>> charCrops, Function2<RGBA, RGBA, Cloneable> makeBlank) {
        Function2 & Serializable makeId = (Function2 & Serializable)(fg, bg) -> {
            CloneBlank$package$ cloneBlank$package$;
            CloneBlank$package$ CloneBlank$package$_this = cloneBlank$package$ = CloneBlank$package$.MODULE$;
            String value$proxy1 = new StringBuilder(9).append("term_cb_").append(fg.hashCode()).append("_").append(bg.hashCode()).toString();
            return value$proxy1;
        };
        Batch combinations = indigo.package$package$.MODULE$.Batch().fromMap(this.toPositionedBatch().groupBy((Function1 & Serializable)p -> Tuple3$.MODULE$.apply(makeId.apply((Object)((MapTile)p._2()).foreground(), (Object)((MapTile)p._2()).background()), (Object)((MapTile)p._2()).foreground(), (Object)((MapTile)p._2()).background())));
        Batch stuff = combinations.map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)indigo.package$package$.MODULE$.CloneBlank().apply((String)((Tuple3)c._1())._1(), () -> TerminalEmulator.$anonfun$5$$anonfun$1(makeBlank, c)), (Object)indigo.package$package$.MODULE$.CloneTiles().apply((String)((Tuple3)c._1())._1(), this.toCloneTileData(position, charCrops, (Batch<Tuple2<Point, MapTile>>)((Batch)c._2())))));
        return TerminalClones$.MODULE$.apply((Batch<CloneBlank>)stuff.map((Function1 & Serializable)_$1 -> (CloneBlank)_$1._1()), (Batch<CloneTiles>)stuff.map((Function1 & Serializable)_$2 -> (CloneTiles)_$2._2()));
    }

    public Batch<MapTile> toBatch() {
        return TerminalEmulator.rec$2((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{this.charMap()})), indigo.package$package$.MODULE$.Batch().empty());
    }

    public Batch<Tuple2<Point, MapTile>> toPositionedBatch() {
        return TerminalEmulator.rec$3((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{this.charMap()})), indigo.package$package$.MODULE$.Batch().empty());
    }

    public TerminalEmulator $bar$plus$bar(TerminalEmulator otherConsole) {
        return this.combine(otherConsole);
    }

    public TerminalEmulator combine(TerminalEmulator otherConsole) {
        QuadTree quadTree = this.charMap().insertElements(otherConsole.toPositionedBatch().map((Function1 & Serializable)p -> Tuple2$.MODULE$.apply(p._2(), (Object)indigo.package$package$.MODULE$.Vertex().fromPoint((Point)p._1()))));
        Size size = this.copy$default$1();
        return this.copy(size, (QuadTree<MapTile>)quadTree);
    }

    public TerminalEmulator inset(TerminalEmulator otherConsole, Point offset) {
        QuadTree quadTree = this.charMap().insertElements(otherConsole.toPositionedBatch().map((Function1 & Serializable)p -> Tuple2$.MODULE$.apply(p._2(), (Object)indigo.package$package$.MODULE$.Vertex().fromPoint(((Point)p._1()).$plus(offset)))));
        Size size = this.copy$default$1();
        return this.copy(size, (QuadTree<MapTile>)quadTree);
    }

    public TerminalEmulator copy(Size screenSize, QuadTree<MapTile> charMap) {
        return new TerminalEmulator(screenSize, charMap);
    }

    public Size copy$default$1() {
        return this.screenSize();
    }

    public QuadTree<MapTile> copy$default$2() {
        return this.charMap();
    }

    public Size _1() {
        return this.screenSize();
    }

    public QuadTree<MapTile> _2() {
        return this.charMap();
    }

    private static final /* synthetic */ Point $init$$$anonfun$1$$anonfun$1(int y$1, int x) {
        return indigo.package$package$.MODULE$.Point().apply(x, y$1);
    }

    private static final /* synthetic */ IterableOnce $init$$$anonfun$1(Size screenSize$10, int y) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), screenSize$10.width()).map((Function1 & Serializable)x -> TerminalEmulator.$init$$$anonfun$1$$anonfun$1(y, BoxesRunTime.unboxToInt((Object)x)));
    }

    private static final TerminalEmulator rec$1(Point startCoords$2, RGBA fgColor$2, RGBA bgColor$2, List remaining, int yOffset, TerminalEmulator term) {
        List list;
        while (true) {
            List xs;
            list = remaining;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return term;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            String x = (String)colon2.head();
            List list4 = xs = list3;
            int n = yOffset + 1;
            TerminalEmulator terminalEmulator = term.putLine(startCoords$2.$plus(indigo.package$package$.MODULE$.Point().apply(0, yOffset)), x, fgColor$2, bgColor$2);
            remaining = list4;
            yOffset = n;
            term = terminalEmulator;
        }
        throw new MatchError((Object)list);
    }

    private static final MapTile toTileBatch$$anonfun$1$$anonfun$1(MapTile default$2) {
        return default$2;
    }

    private static final Cloneable $anonfun$5$$anonfun$1(Function2 makeBlank$2, Tuple2 c$1) {
        return (Cloneable)makeBlank$2.apply(((Tuple3)c$1._1())._2(), ((Tuple3)c$1._1())._3());
    }

    private static final Batch rec$2(List open, Batch acc) {
        List list;
        block5: {
            QuadTree quadTree;
            while (true) {
                list = open;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    return acc;
                }
                if (!(list instanceof .colon.colon)) break block5;
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                QuadTree x = (QuadTree)colon2.head();
                List xs = list3;
                quadTree = x;
                if (quadTree instanceof QuadTree.QuadEmpty) {
                    open = xs;
                    continue;
                }
                if (quadTree instanceof QuadTree.QuadLeaf) {
                    QuadTree.QuadLeaf l = (QuadTree.QuadLeaf)quadTree;
                    List list4 = xs;
                    Batch batch = acc.$colon$colon(l.value());
                    open = list4;
                    acc = batch;
                    continue;
                }
                if (!(quadTree instanceof QuadTree.QuadBranch)) break;
                QuadTree.QuadBranch quadBranch = (QuadTree.QuadBranch)quadTree;
                QuadTree.QuadBranch b = quadBranch;
                if (b.isEmpty()) {
                    open = xs;
                    continue;
                }
                QuadTree.QuadBranch quadBranch2 = QuadTree.QuadBranch$.MODULE$.unapply(quadBranch);
                BoundingBox boundingBox = quadBranch2._1();
                QuadTree quadTree2 = quadBranch2._2();
                QuadTree quadTree3 = quadBranch2._3();
                QuadTree quadTree4 = quadBranch2._4();
                QuadTree quadTree5 = quadBranch2._5();
                QuadTree a = quadTree2;
                QuadTree b2 = quadTree3;
                QuadTree c = quadTree4;
                QuadTree d = quadTree5;
                List next = (List)((IterableOps)((IterableOps)(a.isEmpty() ? package$.MODULE$.Nil() : (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{a}))).$plus$plus((IterableOnce)(b2.isEmpty() ? package$.MODULE$.Nil() : (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{b2}))))).$plus$plus((IterableOnce)(c.isEmpty() ? package$.MODULE$.Nil() : (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{c}))))).$plus$plus((IterableOnce)(d.isEmpty() ? package$.MODULE$.Nil() : (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{d}))));
                open = (List)xs.$plus$plus((IterableOnce)next);
            }
            throw new MatchError((Object)quadTree);
        }
        throw new MatchError((Object)list);
    }

    private static final Batch rec$3(List open, Batch acc) {
        List list;
        block5: {
            QuadTree quadTree;
            while (true) {
                list = open;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    return acc;
                }
                if (!(list instanceof .colon.colon)) break block5;
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                QuadTree x = (QuadTree)colon2.head();
                List xs = list3;
                quadTree = x;
                if (quadTree instanceof QuadTree.QuadEmpty) {
                    open = xs;
                    continue;
                }
                if (quadTree instanceof QuadTree.QuadLeaf) {
                    QuadTree.QuadLeaf l = (QuadTree.QuadLeaf)quadTree;
                    List list4 = xs;
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)l.exactPosition().toPoint(), l.value());
                    Batch batch = acc.$colon$colon((Object)tuple2);
                    open = list4;
                    acc = batch;
                    continue;
                }
                if (!(quadTree instanceof QuadTree.QuadBranch)) break;
                QuadTree.QuadBranch quadBranch = (QuadTree.QuadBranch)quadTree;
                QuadTree.QuadBranch b = quadBranch;
                if (b.isEmpty()) {
                    open = xs;
                    continue;
                }
                QuadTree.QuadBranch quadBranch2 = QuadTree.QuadBranch$.MODULE$.unapply(quadBranch);
                BoundingBox boundingBox = quadBranch2._1();
                QuadTree quadTree2 = quadBranch2._2();
                QuadTree quadTree3 = quadBranch2._3();
                QuadTree quadTree4 = quadBranch2._4();
                QuadTree quadTree5 = quadBranch2._5();
                QuadTree a = quadTree2;
                QuadTree b2 = quadTree3;
                QuadTree c = quadTree4;
                QuadTree d = quadTree5;
                List next = (List)((IterableOps)((IterableOps)(a.isEmpty() ? package$.MODULE$.Nil() : (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{a}))).$plus$plus((IterableOnce)(b2.isEmpty() ? package$.MODULE$.Nil() : (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{b2}))))).$plus$plus((IterableOnce)(c.isEmpty() ? package$.MODULE$.Nil() : (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{c}))))).$plus$plus((IterableOnce)(d.isEmpty() ? package$.MODULE$.Nil() : (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuadTree[]{d}))));
                open = (List)xs.$plus$plus((IterableOnce)next);
            }
            throw new MatchError((Object)quadTree);
        }
        throw new MatchError((Object)list);
    }
}

