/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.util;

import io.hyscale.deployer.core.model.ResourceKind;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class TroubleshootContextValidator {
    private TroubleshootContextValidator() {
    }

    public static boolean validateContext(TroubleshootingContext context) {
        return context != null && context.getResourceInfos() != null;
    }

    public static boolean isResourceInfoInValid(List<TroubleshootingContext.ResourceInfo> resourceData) {
        return resourceData == null || resourceData.isEmpty();
    }

    public static List<V1Pod> getPods(TroubleshootingContext context) {
        List<TroubleshootingContext.ResourceInfo> resourceData = context.getResourceInfos().get(ResourceKind.POD.getKind());
        if (resourceData == null || resourceData.isEmpty()) {
            return Collections.emptyList();
        }
        return resourceData.stream().filter(each -> each.getResource() instanceof V1Pod).map(each -> (V1Pod)each.getResource()).collect(Collectors.toUnmodifiableList());
    }
}

