/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.util;

import io.hyscale.deployer.core.model.ResourceKind;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ConditionUtil {
    private ConditionUtil() {
    }

    public static ResourceKind getPodParent(TroubleshootingContext context) {
        if (context == null || context.getResourceInfos() == null) {
            return null;
        }
        List resourceInfos = context.getResourceInfos().getOrDefault(ResourceKind.STATEFUL_SET.getKind(), null);
        if (resourceInfos != null && !resourceInfos.isEmpty()) {
            return ResourceKind.STATEFUL_SET;
        }
        resourceInfos = context.getResourceInfos().getOrDefault(ResourceKind.DEPLOYMENT.getKind(), null);
        if (resourceInfos != null && !resourceInfos.isEmpty()) {
            return ResourceKind.DEPLOYMENT;
        }
        return null;
    }

    public static List<V1Pod> getPods(TroubleshootingContext context) {
        List<Object> podList = Collections.emptyList();
        if (context == null || context.getResourceInfos() == null) {
            return podList;
        }
        List<TroubleshootingContext.ResourceInfo> resourceInfos = context.getResourceInfos().get(ResourceKind.POD.getKind());
        if (resourceInfos == null || resourceInfos.isEmpty()) {
            return podList;
        }
        podList = resourceInfos.stream().filter(each -> each != null && each.getResource() instanceof V1Pod).map(pod -> (V1Pod)pod.getResource()).collect(Collectors.toList());
        return podList;
    }
}

