/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.service.impl;

import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.commons.framework.events.publisher.EventPublisher;
import io.hyscale.commons.models.K8sAuthorisation;
import io.hyscale.commons.models.ServiceMetadata;
import io.hyscale.troubleshooting.integration.builder.TroubleshootingContextCollector;
import io.hyscale.troubleshooting.integration.conditions.PodStatusCondition;
import io.hyscale.troubleshooting.integration.models.DiagnosisReport;
import io.hyscale.troubleshooting.integration.models.Node;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.hyscale.troubleshooting.integration.service.TroubleshootService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TroubleshootServiceImpl
implements TroubleshootService {
    private static final Logger logger = LoggerFactory.getLogger(TroubleshootServiceImpl.class);
    @Autowired
    private TroubleshootingContextCollector contextBuilder;
    @Autowired
    private PodStatusCondition podStatusCondition;
    @Autowired
    private EventPublisher publisher;

    @Override
    public List<DiagnosisReport> troubleshoot(ServiceMetadata serviceMetadata, K8sAuthorisation k8sAuthorisation, String namespace) throws HyscaleException {
        try {
            TroubleshootingContext troubleshootingContext = this.contextBuilder.build(serviceMetadata, k8sAuthorisation, namespace);
            this.executeTroubleshootFlow(troubleshootingContext);
            return troubleshootingContext.getDiagnosisReports();
        }
        catch (HyscaleException e) {
            logger.error("Error while troubleshooting service {}", (Object)serviceMetadata.getServiceName(), (Object)e);
            throw e;
        }
    }

    private void executeTroubleshootFlow(TroubleshootingContext troubleshootingContext) throws HyscaleException {
        Node<TroubleshootingContext> current = this.podStatusCondition;
        String nodeDescription = current.describe();
        try {
            do {
                nodeDescription = current.describe();
                if (!troubleshootingContext.isTrace()) continue;
                logger.debug("Executing troubleshooting node {}", (Object)nodeDescription);
            } while ((current = current.next(troubleshootingContext)) != null);
        }
        catch (HyscaleException e) {
            logger.error("Error while troubleshooting workflow {}", (Object)nodeDescription, (Object)e);
            throw e;
        }
    }
}

