/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.models;

import io.hyscale.commons.models.ServiceMetadata;
import io.hyscale.troubleshooting.integration.models.DiagnosisReport;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.NodeContext;
import io.kubernetes.client.openapi.models.V1Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class TroubleshootingContext
implements NodeContext {
    private ServiceMetadata serviceMetadata;
    private Map<String, List<ResourceInfo>> resourceInfos;
    private Map<FailedResourceKey, Object> failedObjects = new EnumMap<FailedResourceKey, Object>(FailedResourceKey.class);
    private List<DiagnosisReport> diagnosisReports = new ArrayList<DiagnosisReport>();
    private boolean trace;

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    public void setServiceMetadata(ServiceMetadata serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
    }

    public Map<FailedResourceKey, Object> getFailedObjects() {
        return Collections.unmodifiableMap(this.failedObjects);
    }

    public Object addAttribute(FailedResourceKey key, Object value) {
        return this.failedObjects.put(key, value);
    }

    public Object getAttribute(FailedResourceKey key) {
        return this.failedObjects.get((Object)key);
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public Map<String, List<ResourceInfo>> getResourceInfos() {
        return this.resourceInfos;
    }

    public void setResourceInfos(Map<String, List<ResourceInfo>> resourceInfos) {
        this.resourceInfos = resourceInfos;
    }

    public List<DiagnosisReport> getDiagnosisReports() {
        return Collections.unmodifiableList(this.diagnosisReports);
    }

    public void addReport(DiagnosisReport report) {
        this.diagnosisReports.add(report);
    }

    public static class ResourceInfo {
        private List<V1Event> events;
        private Object resource;

        public List<V1Event> getEvents() {
            return this.events;
        }

        public void setEvents(List<V1Event> events) {
            this.events = events;
        }

        public Object getResource() {
            return this.resource;
        }

        public void setResource(Object resource) {
            this.resource = resource;
        }
    }
}

