/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.conditions;

import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.commons.utils.HyscaleContextUtil;
import io.hyscale.deployer.core.model.ResourceKind;
import io.hyscale.deployer.services.model.PodStatus;
import io.hyscale.deployer.services.model.PodStatusUtil;
import io.hyscale.troubleshooting.integration.actions.DefaultAction;
import io.hyscale.troubleshooting.integration.actions.FixCrashingApplication;
import io.hyscale.troubleshooting.integration.actions.ImagePullBackOffAction;
import io.hyscale.troubleshooting.integration.actions.ServiceNotDeployedAction;
import io.hyscale.troubleshooting.integration.conditions.ArePodsReady;
import io.hyscale.troubleshooting.integration.conditions.IsClusterFull;
import io.hyscale.troubleshooting.integration.conditions.MissingCMDorStartCommandsCondition;
import io.hyscale.troubleshooting.integration.conditions.ParentStatusCondition;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.Node;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PodStatusCondition
implements Node<TroubleshootingContext> {
    private static final Logger logger = LoggerFactory.getLogger(PodStatusCondition.class);
    @Autowired
    private ServiceNotDeployedAction serviceNotDeployedAction;
    @Autowired
    private ParentStatusCondition parentStatusCondition;

    @Override
    public Node<TroubleshootingContext> next(TroubleshootingContext context) throws HyscaleException {
        if (context.getResourceInfos() == null) {
            return this.serviceNotDeployedAction;
        }
        List resourceInfos = context.getResourceInfos().getOrDefault(ResourceKind.POD.getKind(), null);
        if (resourceInfos == null || resourceInfos.isEmpty()) {
            if (context.isTrace()) {
                logger.debug("Cannot find any pods for the service {}", (Object)context.getServiceMetadata().getServiceName());
            }
            return this.parentStatusCondition;
        }
        PodStatus effectivePodStatus = PodStatus.DEFAULT;
        for (TroubleshootingContext.ResourceInfo each : resourceInfos) {
            if (each == null || each.getResource() == null || !(each.getResource() instanceof V1Pod)) continue;
            V1Pod v1Pod = (V1Pod)each.getResource();
            String aggregatedStatus = PodStatusUtil.currentStatusOf((V1Pod)v1Pod);
            if (context.isTrace()) {
                logger.debug("Aggregated status of pod {} of service {}", (Object)v1Pod.getMetadata().getName(), (Object)context.getServiceMetadata().getServiceName());
            }
            if (StringUtils.isEmpty((Object)aggregatedStatus) || !(effectivePodStatus = PodStatus.get((String)aggregatedStatus)).isFailed()) continue;
            context.addAttribute(FailedResourceKey.OBSERVED_POD_STATUS, aggregatedStatus);
            if (context.isTrace()) {
                logger.debug("Observed failed pod {} and status {}", (Object)v1Pod.getMetadata().getName(), (Object)effectivePodStatus.getStatus());
            }
            context.addAttribute(FailedResourceKey.FAILED_POD, v1Pod);
            context.addAttribute(FailedResourceKey.FAILED_POD_EVENTS, each.getEvents());
            break;
        }
        return (Node)HyscaleContextUtil.getSpringBean(this.getNextNode(effectivePodStatus));
    }

    @Override
    public String describe() {
        return "Checks for pod status and continue the workflow based on the status";
    }

    public Class<? extends Node> getNextNode(PodStatus podStatus) {
        Class<DefaultAction> defaultActionClass = DefaultAction.class;
        if (podStatus == null) {
            return defaultActionClass;
        }
        switch (podStatus) {
            case IMAGEPULL_BACKOFF: 
            case ERR_IMAGE_PULL: {
                return ImagePullBackOffAction.class;
            }
            case CRASHLOOP_BACKOFF: {
                return MissingCMDorStartCommandsCondition.class;
            }
            case RUNNING: {
                return ArePodsReady.class;
            }
            case OOMKILLED: {
                return FixCrashingApplication.class;
            }
            case PENDING: {
                return IsClusterFull.class;
            }
            case ERROR: {
                return ArePodsReady.class;
            }
            case COMPLETED: {
                return FixCrashingApplication.class;
            }
            case TERMINATING: {
                return ParentStatusCondition.class;
            }
            case RUN_CONTAINER_ERROR: 
            case DEFAULT: {
                return defaultActionClass;
            }
        }
        return defaultActionClass;
    }
}

