/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.conditions;

import io.hyscale.commons.exception.HyscaleError;
import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.deployer.services.model.PodCondition;
import io.hyscale.deployer.services.util.K8sPodUtil;
import io.hyscale.troubleshooting.integration.errors.TroubleshootErrorCodes;
import io.hyscale.troubleshooting.integration.models.ConditionNode;
import io.hyscale.troubleshooting.integration.models.Node;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.hyscale.troubleshooting.integration.util.ConditionUtil;
import io.hyscale.troubleshooting.integration.util.DiagnosisReportUtil;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PodScheduleCondition
extends ConditionNode<TroubleshootingContext> {
    private static final Logger logger = LoggerFactory.getLogger(PodScheduleCondition.class);

    @Override
    public boolean decide(TroubleshootingContext context) throws HyscaleException {
        String serviceName = context.getServiceMetadata().getServiceName();
        List<V1Pod> podsList = ConditionUtil.getPods(context);
        if (podsList == null || podsList.isEmpty()) {
            logger.debug("No pods found for service: {}", (Object)serviceName);
            context.addReport(DiagnosisReportUtil.getServiceNotDeployedReport(serviceName));
            throw new HyscaleException((HyscaleError)TroubleshootErrorCodes.SERVICE_IS_NOT_DEPLOYED, new String[]{serviceName});
        }
        return podsList.stream().anyMatch(pod -> !K8sPodUtil.checkForPodCondition((V1Pod)pod, (PodCondition)PodCondition.POD_SCHEDULED) || K8sPodUtil.checkForPodCondition((V1Pod)pod, (PodCondition)PodCondition.UNSCHEDULABLE));
    }

    @Override
    public Node<TroubleshootingContext> onSuccess() {
        return null;
    }

    @Override
    public Node<TroubleshootingContext> onFailure() {
        return null;
    }

    @Override
    public String describe() {
        return "Are all pods scheduled ?";
    }
}

