/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.conditions;

import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.deployer.core.model.ResourceKind;
import io.hyscale.deployer.services.factory.PodParentFactory;
import io.hyscale.deployer.services.handler.PodParentHandler;
import io.hyscale.troubleshooting.integration.actions.ParentFailureAction;
import io.hyscale.troubleshooting.integration.actions.ServiceNotDeployedAction;
import io.hyscale.troubleshooting.integration.actions.ServiceWithZeroReplicasAction;
import io.hyscale.troubleshooting.integration.actions.TryAfterSometimeAction;
import io.hyscale.troubleshooting.integration.models.AbstractedErrorMessage;
import io.hyscale.troubleshooting.integration.models.DiagnosisReport;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.Node;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.hyscale.troubleshooting.integration.util.ConditionUtil;
import io.kubernetes.client.openapi.models.V1Event;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParentStatusCondition
implements Node<TroubleshootingContext> {
    private static final Logger logger = LoggerFactory.getLogger(ParentStatusCondition.class);
    public static final String FAILED_CREATE_EVENT = "FailedCreate";
    @Autowired
    private ServiceNotDeployedAction serviceNotDeployedAction;
    @Autowired
    private ServiceWithZeroReplicasAction serviceWithZeroReplicasAction;
    @Autowired
    private ParentFailureAction parentFailureAction;
    @Autowired
    private TryAfterSometimeAction tryAfterSometimeAction;

    @Override
    public Node<TroubleshootingContext> next(TroubleshootingContext context) throws HyscaleException {
        if (context.getResourceInfos() == null) {
            return this.serviceNotDeployedAction;
        }
        ResourceKind podParent = ConditionUtil.getPodParent(context);
        if (context.isTrace()) {
            String describe = this.describe();
            logger.debug("{}, pod parent {}", (Object)describe, (Object)podParent);
        }
        if (podParent == null) {
            return this.serviceNotDeployedAction;
        }
        List resourceInfos = context.getResourceInfos().getOrDefault(podParent.getKind(), null);
        if (resourceInfos == null || resourceInfos.isEmpty()) {
            logger.debug("Pod owner {} not found in context", (Object)podParent);
            return this.serviceNotDeployedAction;
        }
        TroubleshootingContext.ResourceInfo parentInfo = (TroubleshootingContext.ResourceInfo)resourceInfos.get(0);
        if (this.hasZeroReplicas(parentInfo, podParent)) {
            return this.serviceWithZeroReplicasAction;
        }
        DiagnosisReport report = new DiagnosisReport();
        List<V1Event> events = parentInfo.getEvents();
        if (events == null || events.isEmpty()) {
            report.setReason(AbstractedErrorMessage.CANNOT_FIND_EVENTS.getReason());
            report.setRecommendedFix(AbstractedErrorMessage.CANNOT_FIND_EVENTS.getMessage());
            context.addReport(report);
            logger.debug("{} no events found", (Object)podParent);
            return null;
        }
        V1Event event = this.getFilteredEvent(events);
        if (event == null) {
            logger.debug("{} no failure event found to process", (Object)podParent);
            return this.tryAfterSometimeAction;
        }
        context.addAttribute(FailedResourceKey.FAILED_PARENT_EVENT, event);
        return this.parentFailureAction;
    }

    private boolean hasZeroReplicas(TroubleshootingContext.ResourceInfo parentInfo, ResourceKind podParent) {
        PodParentHandler podParentHandler = PodParentFactory.getHandler((String)podParent.getKind());
        Integer replicas = podParentHandler.getReplicas(parentInfo.getResource());
        return replicas != null && replicas == 0;
    }

    private V1Event getFilteredEvent(List<V1Event> events) {
        V1Event filteredEvent = null;
        for (V1Event event : events) {
            if (!FAILED_CREATE_EVENT.equals(event.getReason())) continue;
            filteredEvent = event;
        }
        return filteredEvent;
    }

    @Override
    public String describe() {
        return "Checks for pod parent status and process events";
    }
}

