/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.conditions;

import io.hyscale.commons.exception.HyscaleError;
import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.troubleshooting.integration.conditions.IsApplicationCrashing;
import io.hyscale.troubleshooting.integration.conditions.IsPodsReadinessFailing;
import io.hyscale.troubleshooting.integration.errors.TroubleshootErrorCodes;
import io.hyscale.troubleshooting.integration.models.ConditionNode;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.Node;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.hyscale.troubleshooting.integration.util.ConditionUtil;
import io.hyscale.troubleshooting.integration.util.DiagnosisReportUtil;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MultipleContainerRestartsCondition
extends ConditionNode<TroubleshootingContext> {
    private static final Logger logger = LoggerFactory.getLogger(MultipleContainerRestartsCondition.class);
    @Autowired
    private IsPodsReadinessFailing isPodsReadinessFailing;
    @Autowired
    private IsApplicationCrashing isApplicationCrashing;

    @Override
    public boolean decide(TroubleshootingContext context) throws HyscaleException {
        String serviceName = context.getServiceMetadata().getServiceName();
        Object obj = context.getAttribute(FailedResourceKey.FAILED_POD);
        List<V1Pod> podList = null;
        if (obj == null) {
            logger.debug("Getting pods from resource info");
            podList = ConditionUtil.getPods(context);
            if (podList == null || podList.isEmpty()) {
                context.addReport(DiagnosisReportUtil.getServiceNotDeployedReport(serviceName));
                throw new HyscaleException((HyscaleError)TroubleshootErrorCodes.SERVICE_IS_NOT_DEPLOYED, new String[]{serviceName});
            }
        } else {
            logger.debug("Pods found in context");
            V1Pod failedPod = (V1Pod)FailedResourceKey.FAILED_POD.getKlazz().cast(obj);
            podList = new LinkedList<V1Pod>();
            podList.add(failedPod);
        }
        return podList.stream().anyMatch(each -> each.getStatus().getContainerStatuses().stream().anyMatch(containerStatus -> {
            if (containerStatus.getRestartCount() > 0) {
                context.addAttribute(FailedResourceKey.RESTARTS, true);
                if (obj == null) {
                    context.addAttribute(FailedResourceKey.FAILED_POD, each);
                }
                return true;
            }
            return false;
        }));
    }

    @Override
    public Node<TroubleshootingContext> onSuccess() {
        return this.isApplicationCrashing;
    }

    @Override
    public Node<TroubleshootingContext> onFailure() {
        return this.isPodsReadinessFailing;
    }

    @Override
    public String describe() {
        return "Multiple container restarts ?";
    }
}

