/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.conditions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.hyscale.commons.commands.CommandExecutor;
import io.hyscale.commons.commands.provider.ImageCommandProvider;
import io.hyscale.commons.exception.HyscaleError;
import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.commons.models.CommandResult;
import io.hyscale.commons.utils.ObjectMapperFactory;
import io.hyscale.troubleshooting.integration.actions.DockerfileCMDMissingAction;
import io.hyscale.troubleshooting.integration.conditions.MultipleContainerRestartsCondition;
import io.hyscale.troubleshooting.integration.errors.TroubleshootErrorCodes;
import io.hyscale.troubleshooting.integration.models.AbstractedErrorMessage;
import io.hyscale.troubleshooting.integration.models.ConditionNode;
import io.hyscale.troubleshooting.integration.models.DiagnosisReport;
import io.hyscale.troubleshooting.integration.models.Node;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.hyscale.troubleshooting.integration.util.ConditionUtil;
import io.hyscale.troubleshooting.integration.util.DiagnosisReportUtil;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Pod;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MissingCMDorStartCommandsCondition
extends ConditionNode<TroubleshootingContext> {
    private static final Logger logger = LoggerFactory.getLogger(MissingCMDorStartCommandsCondition.class);
    private static final String DOCKER_INSTALLATION_NOTFOUND_MESSAGE = "Docker is not installed";
    private static final String IMAGE_NOT_FOUND_LOCALLY = "Image %s is not found locally to inspect";
    @Autowired
    private ImageCommandProvider commandProvider;
    @Autowired
    private DockerfileCMDMissingAction dockerfileCMDMissingAction;
    @Autowired
    private MultipleContainerRestartsCondition multipleContainerRestartsCondition;

    @Override
    public boolean decide(TroubleshootingContext context) throws HyscaleException {
        String serviceName = context.getServiceMetadata().getServiceName();
        List<V1Pod> podsList = ConditionUtil.getPods(context);
        if (podsList == null || podsList.isEmpty()) {
            logger.debug("No pods found for service: {}", (Object)serviceName);
            context.addReport(DiagnosisReportUtil.getServiceNotDeployedReport(serviceName));
            throw new HyscaleException((HyscaleError)TroubleshootErrorCodes.SERVICE_IS_NOT_DEPLOYED, new String[]{serviceName});
        }
        V1Pod pod = podsList.get(0);
        if (this.checkForStartCommands(pod)) {
            return false;
        }
        DiagnosisReport report = new DiagnosisReport();
        String image = this.getImageFromPods(pod);
        if (image == null) {
            report.setReason(AbstractedErrorMessage.CANNOT_INFER_ERROR.getReason());
            report.setRecommendedFix(AbstractedErrorMessage.CANNOT_INFER_ERROR.getMessage());
            context.addReport(report);
            throw new HyscaleException((HyscaleError)TroubleshootErrorCodes.SERVICE_IS_NOT_DEPLOYED, new String[]{context.getServiceMetadata().getServiceName()});
        }
        String dockerInstallCommand = this.commandProvider.dockerVersion();
        if (!CommandExecutor.execute((String)dockerInstallCommand)) {
            report.setRecommendedFix(DOCKER_INSTALLATION_NOTFOUND_MESSAGE);
            context.addReport(report);
            return false;
        }
        CommandResult result = CommandExecutor.executeAndGetResults((String)this.commandProvider.dockerInspect(image));
        if (result == null || StringUtils.isEmpty((Object)result.getCommandOutput()) || result.getExitCode() != 0) {
            report.setRecommendedFix(String.format(IMAGE_NOT_FOUND_LOCALLY, image));
            context.addReport(report);
            return false;
        }
        return this.checkForDockerfileCMD(result.getCommandOutput());
    }

    private boolean checkForDockerfileCMD(String commandOutput) {
        if (StringUtils.isEmpty((Object)commandOutput)) {
            return true;
        }
        ObjectMapper mapper = ObjectMapperFactory.jsonMapper();
        try {
            JsonNode node = mapper.readTree(commandOutput);
            JsonNode cmdNode = null;
            cmdNode = node.isArray() ? node.get(0).get("Config").get("Cmd") : node.get("Config").get("Cmd");
            if (cmdNode == null) {
                return true;
            }
            if (cmdNode.isArray()) {
                ArrayNode arrayNode = (ArrayNode)cmdNode;
                return arrayNode.isEmpty();
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Error while processing image inspect results ", (Throwable)e);
            return false;
        }
    }

    @Override
    public Node<TroubleshootingContext> onSuccess() {
        return this.dockerfileCMDMissingAction;
    }

    @Override
    public Node<TroubleshootingContext> onFailure() {
        return this.multipleContainerRestartsCondition;
    }

    @Override
    public String describe() {
        return "Is either of Dockerfile CMD or Args in kubernetes yaml defined ?";
    }

    private boolean checkForStartCommands(V1Pod pod) {
        if (pod == null) {
            return false;
        }
        return !StringUtils.isEmpty((Object)((V1Container)pod.getSpec().getContainers().get(0)).getArgs()) || !StringUtils.isEmpty((Object)((V1Container)pod.getSpec().getContainers().get(0)).getCommand());
    }

    private String getImageFromPods(V1Pod pod) {
        if (pod == null) {
            return null;
        }
        return ((V1Container)pod.getSpec().getContainers().get(0)).getImage();
    }
}

