/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.conditions;

import io.hyscale.commons.exception.HyscaleError;
import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.deployer.core.model.ResourceKind;
import io.hyscale.deployer.services.model.PodStatus;
import io.hyscale.deployer.services.util.K8sPodUtil;
import io.hyscale.troubleshooting.integration.actions.FixCrashingApplication;
import io.hyscale.troubleshooting.integration.actions.FixHealthCheckAction;
import io.hyscale.troubleshooting.integration.actions.TryAfterSometimeAction;
import io.hyscale.troubleshooting.integration.errors.TroubleshootErrorCodes;
import io.hyscale.troubleshooting.integration.models.AbstractedErrorMessage;
import io.hyscale.troubleshooting.integration.models.DiagnosisReport;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.Node;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.kubernetes.client.openapi.models.V1Event;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IsPodsReadinessFailing
implements Node<TroubleshootingContext> {
    private static final Logger logger = LoggerFactory.getLogger(IsPodsReadinessFailing.class);
    private static final String UNHEALTHY_REASON = "Unhealthy";
    @Autowired
    private FixHealthCheckAction fixHealthCheckAction;
    @Autowired
    private TryAfterSometimeAction tryAfterSometimeAction;
    @Autowired
    private FixCrashingApplication fixCrashingApplication;

    @Override
    public Node<TroubleshootingContext> next(TroubleshootingContext context) throws HyscaleException {
        List<TroubleshootingContext.ResourceInfo> resourceInfos = context.getResourceInfos().get(ResourceKind.POD.getKind());
        DiagnosisReport report = new DiagnosisReport();
        if (resourceInfos == null || resourceInfos.isEmpty()) {
            report.setReason(AbstractedErrorMessage.SERVICE_NOT_DEPLOYED.formatReason(context.getServiceMetadata().getServiceName()));
            report.setRecommendedFix(AbstractedErrorMessage.SERVICE_NOT_DEPLOYED.getMessage());
            context.addReport(report);
            throw new HyscaleException((HyscaleError)TroubleshootErrorCodes.SERVICE_IS_NOT_DEPLOYED, new String[]{context.getServiceMetadata().getServiceName()});
        }
        ArrayList<V1Event> v1Events = new ArrayList<V1Event>();
        Object obj = context.getAttribute(FailedResourceKey.UNREADY_POD);
        V1Pod unhealthyPod = null;
        if (obj != null) {
            unhealthyPod = (V1Pod)FailedResourceKey.UNREADY_POD.getKlazz().cast(obj);
        }
        Object restartsObj = context.getAttribute(FailedResourceKey.RESTARTS);
        boolean restartsObserved = false;
        if (restartsObj != null) {
            restartsObserved = BooleanUtils.toBoolean((Boolean)((Boolean)FailedResourceKey.RESTARTS.getKlazz().cast(restartsObj)));
        }
        for (TroubleshootingContext.ResourceInfo resourceInfo : resourceInfos) {
            if (resourceInfo == null || !(resourceInfo.getResource() instanceof V1Pod)) continue;
            V1Pod pod = (V1Pod)resourceInfo.getResource();
            if (unhealthyPod == null) {
                PodStatus status = PodStatus.get((String)K8sPodUtil.getAggregatedStatusOfContainersForPod((V1Pod)pod));
                if (status == null || status.isFailed()) continue;
                v1Events.addAll(resourceInfo.getEvents());
                continue;
            }
            if (!unhealthyPod.getMetadata().getName().equals(pod.getMetadata().getName())) continue;
            v1Events.addAll(resourceInfo.getEvents());
        }
        if (v1Events.isEmpty()) {
            logger.debug("No events found when checking for pod readiness");
            report.setReason(AbstractedErrorMessage.CANNOT_FIND_EVENTS.getReason());
            report.setRecommendedFix(AbstractedErrorMessage.CANNOT_FIND_EVENTS.getMessage());
            context.addReport(report);
            return this.fixHealthCheckAction;
        }
        boolean unhealthy = v1Events.stream().anyMatch(each -> {
            if (UNHEALTHY_REASON.equals(each.getReason())) {
                context.addAttribute(FailedResourceKey.UNHEALTHY_POD_EVENT, each);
                return true;
            }
            return false;
        });
        if (unhealthy) {
            return this.fixHealthCheckAction;
        }
        return restartsObserved ? this.fixCrashingApplication : this.tryAfterSometimeAction;
    }

    @Override
    public String describe() {
        return "Readiness failing ?";
    }
}

