/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.conditions;

import io.hyscale.commons.exception.HyscaleError;
import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.deployer.core.model.ResourceKind;
import io.hyscale.troubleshooting.integration.actions.ClusterFullAction;
import io.hyscale.troubleshooting.integration.conditions.AnyPendingPVCCondition;
import io.hyscale.troubleshooting.integration.errors.TroubleshootErrorCodes;
import io.hyscale.troubleshooting.integration.models.AbstractedErrorMessage;
import io.hyscale.troubleshooting.integration.models.ConditionNode;
import io.hyscale.troubleshooting.integration.models.DiagnosisReport;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.Node;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IsClusterFull
extends ConditionNode<TroubleshootingContext> {
    private static final Logger logger = LoggerFactory.getLogger(IsClusterFull.class);
    @Autowired
    private ClusterFullAction clusterFullAction;
    @Autowired
    private AnyPendingPVCCondition pendingPVCCondition;
    private static final String INSUFFICIENT_MEMORY_REGEX = "\\d\\/\\d nodes are available: \\d+ Insufficient memory.";
    private static final String FAILED_SCHEDULING = "FailedScheduling";
    private static final Pattern pattern = Pattern.compile("\\d\\/\\d nodes are available: \\d+ Insufficient memory.");

    @Override
    public boolean decide(TroubleshootingContext context) throws HyscaleException {
        List<TroubleshootingContext.ResourceInfo> resourceInfos = context.getResourceInfos().get(ResourceKind.POD.getKind());
        DiagnosisReport report = new DiagnosisReport();
        if (resourceInfos == null || resourceInfos.isEmpty()) {
            report.setReason(AbstractedErrorMessage.SERVICE_NOT_DEPLOYED.formatReason(context.getServiceMetadata().getServiceName()));
            report.setRecommendedFix(AbstractedErrorMessage.SERVICE_NOT_DEPLOYED.getMessage());
            context.addReport(report);
            throw new HyscaleException((HyscaleError)TroubleshootErrorCodes.SERVICE_IS_NOT_DEPLOYED, new String[]{context.getServiceMetadata().getServiceName()});
        }
        Object obj = context.getAttribute(FailedResourceKey.FAILED_POD_EVENTS);
        if (obj == null) {
            String describe = this.describe();
            logger.debug("Cannot find any failed pod for node: {}", (Object)describe);
            return false;
        }
        List eventList = (List)FailedResourceKey.FAILED_POD_EVENTS.getKlazz().cast(obj);
        if (eventList == null || eventList.isEmpty()) {
            report.setReason(AbstractedErrorMessage.CANNOT_FIND_EVENTS.getReason());
            report.setRecommendedFix(AbstractedErrorMessage.CANNOT_FIND_EVENTS.getMessage());
            context.addReport(report);
            return false;
        }
        return eventList.stream().anyMatch(event -> FAILED_SCHEDULING.equals(event.getReason()) && pattern.matcher(event.getMessage()).find());
    }

    @Override
    public Node<TroubleshootingContext> onSuccess() {
        return this.clusterFullAction;
    }

    @Override
    public Node<TroubleshootingContext> onFailure() {
        return this.pendingPVCCondition;
    }

    @Override
    public String describe() {
        return "Is Cluster Full ?";
    }
}

