/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.conditions;

import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.deployer.services.model.PodStatus;
import io.hyscale.deployer.services.model.PodStatusUtil;
import io.hyscale.troubleshooting.integration.actions.FixCrashingApplication;
import io.hyscale.troubleshooting.integration.conditions.IsPodsReadinessFailing;
import io.hyscale.troubleshooting.integration.models.ConditionNode;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.Node;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.kubernetes.client.openapi.models.V1Pod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IsApplicationCrashing
extends ConditionNode<TroubleshootingContext> {
    @Autowired
    private FixCrashingApplication fixCrashingApplication;
    @Autowired
    private IsPodsReadinessFailing isPodsReadinessFailing;

    @Override
    public boolean decide(TroubleshootingContext context) throws HyscaleException {
        Object obj = context.getAttribute(FailedResourceKey.FAILED_POD);
        String lastState = null;
        if (obj != null) {
            V1Pod pod = (V1Pod)FailedResourceKey.FAILED_POD.getKlazz().cast(obj);
            String string = lastState = pod != null ? PodStatusUtil.lastStateOf((V1Pod)pod) : null;
        }
        if (lastState != null) {
            return lastState.equals(PodStatus.OOMKILLED.getStatus()) || lastState.equals(PodStatus.COMPLETED.getStatus()) || lastState.equals(PodStatus.ERROR.getStatus());
        }
        return false;
    }

    @Override
    public Node<TroubleshootingContext> onSuccess() {
        return this.fixCrashingApplication;
    }

    @Override
    public Node<TroubleshootingContext> onFailure() {
        return this.isPodsReadinessFailing;
    }

    @Override
    public String describe() {
        return "Is Application crashing";
    }
}

