/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.conditions;

import io.hyscale.commons.exception.HyscaleError;
import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.deployer.services.model.PodCondition;
import io.hyscale.troubleshooting.integration.conditions.MultipleContainerRestartsCondition;
import io.hyscale.troubleshooting.integration.errors.TroubleshootErrorCodes;
import io.hyscale.troubleshooting.integration.models.ConditionNode;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.Node;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.hyscale.troubleshooting.integration.util.ConditionUtil;
import io.hyscale.troubleshooting.integration.util.DiagnosisReportUtil;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodCondition;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArePodsReady
extends ConditionNode<TroubleshootingContext> {
    private static final Logger logger = LoggerFactory.getLogger(ArePodsReady.class);
    @Autowired
    private MultipleContainerRestartsCondition multipleContainerRestartsCondition;

    @Override
    public boolean decide(TroubleshootingContext context) throws HyscaleException {
        List<V1Pod> podsList = ConditionUtil.getPods(context);
        String serviceName = context.getServiceMetadata().getServiceName();
        if (podsList == null || podsList.isEmpty()) {
            logger.debug("No pods found for service: {}", (Object)serviceName);
            context.addReport(DiagnosisReportUtil.getServiceNotDeployedReport(serviceName));
            throw new HyscaleException((HyscaleError)TroubleshootErrorCodes.SERVICE_IS_NOT_DEPLOYED, new String[]{serviceName});
        }
        return podsList.stream().filter(Objects::nonNull).allMatch(pod -> {
            boolean ready = true;
            for (V1PodCondition condition : pod.getStatus().getConditions()) {
                if (!condition.getType().equals(PodCondition.READY.getPodCondition()) || !condition.getStatus().equals("False")) continue;
                ready = false;
                context.addAttribute(FailedResourceKey.FAILED_POD, pod);
                context.addAttribute(FailedResourceKey.UNREADY_POD, pod);
                break;
            }
            return ready;
        });
    }

    @Override
    public Node<TroubleshootingContext> onSuccess() {
        return null;
    }

    @Override
    public Node<TroubleshootingContext> onFailure() {
        return this.multipleContainerRestartsCondition;
    }

    @Override
    public String describe() {
        return "Are all pods ready ?";
    }
}

