/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.conditions;

import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.deployer.core.model.ResourceKind;
import io.hyscale.troubleshooting.integration.actions.ContactClusterAdministratorAction;
import io.hyscale.troubleshooting.integration.actions.PendingPvcAction;
import io.hyscale.troubleshooting.integration.models.ConditionNode;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.Node;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnyPendingPVCCondition
extends ConditionNode<TroubleshootingContext> {
    private static final Logger logger = LoggerFactory.getLogger(AnyPendingPVCCondition.class);
    private Predicate<TroubleshootingContext> pendingPvcCondition;
    @Autowired
    private PendingPvcAction pendingPvcAction;
    @Autowired
    private ContactClusterAdministratorAction contactClusterAdministratorAction;

    @PostConstruct
    public void init() {
        this.pendingPvcCondition = context -> {
            List<TroubleshootingContext.ResourceInfo> resourceData = context.getResourceInfos().get(ResourceKind.PERSISTENT_VOLUME_CLAIM.getKind());
            if (resourceData == null || resourceData.isEmpty()) {
                logger.debug("No PVC's found for service {}", (Object)context.getServiceMetadata().getServiceName());
                return false;
            }
            Object obj = context.getAttribute(FailedResourceKey.FAILED_POD);
            if (obj == null) {
                String describe = this.describe();
                logger.debug("Cannot find any failed pod for {}", (Object)describe);
                return false;
            }
            V1Pod pod = (V1Pod)FailedResourceKey.FAILED_POD.getKlazz().cast(obj);
            List podPvcList = pod.getSpec().getVolumes().stream().map(each -> each.getPersistentVolumeClaim() != null && each.getPersistentVolumeClaim().getClaimName() != null ? each.getPersistentVolumeClaim().getClaimName() : null).collect(Collectors.toList());
            List pvcList = resourceData.stream().filter(each -> {
                if (each != null && each.getResource() instanceof V1PersistentVolumeClaim) {
                    V1PersistentVolumeClaim persistentVolumeClaim = (V1PersistentVolumeClaim)each.getResource();
                    return podPvcList.contains(persistentVolumeClaim.getMetadata().getName());
                }
                return false;
            }).map(each -> (V1PersistentVolumeClaim)each.getResource()).collect(Collectors.toList());
            if (pvcList == null || pvcList.isEmpty()) {
                logger.debug("PVC List if found empty for service {}", (Object)context.getServiceMetadata().getServiceName());
                return false;
            }
            return pvcList.stream().filter(each -> each instanceof V1PersistentVolumeClaim).anyMatch(each -> {
                V1PersistentVolumeClaim persistentVolumeClaim = each;
                String pvcPhase = persistentVolumeClaim.getStatus().getPhase();
                return "Pending".equals(pvcPhase);
            });
        };
    }

    @Override
    public boolean decide(TroubleshootingContext context) throws HyscaleException {
        return this.pendingPvcCondition.test(context);
    }

    @Override
    public Node<TroubleshootingContext> onSuccess() {
        return this.pendingPvcAction;
    }

    @Override
    public Node<TroubleshootingContext> onFailure() {
        return this.contactClusterAdministratorAction;
    }

    @Override
    public String describe() {
        return "Are there any pending pvc's ? ";
    }
}

