/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.builder;

import io.hyscale.commons.exception.HyscaleError;
import io.hyscale.commons.exception.HyscaleException;
import io.hyscale.commons.models.AnnotationKey;
import io.hyscale.commons.models.K8sAuthorisation;
import io.hyscale.commons.models.ServiceMetadata;
import io.hyscale.commons.utils.FieldSelectorUtil;
import io.hyscale.commons.utils.ResourceSelectorUtil;
import io.hyscale.deployer.core.model.ResourceKind;
import io.hyscale.deployer.services.handler.ResourceHandlers;
import io.hyscale.deployer.services.handler.ResourceLifeCycleHandler;
import io.hyscale.deployer.services.handler.impl.V1DeploymentHandler;
import io.hyscale.deployer.services.handler.impl.V1EventHandler;
import io.hyscale.deployer.services.handler.impl.V1StorageClassHandler;
import io.hyscale.deployer.services.provider.K8sClientProvider;
import io.hyscale.deployer.services.util.KubernetesResourceUtil;
import io.hyscale.troubleshooting.integration.errors.TroubleshootErrorCodes;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.hyscale.troubleshooting.integration.spring.TroubleshootingConfig;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class TroubleshootingContextCollector {
    private static final Logger logger = LoggerFactory.getLogger(TroubleshootingContextCollector.class);
    @Autowired
    private K8sClientProvider k8sClientProvider;
    @Autowired
    private TroubleshootingConfig troubleshootingConfig;
    private List<String> troubleshootResources = Arrays.asList(ResourceKind.STATEFUL_SET.getKind(), ResourceKind.DEPLOYMENT.getKind(), ResourceKind.REPLICA_SET.getKind(), ResourceKind.POD.getKind(), ResourceKind.PERSISTENT_VOLUME_CLAIM.getKind());

    public TroubleshootingContext build(@NonNull ServiceMetadata serviceMetadata, @NonNull K8sAuthorisation k8sAuthorisation, @NonNull String namespace) throws HyscaleException {
        TroubleshootingContext context = new TroubleshootingContext();
        try {
            ApiClient apiClient = this.k8sClientProvider.get(k8sAuthorisation);
            context.setServiceMetadata(serviceMetadata);
            context.setTrace(this.troubleshootingConfig.isTrace());
            long start = System.currentTimeMillis();
            context.setResourceInfos(this.filter(this.getResources(serviceMetadata, apiClient, namespace)));
            if (context.isTrace()) {
                logger.debug("Time taken to build the context for service {} is {}", (Object)serviceMetadata.getServiceName(), (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (HyscaleException e) {
            logger.error("Error while preparing context to troubleshoot the service {}", (Object)serviceMetadata.getServiceName());
            throw e;
        }
        return context;
    }

    private Map<String, List<TroubleshootingContext.ResourceInfo>> filter(Map<String, List<TroubleshootingContext.ResourceInfo>> resources) {
        if (resources == null || resources.isEmpty()) {
            return resources;
        }
        List<TroubleshootingContext.ResourceInfo> statefulSetResourceInfos = resources.get(ResourceKind.STATEFUL_SET.getKind());
        List<TroubleshootingContext.ResourceInfo> deploymentResourceInfos = resources.get(ResourceKind.DEPLOYMENT.getKind());
        if (statefulSetResourceInfos != null && !statefulSetResourceInfos.isEmpty()) {
            return resources;
        }
        if (deploymentResourceInfos != null && !deploymentResourceInfos.isEmpty()) {
            List<TroubleshootingContext.ResourceInfo> replicaSetResourceInfos = resources.get(ResourceKind.REPLICA_SET.getKind());
            List<TroubleshootingContext.ResourceInfo> podResourceInfos = resources.get(ResourceKind.POD.getKind());
            ArrayList filteredPodResourceInfos = new ArrayList();
            deploymentResourceInfos.stream().filter((? super T each) -> each != null && each.getResource() instanceof V1Deployment).forEach(each -> {
                V1ReplicaSet replicaSet;
                String deploymentRevision = V1DeploymentHandler.getDeploymentRevision((V1Deployment)((V1Deployment)each.getResource()));
                if (StringUtils.isNotBlank((CharSequence)deploymentRevision) && (replicaSet = this.filterReplicaSetByrevision(replicaSetResourceInfos, deploymentRevision)) != null) {
                    String podTemplateHash = (String)replicaSet.getMetadata().getLabels().get("pod-template-hash");
                    filteredPodResourceInfos.addAll(this.filterPodsByHash(podResourceInfos, podTemplateHash));
                }
            });
            resources.remove(ResourceKind.POD.getKind());
            resources.put(ResourceKind.POD.getKind(), filteredPodResourceInfos);
            return resources;
        }
        return resources;
    }

    private Collection<? extends TroubleshootingContext.ResourceInfo> filterPodsByHash(List<TroubleshootingContext.ResourceInfo> podResourceInfos, String podTemplateHash) {
        ArrayList<TroubleshootingContext.ResourceInfo> result = new ArrayList<TroubleshootingContext.ResourceInfo>();
        if (podResourceInfos == null || podResourceInfos.isEmpty() || StringUtils.isBlank((CharSequence)podTemplateHash)) {
            return result;
        }
        for (TroubleshootingContext.ResourceInfo podResource : podResourceInfos) {
            V1Pod pod;
            if (podResource == null || podResource.getResource() == null || !((String)(pod = (V1Pod)podResource.getResource()).getMetadata().getLabels().get("pod-template-hash")).equals(podTemplateHash)) continue;
            result.add(podResource);
        }
        return result;
    }

    private V1ReplicaSet filterReplicaSetByrevision(List<TroubleshootingContext.ResourceInfo> replicaSetResourceInfos, String deploymentRevision) {
        TroubleshootingContext.ResourceInfo eachReplicaSet;
        if (replicaSetResourceInfos == null || replicaSetResourceInfos.isEmpty()) {
            return null;
        }
        V1ReplicaSet replicaSet = null;
        Iterator<TroubleshootingContext.ResourceInfo> iterator = replicaSetResourceInfos.iterator();
        while (iterator.hasNext() && ((replicaSet = (V1ReplicaSet)(eachReplicaSet = iterator.next()).getResource()) == null || !deploymentRevision.equals(replicaSet.getMetadata().getAnnotations().get(AnnotationKey.K8S_DEPLOYMENT_REVISION.getAnnotation())))) {
        }
        return replicaSet;
    }

    private Map<String, List<TroubleshootingContext.ResourceInfo>> getResources(@NonNull ServiceMetadata serviceMetadata, @NonNull ApiClient apiClient, @NonNull String namespace) throws HyscaleException {
        List storageClassResourceInfoList;
        String selector = ResourceSelectorUtil.getSelector((String)serviceMetadata.getAppName(), (String)serviceMetadata.getEnvName(), (String)serviceMetadata.getServiceName());
        List<ResourceLifeCycleHandler> handlerList = this.getResourceHandlers();
        if (handlerList == null || handlerList.isEmpty()) {
            logger.error("Error while fetching resource lifecycle handler ");
            throw new HyscaleException((HyscaleError)TroubleshootErrorCodes.ERROR_WHILE_BUILDING_RESOURCES);
        }
        V1EventHandler eventHandler = (V1EventHandler)ResourceHandlers.getHandlerOf((String)ResourceKind.EVENT.getKind());
        HashMap<String, List<TroubleshootingContext.ResourceInfo>> resourceMap = new HashMap<String, List<TroubleshootingContext.ResourceInfo>>();
        handlerList.stream().forEach(each -> {
            List resourceList = null;
            try {
                resourceList = each.getBySelector(apiClient, selector, true, namespace);
            }
            catch (HyscaleException e) {
                logger.debug("Error while fetching resource {} in namespace {} of selector {}", new Object[]{each.getKind(), namespace, selector, e});
            }
            if (resourceList != null && !resourceList.isEmpty()) {
                ArrayList resourceInfoList = new ArrayList();
                resourceList.stream().forEach(eachResource -> {
                    TroubleshootingContext.ResourceInfo resourceInfo = new TroubleshootingContext.ResourceInfo();
                    try {
                        V1ObjectMeta v1ObjectMeta = KubernetesResourceUtil.getObjectMeta((Object)eachResource);
                        resourceInfo.setResource(eachResource);
                        resourceInfo.setEvents(eventHandler.getBySelector(apiClient, this.getFieldSelector(v1ObjectMeta.getName(), namespace), false, namespace));
                    }
                    catch (HyscaleException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        logger.debug("Error while fetching resource {} logs in namespace {}", eachResource.getClass(), (Object)namespace);
                    }
                    resourceInfoList.add(resourceInfo);
                });
                if (!resourceInfoList.isEmpty()) {
                    resourceMap.put(each.getKind(), resourceInfoList);
                }
            }
        });
        V1StorageClassHandler storageClassHandler = (V1StorageClassHandler)ResourceHandlers.getHandlerOf((String)ResourceKind.STORAGE_CLASS.getKind());
        List storageClasses = storageClassHandler.getAll(apiClient);
        if (storageClasses != null && !storageClasses.isEmpty() && (storageClassResourceInfoList = storageClasses.stream().map(each -> {
            TroubleshootingContext.ResourceInfo resourceInfo = new TroubleshootingContext.ResourceInfo();
            resourceInfo.setResource(each);
            return resourceInfo;
        }).collect(Collectors.toList())) != null && !storageClassResourceInfoList.isEmpty()) {
            resourceMap.put(ResourceKind.STORAGE_CLASS.getKind(), storageClassResourceInfoList);
        }
        return resourceMap;
    }

    private List<ResourceLifeCycleHandler> getResourceHandlers() {
        return ResourceHandlers.getAllHandlers().stream().filter((? super T each) -> this.troubleshootResources.contains(each.getKind())).collect(Collectors.toList());
    }

    private String getFieldSelector(String name, String namespace) {
        HashMap<V1EventHandler.EventFieldKey, String> fieldMap = new HashMap<V1EventHandler.EventFieldKey, String>();
        fieldMap.put(V1EventHandler.EventFieldKey.INVOLVED_OBJECT_NAME, name);
        fieldMap.put(V1EventHandler.EventFieldKey.INVOLVED_OBJECT_NAMESPACE, namespace);
        return FieldSelectorUtil.getSelectorFromFieldMap(fieldMap);
    }
}

