/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.actions;

import io.hyscale.commons.config.SetupConfig;
import io.hyscale.troubleshooting.integration.models.AbstractedErrorMessage;
import io.hyscale.troubleshooting.integration.models.ActionNode;
import io.hyscale.troubleshooting.integration.models.DiagnosisReport;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.kubernetes.client.openapi.models.V1Event;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class ImagePullBackOffAction
extends ActionNode<TroubleshootingContext> {
    private static final String FAILED = "Failed";
    private static final String IMAGE_NOT_FOUND = "manifest for .* not found";
    private static final String INVALID_CREDENTIALS = ".* unauthorized: incorrect username or password";
    private static final String AUTHORIZATION_REQUIRED = ".* unauthorized: authentication required";
    private static final Pattern imageNotFoundPattern = Pattern.compile("manifest for .* not found");
    private static final Pattern invalidCredentialsPattern = Pattern.compile(".* unauthorized: incorrect username or password");
    private static final Pattern authorisationRequiredPattern = Pattern.compile(".* unauthorized: authentication required");

    @Override
    public void process(TroubleshootingContext context) {
        Object obj = context.getAttribute(FailedResourceKey.FAILED_POD_EVENTS);
        if (obj != null) {
            List eventList = (List)FailedResourceKey.FAILED_POD_EVENTS.getKlazz().cast(obj);
            if (eventList != null && !eventList.isEmpty()) {
                boolean actedOn = false;
                for (V1Event event : eventList) {
                    if (!FAILED.equals(event.getReason())) continue;
                    DiagnosisReport report = new DiagnosisReport();
                    if (imageNotFoundPattern.matcher(event.getMessage()).find()) {
                        report.setReason(AbstractedErrorMessage.FIX_IMAGE_NAME.formatReason(context.getServiceMetadata().getServiceName()));
                        report.setRecommendedFix(AbstractedErrorMessage.FIX_IMAGE_NAME.formatMessage(context.getServiceMetadata().getServiceName()));
                        context.addReport(report);
                        actedOn = true;
                        break;
                    }
                    if (!invalidCredentialsPattern.matcher(event.getMessage()).find() && !authorisationRequiredPattern.matcher(event.getMessage()).find()) continue;
                    report.setReason(AbstractedErrorMessage.INVALID_PULL_REGISTRY_CREDENTIALS.getMessage());
                    report.setRecommendedFix(AbstractedErrorMessage.INVALID_PULL_REGISTRY_CREDENTIALS.formatMessage(SetupConfig.getMountOfDockerConf((String)(SetupConfig.USER_HOME_DIR + "/.docker/config"))));
                    context.addReport(report);
                    actedOn = true;
                    break;
                }
                if (!actedOn) {
                    context.addReport(this.getDefaultReport());
                }
            }
        } else {
            context.addReport(this.getDefaultReport());
        }
    }

    @Override
    public String describe() {
        return "Please check your image name & tag & target registry credentials";
    }

    private DiagnosisReport getDefaultReport() {
        DiagnosisReport report = new DiagnosisReport();
        report.setRecommendedFix(AbstractedErrorMessage.IMAGEPULL_BACKOFF_ACTION.formatMessage(SetupConfig.getMountOfDockerConf((String)(SetupConfig.USER_HOME_DIR + "/.docker/config"))));
        report.setReason(AbstractedErrorMessage.IMAGEPULL_BACKOFF_ACTION.getReason());
        return report;
    }
}

